!= ʹϢ롼
!
!= Routines for radiation calculation
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA, Satoshi NODA, Yoshiyuki O. TAKAHASHI
! Version::   $Id: rad_utils.f90,v 1.7 2012/10/08 12:48:45 yot Exp $ 
! Tag Name::  $Name: dcpam5-20140630-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module rad_utils
  !
  != ʹϢ롼
  !
  != Routines for radiation calculation
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! 
  !
  !== Procedures List
  !
  ! RadDTempDt        :: ͥեåˤ벹Ѳη׻
  ! RadFluxOutput     :: ͥեåν
  ! ------------            :: ------------
  ! RadDTempDt        :: Calculate temperature tendency with radiation flux
  ! RadFluxOutput     :: Output radiation fluxes
  !
  !== NAMELIST
  !
  ! NAMELIST#rad_utils_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! ʪ
  ! Physical and mathematical constants settings
  !
  use constants0, only: &
    & PI, &                 ! $ \pi $.
                            ! ߼Ψ. Circular constant
    & StB
                            ! $ \sigma_{SB} $ .
                            ! ƥեܥĥޥ.
                            ! Stefan-Boltzmann constant

  ! ʪ
  ! Physical constants settings
  !
  use constants, only: &
    & Grav, &
                            ! $ g $ [m s-2]. 
                            ! ϲ®. 
                            ! Gravitational acceleration
    & CpDry
                            ! $ C_p $ [J kg-1 K-1]. 
                            ! 絤갵Ǯ. 
                            ! Specific heat of air at constant pressure


  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: RadDTempDt
  public :: RadDTempDtforNHM2DWrapper
  public :: RadFluxOutput
  public :: RadUtilsInit


  ! ѿ
  ! Public variables
  !
  logical, save, public:: rad_utils_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  ! ѿ
  ! Private variables
  !


  character(*), parameter:: module_name = 'rad_utils'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140630-2 $' // &
    & '$Id: rad_utils.f90,v 1.7 2012/10/08 12:48:45 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine RadDTempDt( &
    & xyr_RadLFlux, xyr_RadSFlux, xyr_Press, & ! (in)
    & xyz_DTempDtRadL, xyz_DTempDtRadS &       ! (out)
    & )
    !
    ! ͤˤ벹ѲΨ׻ޤ. 
    ! 
    ! Temperature tendency with radiation is calculated. 
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut


    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux
    real(DP), intent(in):: xyr_RadSFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Shortwave (insolation) flux
    real(DP), intent(in):: xyr_Press    (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(out):: xyz_DTempDtRadL (0:imax-1, 1:jmax, 1:kmax)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with longwave
    real(DP), intent(out):: xyz_DTempDtRadS (0:imax-1, 1:jmax, 1:kmax)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with shortwave

    ! ѿ
    ! Work variables
    !
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. rad_utils_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    ! Ψα黻
    ! Calculate radiation cooling rate
    !
    do k = 1, kmax
      xyz_DTempDtRadL(:,:,k) = &
        & (     xyr_RadLFlux(:,:,k-1) - xyr_RadLFlux(:,:,k) ) &
        &   / ( xyr_Press(:,:,k-1)    - xyr_Press(:,:,k) ) &
        &   / CpDry * Grav

      xyz_DTempDtRadS(:,:,k) = &
        & (     xyr_RadSFlux(:,:,k-1) - xyr_RadSFlux(:,:,k) ) &
        &   / ( xyr_Press(:,:,k-1)    - xyr_Press(:,:,k) ) &
        &   / CpDry * Grav
    end do


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'DTempDtRadL' , xyz_DTempDtRadL )
    call HistoryAutoPut( TimeN, 'DTempDtRadS' , xyz_DTempDtRadS )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine RadDTempDt

  !--------------------------------------------------------------------------------------

  subroutine RadDTempDtforNHM(                        &
    & xyr_RadLFlux, xyr_RadSFlux, r_Height, xyz_Dens, & ! (in)
    & xyz_DTempDtRadL, xyz_DTempDtRadS                & ! (out)
    & )
    !
    ! ϳطϤˤͤˤ벹ѲΨ׻ޤ. 
    ! 
    ! Temperature tendency with radiation is calculated for non-hydrodynamic system. 
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut


    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux
    real(DP), intent(in):: xyr_RadSFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Shortwave (insolation) flux
    real(DP), intent(in):: r_Height                       (0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(in):: xyz_Dens     (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(out):: xyz_DTempDtRadL (0:imax-1, 1:jmax, 1:kmax)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with longwave
    real(DP), intent(out):: xyz_DTempDtRadS (0:imax-1, 1:jmax, 1:kmax)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with shortwave

    ! ѿ
    ! Work variables
    !
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. rad_utils_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    ! Ψα黻
    ! Calculate radiation cooling rate
    !
    do k = 1, kmax
      xyz_DTempDtRadL(:,:,k) = &
        &   - ( xyr_RadLFlux(:,:,k) - xyr_RadLFlux(:,:,k-1) ) &
        &   / (   r_Height      (k) -   r_Height      (k-1) ) &
        &   / ( CpDry * xyz_Dens(:,:,k) )

      xyz_DTempDtRadS(:,:,k) = &
        &   - ( xyr_RadSFlux(:,:,k) - xyr_RadSFlux(:,:,k-1) ) &
        &   / (   r_Height      (k) -   r_Height      (k-1) ) &
        &   / ( CpDry * xyz_Dens(:,:,k) )
    end do


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'DTempDtRadL' , xyz_DTempDtRadL )
    call HistoryAutoPut( TimeN, 'DTempDtRadS' , xyz_DTempDtRadS )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine RadDTempDtforNHM

  !--------------------------------------------------------------------------------------

  subroutine RadDTempDtforNHM2DWrapper(             &
    & xr_RadLFlux, xr_RadSFlux, r_Height, xz_Dens,  & ! (in)
    & xz_DTempDtRadL, xz_DTempDtRadS                & ! (out)
    & )
    !
    ! ͤˤ벹ѲΨ׻ޤ. 
    ! 
    ! Temperature tendency with radiation is calculated. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xr_RadLFlux (0:imax-1, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux
    real(DP), intent(in):: xr_RadSFlux (0:imax-1, 0:kmax)
                              ! û () եå. 
                              ! Shortwave (insolation) flux
    real(DP), intent(in):: r_Height    (0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(in):: xz_Dens     (0:imax-1, 1:kmax)
    real(DP), intent(out):: xz_DTempDtRadL (0:imax-1, 1:kmax)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with longwave
    real(DP), intent(out):: xz_DTempDtRadS (0:imax-1, 1:kmax)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with shortwave

    ! ѿ
    ! Work variables
    !
    real(DP) :: xyr_RadLFlux   (0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyr_RadSFlux   (0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyz_Dens       (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_DTempDtRadL(0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_DTempDtRadS(0:imax-1, 1:jmax, 1:kmax)


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. rad_utils_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    xyr_RadLFlux(:,1,:) = xr_RadLFlux(:,:)
    xyr_RadSFlux(:,1,:) = xr_RadSFlux(:,:)
    xyz_Dens    (:,1,:) = xz_Dens    (:,:)

    call RadDTempDtforNHM(                              &
      & xyr_RadLFlux, xyr_RadSFlux, r_Height, xyz_Dens, & ! (in)
      & xyz_DTempDtRadL, xyz_DTempDtRadS                & ! (out)
      & )

    xz_DTempDtRadL(:,:) = xyz_DTempDtRadL(:,1,:)
    xz_DTempDtRadS(:,:) = xyz_DTempDtRadS(:,1,:)


  end subroutine RadDTempDtforNHM2DWrapper

  !-------------------------------------------------------------------

  subroutine RadFluxOutput(                          &
    & xyr_RadSUwFlux, xyr_RadSDwFlux,                & ! (in)
    & xyr_RadLUwFlux, xyr_RadLDwFlux,                & ! (in)
    & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux,        & ! (in)
    & xy_DSurfTempDt, xyz_DTempDt                    & ! (in)
    & )
    !
    ! ͥեå (xyr_RadSFlux, xyr_RadLFlux) 
    ! ˤĤ, ¾ΰѤ, ϤԤ. 
    !
    ! Radiation fluxes (xyr_RadSFlux, xyr_RadLFlux) are
    ! corrected by using other arguments, and the corrected values are output.
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyr_RadSUwFlux  (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Upward shortwave (insolation) flux
    real(DP), intent(in):: xyr_RadSDwFlux  (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Downward shortwave (insolation) flux

    real(DP), intent(in):: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Upward longwave flux
    real(DP), intent(in):: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Downward longwave flux
    real(DP), intent(in):: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! 
    real(DP), intent(in):: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! 

    real(DP), intent(in):: xy_DSurfTempDt  (0:imax-1, 1:jmax)
                              ! ɽ̲ѲΨ. 
                              ! Surface temperature tendency
    real(DP), intent(in):: xyz_DTempDt     (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{T}{t} $ . Ѳ (K s-1)
                              ! Temperature tendency (K s-1)

    ! ϤΤκѿ
    ! Work variables for output
    !
    real(DP):: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
                              ! û () եå. 
                              ! Shortwave (insolation) flux
    real(DP):: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux
    real(DP):: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with longwave
    real(DP):: xyr_RadLUwFluxCor(0:imax-1, 1:jmax, 0:kmax)
                              ! 줿Ĺȥեå. 
                              ! Corrected longwave flux
    real(DP):: xyr_RadLDwFluxCor(0:imax-1, 1:jmax, 0:kmax)
                              ! 줿Ĺȥեå. 
                              ! Corrected longwave flux
    real(DP):: xyr_RadLFluxCor  (0:imax-1, 1:jmax, 0:kmax)
                              ! 줿Ĺȥեå. 
                              ! Corrected longwave flux

    ! ѿ
    ! Work variables
    !
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. rad_utils_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    xyr_RadSFlux     = xyr_RadSUwFlux     - xyr_RadSDwFlux
    xyr_RadLFlux     = xyr_RadLUwFlux     - xyr_RadLDwFlux
    xyra_DelRadLFlux = xyra_DelRadLUwFlux - xyra_DelRadLDwFlux


    ! Ĺȥեå ( ɽեåʬ )
    ! Correct longwave flux ( amount of surface flux )
    !
    ! Lines commented out below will be deleted soon (yot, 2010/10/31).
!!$    do k = 0, kmax
!!$      xyr_RadLFluxCor (:,:,k) = &
!!$        &     xyr_RadLFlux (:,:,k) &
!!$        &   + xyra_DelRadLFlux(:,:,k,0) * xy_DSurfTempDt (:,:) * DelTime
!!$    end do
!!$    do k = 0, kmax
!!$      xyr_RadLFluxCor(:,:,k) = &
!!$        &   xyr_RadLFlux(:,:,k) &
!!$        & + (   xy_DSurfTempDt     * xyra_DelRadLFlux(:,:,k,0)   &
!!$        &     + xyz_DTempDt(:,:,1) * xyra_DelRadLFlux(:,:,k,1) ) &
!!$        &   * DelTime
!!$    end do
    do k = 0, kmax
      xyr_RadLUwFluxCor(:,:,k) =                                   &
        &   xyr_RadLUwFlux(:,:,k)                                  &
        & + (   xy_DSurfTempDt     * xyra_DelRadLUwFlux(:,:,k,0)   &
        &     + xyz_DTempDt(:,:,1) * xyra_DelRadLUwFlux(:,:,k,1) ) &
        &   * DelTime
      xyr_RadLDwFluxCor(:,:,k) =                                   &
        &   xyr_RadLDwFlux(:,:,k)                                  &
        & + (   xy_DSurfTempDt     * xyra_DelRadLDwFlux(:,:,k,0)   &
        &     + xyz_DTempDt(:,:,1) * xyra_DelRadLDwFlux(:,:,k,1) ) &
        &   * DelTime
    end do
    xyr_RadLFluxCor = xyr_RadLUwFluxCor - xyr_RadLDwFluxCor


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'OLR', xyr_RadLFluxCor(:,:,kmax) )
    call HistoryAutoPut( TimeN, 'SLR', xyr_RadLFluxCor(:,:,0)    )
    call HistoryAutoPut( TimeN, 'OSR', xyr_RadSFlux   (:,:,kmax) )
    call HistoryAutoPut( TimeN, 'SSR', xyr_RadSFlux   (:,:,0)    )
    call HistoryAutoPut( TimeN, 'RadLUWFLX', xyr_RadLUwFluxCor )
    call HistoryAutoPut( TimeN, 'RadLDWFLX', xyr_RadLDwFluxCor )
    call HistoryAutoPut( TimeN, 'RadSUWFLX', xyr_RadSUwFlux    )
    call HistoryAutoPut( TimeN, 'RadSDWFLX', xyr_RadSDwFlux    )


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'OLRB', xyr_RadLFlux(:,:,kmax) )
    call HistoryAutoPut( TimeN, 'SLRB', xyr_RadLFlux(:,:,0)    )
    call HistoryAutoPut( TimeN, 'OSRB', xyr_RadSFlux(:,:,kmax) )
    call HistoryAutoPut( TimeN, 'SSRB', xyr_RadSFlux(:,:,0)    )
    call HistoryAutoPut( TimeN, 'RadLUWFLXB', xyr_RadLUwFlux )
    call HistoryAutoPut( TimeN, 'RadLDWFLXB', xyr_RadLDwFlux )
    call HistoryAutoPut( TimeN, 'RadSUWFLXB', xyr_RadSUwFlux )
    call HistoryAutoPut( TimeN, 'RadSDWFLXB', xyr_RadSDwFlux )


    ! Ĺȥեå ( ɽեåʬ )
    ! Correct longwave flux ( amount of surface flux )
    !
    ! Lines commented out below will be deleted soon (yot, 2010/10/31).
!!$    do k = 0, kmax
!!$      xyr_RadLFluxCor (:,:,k) = &
!!$        &     xyr_RadLFlux (:,:,k) &
!!$        &   + xyra_DelRadLFlux(:,:,k,0) * xy_DSurfTempDt (:,:) * 2.0d0 * DelTime
!!$    end do
!!$    do k = 0, kmax
!!$      xyr_RadLFluxCor(:,:,k) = &
!!$        &   xyr_RadLFlux(:,:,k) &
!!$        & + (   xy_DSurfTempDt     * xyra_DelRadLFlux(:,:,k,0)   &
!!$        &     + xyz_DTempDt(:,:,1) * xyra_DelRadLFlux(:,:,k,1) ) &
!!$        &   * 2.0_DP * DelTime
!!$    end do
    do k = 0, kmax
      xyr_RadLUwFluxCor(:,:,k) =                                   &
        &   xyr_RadLUwFlux(:,:,k)                                  &
        & + (   xy_DSurfTempDt     * xyra_DelRadLUwFlux(:,:,k,0)   &
        &     + xyz_DTempDt(:,:,1) * xyra_DelRadLUwFlux(:,:,k,1) ) &
        &   * 2.0_DP * DelTime
      xyr_RadLDwFluxCor(:,:,k) =                                   &
        &   xyr_RadLDwFlux(:,:,k)                                  &
        & + (   xy_DSurfTempDt     * xyra_DelRadLDwFlux(:,:,k,0)   &
        &     + xyz_DTempDt(:,:,1) * xyra_DelRadLDwFlux(:,:,k,1) ) &
        &   * 2.0_DP * DelTime
    end do
    xyr_RadLFluxCor = xyr_RadLUwFluxCor - xyr_RadLDwFluxCor


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'OLRA', xyr_RadLFluxCor(:,:,kmax) )
    call HistoryAutoPut( TimeN, 'SLRA', xyr_RadLFluxCor(:,:,0)    )
    call HistoryAutoPut( TimeN, 'OSRA', xyr_RadSFlux   (:,:,kmax) )
    call HistoryAutoPut( TimeN, 'SSRA', xyr_RadSFlux   (:,:,0)    )
    call HistoryAutoPut( TimeN, 'RadLUWFLXA', xyr_RadLUwFluxCor )
    call HistoryAutoPut( TimeN, 'RadLDWFLXA', xyr_RadLDwFluxCor )
    call HistoryAutoPut( TimeN, 'RadSUWFLXA', xyr_RadSUwFlux    )
    call HistoryAutoPut( TimeN, 'RadSDWFLXA', xyr_RadSDwFlux    )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine RadFluxOutput

  !-------------------------------------------------------------------

  subroutine RadUtilsInit
    !
    ! rad_utils ⥸塼νԤޤ. 
    ! NAMELIST#rad_utils_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "rad_utils" module is initialized. 
    ! "NAMELIST#rad_utils_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ʸ ; Declaration statements
    !

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read


    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /rad_utils_nml/ &
!!$      & DiffFact
!!$      & DelTimeLongValue, DelTimeLongUnit, &
!!$      & DelTimeShortValue, DelTimeShortUnit, &
!!$!
!!$      & LongBandNum, &
!!$      & LongAbsorpCoefQVap, LongAbsorpCoefDryAir, &
!!$      & LongBandWeight, LongPathLengthFact, &
!!$!
!!$      & ShortBandNum, &
!!$      & ShortAbsorpCoefQVap, ShortAbsorpCoefDryAir, &
!!$      & ShortBandWeight, ShortSecScat, &
!!$      & ShortAtmosAlbedo, &
!!$!
!!$      & RstInputFile, RstOutputFile
          !
          ! ǥեͤˤĤƤϽ³ "rad_utils#RadInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "rad_utils#RadInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( rad_utils_inited ) return


    ! ǥեͤ
    ! Default values settings
    !

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml,                     & ! (in)
!!$        & nml = rad_utils_nml,            & ! (out)
!!$        & iostat = iostat_nml )             ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'OLR', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'outgoing longwave', 'W m-2' )
    call HistoryAutoAddVariable( 'SLR', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface longwave', 'W m-2' )
    call HistoryAutoAddVariable( 'OSR', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'outgoing shortwave', 'W m-2' )
    call HistoryAutoAddVariable( 'SSR', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface shortwave', 'W m-2' )

    call HistoryAutoAddVariable( 'RadLUWFLX', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'upward longwave flux', 'W m-2' )
    call HistoryAutoAddVariable( 'RadLDWFLX', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'downward longwave flux', 'W m-2' )
    call HistoryAutoAddVariable( 'RadSUWFLX', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'upward shortwave flux', 'W m-2' )
    call HistoryAutoAddVariable( 'RadSDWFLX', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'downward shortwave flux', 'W m-2' )

    call HistoryAutoAddVariable( 'OLRB', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'outgoing longwave', 'W m-2' )
    call HistoryAutoAddVariable( 'SLRB', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface longwave', 'W m-2' )
    call HistoryAutoAddVariable( 'OSRB', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'outgoing shortwave', 'W m-2' )
    call HistoryAutoAddVariable( 'SSRB', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface shortwave', 'W m-2' )

    call HistoryAutoAddVariable( 'RadLUWFLXB', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'upward longwave flux', 'W m-2' )
    call HistoryAutoAddVariable( 'RadLDWFLXB', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'downward longwave flux', 'W m-2' )
    call HistoryAutoAddVariable( 'RadSUWFLXB', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'upward shortwave flux', 'W m-2' )
    call HistoryAutoAddVariable( 'RadSDWFLXB', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'downward shortwave flux', 'W m-2' )

    call HistoryAutoAddVariable( 'OLRA', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'outgoing longwave', 'W m-2' )
    call HistoryAutoAddVariable( 'SLRA', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface longwave', 'W m-2' )
    call HistoryAutoAddVariable( 'OSRA', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'outgoing shortwave', 'W m-2' )
    call HistoryAutoAddVariable( 'SSRA', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface shortwave', 'W m-2' )

    call HistoryAutoAddVariable( 'RadLUWFLXA', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'upward longwave flux', 'W m-2' )
    call HistoryAutoAddVariable( 'RadLDWFLXA', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'downward longwave flux', 'W m-2' )
    call HistoryAutoAddVariable( 'RadSUWFLXA', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'upward shortwave flux', 'W m-2' )
    call HistoryAutoAddVariable( 'RadSDWFLXA', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'downward shortwave flux', 'W m-2' )

    call HistoryAutoAddVariable( 'DTempDtRadL', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'long wave radiative heating rate', 'K s-1' )
    call HistoryAutoAddVariable( 'DTempDtRadS', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'short wave radiative heating rate', 'K s-1' )


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
!!$    call MessageNotify( 'M', module_name, 'DiffFact = %f', d = (/ DiffFact /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    rad_utils_inited = .true.

  end subroutine RadUtilsInit

  !-------------------------------------------------------------------

end module rad_utils
