# -*- coding: euc-jp -*-
require "gphys_const_v1.1"
require "gphys_methods_v1.4"
require "gphys_time"
require "numru/ggraph"
include NumRu


dir  = ARGV[0]
vname = ARGV[1]
hour = ARGV[2].to_i
yearhour = ARGV[3].to_i
#mon = ARGV[4].to_i

localtime = hour - yearhour
ls = GPhys::NetCDF_IO.open(dir+'/PlanetLonFromVE.nc','PlanetLonFromVE')


#title = 'time =' + hour.to_s + 'hours'  #MonNames[imon-1]
lsout = sprintf("%8.5f", ls.cut("time"=>hour).val[0])
title = 'Ls = ' + lsout.to_s + ' degree'

gphys = GPhys::NetCDF_IO.open(dir+'/'+vname+".nc", vname)


if vname == 'KMHF_d' then
  DCL.sgscmn(34) #Basic-Windspeed
elsif vname == 'NewmanF_d'
  DCL.sgscmn(34) #Basic-Windspeed
elsif vname == 'Tau'
  DCL.sgscmn(34) #Basic-Windspeed
elsif vname == 'SurfMajCompIce'
  DCL.sgscmn(27) #Basic->Blues
elsif vname == 'U'
  DCL.sgscmn(15)
elsif vname == 'V'
  DCL.sgscmn(14)
elsif vname == 'Geopotential'
  DCL.sgscmn(14)
end 

#< DCLΥץ >
DCL.gropn(2)
#DCL.sldiv('y',2,2)           # 2x2˲ʬ, 'y'=yoko: 墪墪...
DCL.sgpset('lcntl', false)   # ʸᤷʤ
DCL.sgpset('lfull',true)     # ɽ
DCL.uzfact(0.75)             # ɸʸ󥵥 0.75 
DCL.sgpset('lfprop',true)    # ץݡʥեȤȤ

#< GGraph ˤ  >
#GGraph.set_fig 'itr'=>10, 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[0,360,-90,90]
GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[0,360,-90,90]
#GGraph.set_map 'coast_world'=>true, 'grid'=>false
GGraph.set_axes('yside'=>'lr','xside'=>'tb')
GGraph.set_axes('xlabelint'=>90)
GGraph.set_axes('ylabelint'=>30)


gphysout = dcpam_lt( hour, gphys )


p "kokomade"
# ٥ѥۤ˻
# ѥ1¿ޡޤ

if vname == 'SurfTemp'
  levels = [140, 145, 150, 155, 160, 165, 170, 175, 180, 185, 190, 195, 200, 205, 210, 215, 220, 225, 230, 235, 240, 245, 250, 255, 260]
  patterns = [20999, 23999, 26999, 29999, 32999, 35999, 38999, 41999, 44999, 47999, 50999, 53999, 56999, 59999, 62999, 65999, 68999, 71999, 74999, 77999, 80999, 83999, 86999, 89999, 92999]
#  levels = [210,220,230,240,250,260,270,280,290,300]
#  patterns = [20999,30999,40999,45999,50999,55999,60999,70999,80999,85999,90999]
#elsif vname == 'Rain'
#  levels = [0,1e-5,2e-5,4e-5,8e-5,12e-5,16e-5,20e-5,24e-5,28e-5,32e-5]
#  patterns = [1,20999,30999,35999,40999,50999,60999,65999,70999,75999,80999,85999]
#elsif vname == 'SoilMoist'
#  levels = [0,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150]
#  patterns = [15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999]
#elsif vname == 'SurfSnow'
#  levels = [0,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150]
#  patterns = [15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999]
#elsif vname == 'OLR'
elsif vname == 'OLRA'
  levels = [100,120,140,160,180,200,220,240,260,280,300]
  patterns = [10999,15999,20999,25999,30999,35999,40999,50999,60999,70999,80999,90999]
elsif vname == 'KMHF_d'
  levels = [0.0e0,1.0e-10, 0.80e-8, 1.60e-8, 2.40e-8, 3.20e-8, 4.00e-8, 4.80e-8, 5.60e-8, 6.40e-8, 7.20e-8, 8.00e-8, 8.80e-8, 9.60e-8, 1.04e-7, 1.12e-7, 1.20e-7, 1.28e-7, 1.36e-7, 1.44e-7, 1.52e-7, 1.60e-7, 1.68e-7, 1.76e-7, 1.84e-7, 1.92e-7, 2.00e-7, 2.08e-7, 2.16e-7, 2.24e-7, 2.32e-7]
  patterns = [0, 10999, 13999, 16999, 19999, 22999, 25999, 28999, 31999, 34999, 37999, 40999, 43999, 46999, 49999, 52999, 55999, 58999, 61999, 64999, 67999, 70999, 73999, 76999, 79999, 82999, 85999, 88999, 91999, 94999,97999]
#  levels = [0.0e0, 0.80e-8, 1.60e-8, 2.40e-8, 3.20e-8, 4.00e-8, 4.80e-8, 5.60e-8, 6.40e-8, 7.20e-8, 8.00e-8, 8.80e-8, 9.60e-8, 1.04e-7, 1.12e-7, 1.20e-7, 1.28e-7, 1.36e-7, 1.44e-7, 1.52e-7, 1.60e-7, 1.68e-7, 1.76e-7, 1.84e-7, 1.92e-7, 2.00e-7, 2.08e-7, 2.16e-7, 2.24e-7, 2.32e-7]
#  patterns = [0, 10999, 13999, 16999, 19999, 22999, 25999, 28999, 31999, 34999, 37999, 40999, 43999, 46999, 49999, 52999, 55999, 58999, 61999, 64999, 67999, 70999, 73999, 76999, 79999, 82999, 85999, 88999, 91999]#, 94999]
  #levels = [0.0e0, 0.80e-8, 1.60e-8, 2.40e-8, 3.20e-8, 4.00e-8, 4.80e-8, 5.60e-8, 6.40e-8, 7.20e-8, 8.00e-8, 8.80e-8, 9.60e-8, 1.04e-7, 1.12e-7, 1.20e-7, 1.28e-7, 1.36e-7, 1.44e-7, 1.52e-7, 1.60e-7, 1.68e-7, 1.76e-7, 1.84e-7, 1.92e-7, 2.00e-7, 2.08e-7, 2.16e-7, 2.24e-7, 2.32e-7]
  #patterns = [14999, 20999, 23999, 26999, 29999, 32999, 35999, 38999, 41999, 44999, 47999, 50999, 53999, 56999, 59999, 62999, 65999, 68999, 71999, 74999, 77999, 80999, 83999, 86999, 89999, 92999, 95999, 96999, 97999, 98999]
elsif vname =='NewmanF_d'
  levels = [0.0e0,1.0e-10, 1.40e-8, 2.80e-8, 4.20e-8, 5.60e-8, 6.00e-8, 7.40e-8, 9.80e-8, 1.12e-7, 1.26e-7, 1.40e-7, 1.54e-7, 1.68e-7, 1.82e-7, 1.96e-7, 2.10e-7, 2.24e-7, 2.38e-7, 2.52e-7, 2.66e-7, 2.80e-7, 2.94e-7, 3.08e-7, 3.22e-7, 3.36e-7, 3.50e-7, 3.64e-7, 3.78e-7, 3.82e-7, 3.96e-7, 4.10e-7]
  patterns = [0, 10999, 13999, 16999, 19999, 22999, 25999, 28999, 31999, 34999, 37999, 40999, 43999, 46999, 49999, 52999, 55999, 58999, 61999, 64999, 67999, 70999, 73999, 76999, 79999, 82999, 85999, 88999, 91999, 94999, 98999]
#  levels = [0.0e0, 1.40e-8, 2.80e-8, 4.20e-8, 5.60e-8, 6.00e-8, 7.40e-8, 9.80e-8, 1.12e-7, 1.26e-7, 1.40e-7, 1.54e-7, 1.68e-7, 1.82e-7, 1.96e-7, 2.10e-7, 2.24e-7, 2.38e-7, 2.52e-7, 2.66e-7, 2.80e-7, 2.94e-7, 3.08e-7, 3.22e-7, 3.36e-7, 3.50e-7, 3.64e-7, 3.78e-7, 3.82e-7, 3.96e-7, 4.10e-7]
#  patterns = [0, 10999, 13999, 16999, 19999, 22999, 25999, 28999, 31999, 34999, 37999, 40999, 43999, 46999, 49999, 52999, 55999, 58999, 61999, 64999, 67999, 70999, 73999, 76999, 79999, 82999, 85999, 88999, 91999, 94999, 98999]
elsif vname == 'TauXB'
elsif vname == 'TauYB'
elsif vname == 'Tau'
  levels = [0.0e0,1.0e-10, 0.001, 0.002, 0.003, 0.004, 0.005, 0.006, 0.007, 0.008, 0.009, 0.010, 0.011, 0.012, 0.013, 0.014, 0.015, 0.016, 0.017, 0.018, 0.019, 0.020, 0.021, 0.022, 0.023, 0.024, 0.025, 0.026, 0.027, 0.028, 0.029, 0.030]
  patterns = [0, 10999, 13999, 16999, 19999, 22999, 25999, 28999, 31999, 34999, 37999, 40999, 43999, 46999, 49999, 52999, 55999, 58999, 61999, 64999, 67999, 70999, 73999, 76999, 79999, 82999, 85999, 88999, 91999, 94999, 98999]
  #levels = [0.0e0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.006, 0.007, 0.008, 0.009, 0.010, 0.011, 0.012, 0.013, 0.014, 0.015, 0.016, 0.017, 0.018, 0.019, 0.020, 0.021, 0.022, 0.023, 0.024, 0.025, 0.026, 0.027, 0.028, 0.029, 0.030]
  #patterns = [14999, 20999, 23999, 26999, 29999, 32999, 35999, 38999, 41999, 44999, 47999, 50999, 53999, 56999, 59999, 62999, 65999, 68999, 71999, 74999, 77999, 80999, 83999, 86999, 89999, 92999, 95999, 96999, 97999, 98999]
elsif vname == 'SurfMajCompIce'
  levels = [0,1.0e-1, 20, 40, 60, 80, 100, 120, 140, 160, 180, 200, 220, 240, 260, 280, 300, 320, 340, 360, 380, 400, 420, 440, 460, 480, 500, 520, 540, 560, 580, 600, 620, 640, 680, 700, 720, 740, 760, 780, 800, 820, 840, 860, 880, 900, 920, 940]
  patterns = [0, 16999, 18999, 20999, 22999, 24999, 26999, 28999, 30999, 32999, 34999, 36999, 38999, 40999, 42999, 44999, 46999, 48999, 50999, 52999, 54999, 56999, 58999, 60999, 62999, 64999, 66999, 68999, 70999, 72999, 74999, 75999, 76999, 77999, 78999, 79999, 80999, 81999, 82999, 83999, 84999, 85999, 86999, 87999, 88999, 89999, 90999]
elsif vname == 'Ps'
  levels = [100, 125, 150, 175, 200, 225, 250, 275, 300, 325, 350, 375, 400, 425, 450, 475, 500, 525, 550, 575, 600, 625, 650, 675, 700, 725, 750, 775, 800, 825, 850, 875, 900, 925, 950, 975, 1000, 1025, 1050, 1075, 1100, 1125, 1150, 1175, 1200, 1225, 1250, 1275, 1300, 1325, 1350, 1375, 1400, 1425, 1450, 1475, 1500]
  patterns = [0, 20999, 21999, 22999, 23999, 24999, 25999, 26999, 27999, 28999, 29999, 30999, 31999, 32999, 33999, 34999, 35999, 36999, 37999, 38999, 39999, 40999, 42999, 44999, 46999, 48999, 50999, 52999, 54999, 56999, 58999, 60999, 62999, 64999, 66999, 68999, 70999, 71999, 72999, 73999, 74999, 75999, 76999, 77999, 78999, 79999, 80999, 81999, 82999, 83999, 84999, 85999, 86999, 87999, 88999, 89999, 90999]
#  levels = [100, 150, 200, 250, 300, 350, 400, 450, 500, 550, 600, 650, 700, 750, 800, 850, 900, 950, 1000, 1050, 1100, 1150, 1200, 1250, 1300, 1350, 1400, 1450, 1500]
#  patterns = [0, 20999, 23999, 26999, 29999, 32999, 35999, 38999, 41999, 44999, 47999, 50999, 53999, 56999, 59999, 62999, 65999, 68999, 71999, 74999, 77999, 80999, 83999, 86999, 89999, 92999, 95999,96999, 97999]
elsif vname == 'U'
 levels = [-30, -25, -20, -15, -10, -5, 0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80]
 patterns = [10999, 14999,18999, 22999, 26999, 30999, 34999, 35999, 39444, 43999, 47999, 51999, 55999, 59999, 63999, 67999, 71999, 75999, 79999, 83999, 87999, 91999, 95999]
elsif vname == 'V'
 levels = [-50, -45, -40, -35, -30, -25, -20, -15, -10, -5, 0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50]
  patterns = [10999, 14999, 19999, 24999, 29999, 34999, 39999, 44999, 49999, 54999, 55999, 60999, 65999, 70999, 75999, 80999, 85999, 90999, 95999, 99999]
elsif vname == 'Geopotential'
  levels = [-10000, -9000, -8000, -7000, -6000, -5000, -4000, -3000, -2000, -1000, 0, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000, 10000]
  patterns = [10999, 14999, 19999, 24999, 29999, 34999, 39999, 44999, 49999, 54999, 55999, 60999, 65999, 70999, 75999, 80999, 85999, 90999, 95999, 99999]
end

if vname == 'Rain'
  gphysout= gphysout / 2.5e6
end


GGraph.tone( gphysout, true, 'lev'=>levels, 'pat'=>patterns, 'map_axes'=>true, 'annotate'=>false )
GGraph.color_bar
if vname == 'KMHF_d' or vname == 'NewmanF_d' or vname == 'Ps'
  ice = GPhys::NetCDF_IO.open(dir+'/SurfMajCompIce.nc', 'SurfMajCompIce')
  iceout = dcpam_lt(hour, ice)
#  iceout = iceout * (-1)
#  DCL.uepset('LTONE',false)
#  tlev1 = 10.0
#  tlev2 = DCL.glpget('RMISS')

  levels = [0,1.0e-1, 1, 100,200, 300,400,500,600,700, 800, 900, 940]
#p tlev2
#  DCL::uestlv(tlev1,tlev2,301)
GGraph.contour(iceout,false,'levels'=>levels,'line_type'=>2,'label'=>false)
#  DCL::uetone(iceout.val)
#  DCL::udcntr(iceout.val) 

#GGraph.tone(iceout,false,'ltone'=>false)
  DCL::ueitlv
end
topog = GPhys::NetCDF_IO.open('sp_for_Mars_T021_MGS.nc','topog')
levels = 0*(NArray.float(7).indgen!)
mn = DCL.udpget('indxmn')
GGraph.set_contour_levels('levels'=>levels, 'index'=>mn )
GGraph.contour(topog,false)

DCL::uxmttl('T', title, 1.0)
#DCL::uxmttl('T', title, 0.0)



DCL.grcls

