require './gphys_const_v1.1'
require "numru/ggraph"
include NumRu
include NMath

#########################################################################################

def ecmwf_clim_mean_with_mon_mean( iyrs, iyre, imon, gphys )

  time = gphys.coord('time').val

  for iyr in iyrs..iyre
    t = ( iyr - 1957 ) * 12 + imon - ( 9 - 1 )

    if iyr == iyrs
      gphysout = gphys.cut('time'=>time[t])
    else
      gphysout = gphysout + gphys.cut('time'=>time[t])
    end
  end
  gphysout = gphysout / ( iyre - iyrs + 1 )

  return gphysout

end

#########################################################################################

def ncep_clim_mean_with_mon_mean( iyrs, iyre, imon, gphys )

  time = gphys.coord('time').val

  for iyr in iyrs..iyre
    t = ( iyr - 1948 ) * 12 + imon - 1

    if iyr == iyrs
      gphysout = gphys.cut('time'=>time[t])
    else
      gphysout = gphysout + gphys.cut('time'=>time[t])
    end
  end
  gphysout = gphysout / ( iyre - iyrs + 1 )

  return gphysout

end

#########################################################################################

def dcpam_clim_mon_mean( iyrs, iyre, imon, gphys )

  daysOfYear = 0
  DaysOfMonth.each do |i|
    daysOfYear += i
  end

  time = gphys.coord('time').val

  for iyr in iyrs..iyre
    t = daysOfYear*(iyr-1)
    for i in 1..imon-1
      t = t + DaysOfMonth[i-1]
    end

    ts = t
    te = t + DaysOfMonth[imon-1]

    ts = ts * DataNumOfDay
    te = te * DataNumOfDay - 1


#    if iyr == iyrs
#      gphysout = gphys.cut('time'=>time[ts]..time[te]).mean('time')
#    else
#      gphysout = gphysout + gphys.cut('time'=>time[ts]..time[te]).mean('time')
#    end


#    gphysout1 = gphys.cut('time'=>time[ts]).copy
#    for t in ts+1..te
#      gphysout1 = gphysout1 + gphys.cut('time'=>time[t])
#    end
#    gphysout1 = gphysout1 / ( te - ts + 1 )
#    if iyr == iyrs
#      gphysout = gphysout1
#    else
#      gphysout = gphysout + gphysout1
#    end


    gphysout1 = gphys.cut('time'=>time[ts]).copy
#    dt = 1
    dt = ( te - ts + 1 ) / 3
#    dt = te - ts + 1
    t1 = ts
    t2 = ts
    while true
      t1 = t2+1
      t2 = t1+dt-1
      if t2 >= te then
        break
      end
      gphysout1 = gphysout1 + gphys.cut('time'=>time[t1]..time[t2]).sum('time')
    end
    t2 = te
    gphysout1 = gphysout1 + gphys.cut('time'=>time[t1]..time[t2]).sum('time')
    gphysout1 = gphysout1 / ( te - ts + 1 )
    if iyr == iyrs
      gphysout = gphysout1
    else
      gphysout = gphysout + gphysout1
    end


  end
  gphysout = gphysout / ( iyre - iyrs + 1 )

  return gphysout

end

#########################################################################################

def calc_msf( gphys )

gphysout = calc_msf_core( gphys, 'lat', 'level' )

return gphysout

end

#########################################################################################

def calc_msf_core( gphys, namelat, namelev )

rmiss = gphys.get_att('missing_value')[0]

gphyscopied = gphys.copy

z = gphyscopied.axis(namelev).pos.convert_units( Units['Pa'] )
z.long_name = 'pressure'
gphyscopied.axis(namelev).set_pos(z)

km    = gphyscopied.shape[1]
lat   = gphyscopied.coord(namelat).val
level = gphyscopied.coord(namelev).val


gphysout = gphyscopied.copy


#mask                  = gphyscopied.ne(rmiss)
#gphyscopied[mask.not] = 0.0

#mask        = gphyscopied.val.valid?
mask        = gphyscopied.val.get_mask
gphyscopied = gphyscopied.val.set_missing_value(0.0).all_valid


if level[0] > level[1] then
  gphysout[true,km-1] = gphyscopied[true,km-1] * level[km-1] / Grav * 2 * PI * RPlanet * cos( lat[true] * PI / 180.0 )
  k = km-1-1
  while k >= 0
    gphysout[true,k] = gphysout[true,k+1] + ( gphyscopied[true,k] + gphyscopied[true,k+1] ) * 0.5 * ( level[k] - level[k+1] ) / Grav * 2 * PI * RPlanet * cos( lat[true] * PI / 180.0 )
  k -= 1
  end
elsif
  gphysout[true,0] = gphyscopied[true,0] * level[0] / Grav * 2 * PI * RPlanet * cos( lat[true] * PI / 180.0 )
  k = 0+1
  while k < km
    gphysout[true,k] = gphysout[true,k-1] + ( gphyscopied[true,k] + gphyscopied[true,k-1] ) * 0.5 * ( level[k] - level[k-1] ) / Grav * 2 * PI * RPlanet * cos( lat[true] * PI / 180.0 )
  k += 1
  end
end

gphysoutNaMiss = gphysout.val.set_mask(mask)
gphysout[true,true] = gphysoutNaMiss[true,true]

gphysout = gphysout * 1.0e-8

gphysout.long_name = 'mass stream function'
gphysout.units     = '1e8 kg/s'

return gphysout

end

#########################################################################################

def calc_angmom( gphys )

gphysout = calc_angmom_core( gphys, 'lat', 'level' )

return gphysout

end

#########################################################################################

def calc_angmom_core( gphys, namelat, namelev )

rmiss = gphys.get_att('missing_value')[0]

gphyscopied = gphys.copy

z = gphyscopied.axis(namelev).pos.convert_units( Units['Pa'] )
z.long_name = 'pressure'
gphyscopied.axis(namelev).set_pos(z)

#mask                  = gphyscopied.ne(rmiss)
#gphyscopied[mask.not] = rmiss #0.0

mask = gphyscopied.val.get_mask

jm    = gphyscopied.shape[0]
km    = gphyscopied.shape[1]
lat   = gphyscopied.coord(namelat).val
level = gphyscopied.coord(namelev).val

gphysout = gphyscopied.copy


k = 0
while k < km
  j = 0
  while j < jm
    if mask[j,k] == 1 then
      gphysout[j,k] = ( RPlanet * cos( lat[j] * PI / 180.0 ) * Omega + gphysout.val[j,k] ) * RPlanet * cos( lat[j] * PI / 180.0 )
    end
    j = j + 1
  end
  k = k + 1
end

gphysout = gphysout * 1.0e-8

gphysout.long_name = 'angular momentum'
gphysout.units     = '1e8 m2 s-1'

return gphysout

end

#########################################################################################

def calc_qsat_tetens( gphys )

gphysout = gphys.copy

z = gphysout.axis('level').pos.convert_units( Units['Pa'] )
z.long_name = 'pressure'
gphysout.axis('level').set_pos(z)

km    = gphysout.shape[2]
level = gphysout.coord('level').val


gasRUniv   = 8.314
molWtDry   = 28.964e-3
molWtWet   = 18.01528e-3
es0        = 611.0
latentHeat = 2.5e6
gasRWet    = gasRUniv / molWtWet
epsV       = molWtWet / molWtDry

gphysout = epsV * es0 * ( latentHeat / gasRWet * ( 1.0/273.0 - 1.0/gphysout ) ).exp

k = 0
while k < km
  gphysout[true,true,k,true] = gphysout[true,true,k,true] / level[k]
  k += 1
end

gphysout.long_name = 'saturation specific humidity'
gphysout.units     = '1'

return gphysout

end

#########################################################################################

