# -*- coding: euc-jp -*-
require "numru/ggraph"
include NumRu


dir   = ARGV[0]
vname = ARGV[1]
ihr   = ARGV[2].to_i

gphys = GPhys::NetCDF_IO.open(dir+'/'+vname+".nc", vname)


#DCL.sgscmn(14)


#< DCLΥץ >
DCL.gropn(2)
#DCL.sldiv('y',2,2)           # 2x2˲ʬ, 'y'=yoko: 墪墪...
DCL.sgpset('lcntl', false)   # ʸᤷʤ
DCL.sgpset('lfull',true)     # ɽ
DCL.uzfact(0.75)             # ɸʸ󥵥 0.75 
DCL.sgpset('lfprop',true)    # ץݡʥեȤȤ

#< GGraph ˤ  >
GGraph.set_fig 'itr'=>1, 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[0,360,-90,90]
#GGraph.set_map 'coast_world'=>true, 'grid'=>false
#GGraph.set_map 'coast_world'=>false, 'grid'=>false
GGraph.set_axes('xlabelint'=>90)
GGraph.set_axes('ylabelint'=>30)

time = gphys.coord('time').val
gphysout = gphys.cut('time'=>time[ihr]).cut('sig'=>0.6)

if vname == 'Vor'
  gphysout = gphysout * 1.0e5
  gphysout.units = '1e-5 s-1'
end


# ٥ѥۤ˻
# ѥ1¿ޡޤ

levels = [0.00,0.05,0.10,0.15,0.20,0.25,0.30,0.35,0.40,0.45,0.50,0.55,0.60,0.65,0.70,0.75,0.80,0.85,0.90,0.95,1.00,1.05]
patterns = [1,10999,12999,15999,20999,22999,25999,30999,32999,35999,40999,42999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999]

GGraph.tone( gphysout, true, 'lev'=>levels, 'pat'=>patterns, 'map_axes'=>true, 'annotate'=>false )
GGraph.contour( gphysout, false, 'lev'=>levels, 'index'=>3, 'annotate'=>false, 'label'=>false )
GGraph.color_bar

title = sprintf( "%0#{3}d day", time[ihr] )

DCL::uxmttl('T', ' ', 1.0)
DCL::uxmttl('T', title, -1.0)

DCL.grcls

