= 概要

DCPAM5 で Taguchi and Yoden (2002a) (以降, TY02a と書く)
あるいは Taguchi, Yamaga, and Yoden (2001) (以降, TYY01 と書く)
を再現するための
ソースコード, 設定ファイルなど.
dcpam5-20121128-mod で動作確認している.

= 注意点

この版はとりあえず動くものをアーカイブする意味合いが強い.
ソースコードが汚かったり, 不要なファイルが含まれていたりする.

= 使い方

== ソースファイルの設置とビルド

src ディレクトリに移動する.
このパッケージを ~/work/misc/dcpam/taguchi-yoden_2002a に
置いたとすると, 以下のようにコピーする.

cd main
cp dcpam_main.f90 dcpam_main.f90.org
cp Makefile Makefile.org
cp ~/work/misc/dcpam/taguchi-yoden_2002a/dcpam_main.f90 .
cp ~/work/misc/dcpam/taguchi-yoden_2002a/dcpam_init_data_surface_height.f90 .
cp ~/work/misc/dcpam/taguchi-yoden_2002a/Makefile_main Makefile


cd ../prepare_data
cp Makefile Makefile.org
cp ~/work/misc/dcpam/taguchi-yoden_2002a/surface_height_data.f90 .
cp ~/work/misc/dcpam/taguchi-yoden_2002a/Makefile_prepare_data Makefile

cd ../surface_properties
cp surface_properties.f90 surface_properties.f90.org
cp ~/work/misc/dcpam/taguchi-yoden_2002a/surface_properties.f90 .

cd ../held_suarez_1994
cp Makefile Makefile.org
cp ~/work/misc/dcpam/taguchi-yoden_2002a/ty2002a_forcing_*.f90 .
cp ~/work/misc/dcpam/taguchi-yoden_2002a/Makefile_ty02a Makefile

ここで, 

* ty2002a_forcing_original-but-include-bug.f90
  * オリジナルのソースをもとに論文の結果を再現するようにしたもの
* ty2002a_forcing_all-fixed-as-of-paper.f90
  * 論文のモデル記述に忠実に実装したもの

である.
"original" のほうはバグや様々な問題を含んでいるため,
既存の論文を再現する目的以外では使用するべきではない.
詳細はモデル記述ドキュメントのほうを参照のこと.
新たに研究を始める場合は "all-fixed" のほうを使用するべきである.

以下のリンクを張る.

ln -s ty2002a_forcing_all-fixed-as-of-paper.f90 ty2002a_forcing.f90

cd ..
make

== 実験 (TYY01 標準実験)

cd ../../
mkdir -p dcpam5-exp3/ty02a
cd dcpam5-exp3/ty02a
mkdir bin conf

cp ../../src3/main/{dcpam_main,init_data,dcpam_init_data_surface_height} bin/
cp ~/work/misc/dcpam/taguchi-yoden_2002a/*{T21L42,T21}.conf conf/

./bin/dcpam_init_data_surface_height -N=conf/surface_height_T21.conf

ここで生成されたファイル surface_height_T21.nc を地形として使用する.

#./bin/init_data -N=./conf/init_data_ty2002a_T21L42.conf

このバージョンでは
初期値ファイルはコマンドで作成するのではなく, 
別途作成しておいたものを使う
地形に合った初期値を生成する機能をまだ実装していないため.
もし平地用の初期値で走らせた場合は, 山が高い場合に計算が落ちる.

cp ~/work/misc/dcpam/taguchi-yoden_2002a/init_T21L42_h01000.nc .

ちなみに, この初期値は, 平地から初めて,
10 日に 100 m ずつ山の標高を上げて作ったものである.
そのため, 静止状態ではなく, ある程度スピンアップが進んだものである.
そのため, dcpam_ty02a_T21L42_restart_for_h01000.conf では
RestartTimeValue = 110.0 となっている.

TYY01 標準実験の主な設定は以下の通り
* 積分時間 1200 日 (解析には最後の 1000 日を使用)
* 時間ステップ 20 分
* 山の標高 1000 m
  * surface_properties_nml にて MountHeight = 1000.0 にする
* 季節変化なし (永続的な冬至)
  * ty2002a_forcing_nml にて DayInAYear をゼロか負に設定する

#./bin/dcpam_main -N=./conf/dcpam_ty02a_T21L42.conf
./bin/dcpam_main -N=./conf/dcpam_ty02a_T21L42_restart_for_h01000.conf

== 実験 (TY02a 標準実験)

TY02a の標準実験では, TYY01 に比べて以下の条件が異なる
* 季節変化あり
  * DayInAYear = 360.0
* 積分時間 100 年 (= 36000 日)

== 解析

cp ~/work/misc/dcpam/taguchi-yoden_2002a/draw_figs_TYY01.sh .
cp ~/work/misc/dcpam/taguchi-yoden_2002a/gpconv_sig2p .

draw_figs_TYY01.sh の内容のうち,
データのある場所のパスを正しいものに書き換える.

./draw_figs_TYY01.sh

p 座標への変換でメモリ不足で落ちた場合は,
TIMERANGE で間引くように設定する.

実行に成功すると
TYY01_*.{ps,png} が生成される.
TYY01 の論文の対応する図と比較することができる.

サンプルの図を sample_figs/ に格納してある.

== html の自動生成

未実装.


= 参考文献

* Taguchi, M., Yamaga, T., & Yoden, S. (2001). Internal Variability of the Troposphere–Stratosphere Coupled System Simulated in a Simple Global Circulation Model. Journal of the Atmospheric Sciences, 58(21), 3184–3203. doi:10.1175/1520-0469(2001)058<3184:IVOTTS>2.0.CO;2

* Taguchi, M., & Yoden, S. (2002). Internal Interannual Variability of the Troposphere – Stratosphere Coupled System in a Simple Global Circulation Model . Part I : Parameter Sweep Experiment. Journal of the Atmospheric Sciences, 3021–3036.
