module gms_math_bar
  use datatype
  use mem_manager
  implicit none
  interface bar_x
    module procedure bar_x_x
    module procedure bar_x_xy
    module procedure bar_x_xz
    module procedure bar_x_xyz
  end interface

  interface bar_y
    module procedure bar_y_y
    module procedure bar_y_xy
    module procedure bar_y_yz
    module procedure bar_y_xyz
  end interface

  interface bar_z
    module procedure bar_z_z
    module procedure bar_z_xz
    module procedure bar_z_yz
    module procedure bar_z_xyz
  end interface

contains
  function bar_x_x(input) result(output)
    type(var_x), intent(in) :: input
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    output%id = new_id

    output%grid(1) = mod( input%grid(1) + 1, 2 )
    output%grid(2) = input%grid(2)
    output%grid(3) = input%grid(3)

    work_x(lb_axis1+output%grid(1) : ub_axis1-1+output%grid(1),:,:,new_id) & 
         = (   work_x(lb_axis1+1:ub_axis1,:,:,input%id) &
             + work_x(lb_axis1:ub_axis1-1,:,:,input%id) ) / 2.0D0 
  end function bar_x_x

  function bar_x_xy(input) result(output)
    type(var_xy), intent(in) :: input
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    output%id = new_id

    output%grid(1) = mod( input%grid(1) + 1, 2 )
    output%grid(2) = input%grid(2)
    output%grid(3) = input%grid(3)

    work_xy(lb_axis1+output%grid(1) : ub_axis1-1+output%grid(1),:,:,new_id) & 
         = (   work_xy(lb_axis1+1:ub_axis1,:,:,input%id) &
             + work_xy(lb_axis1:ub_axis1-1,:,:,input%id) ) / 2.0D0 
  end function bar_x_xy

  function bar_x_xz(input) result(output)
    type(var_xz), intent(in) :: input
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    output%id = new_id

    output%grid(1) = mod( input%grid(1) + 1, 2 )
    output%grid(2) = input%grid(2)
    output%grid(3) = input%grid(3)

    work_xz(lb_axis1+output%grid(1) : ub_axis1-1+output%grid(1),:,:,new_id) & 
         = (   work_xz(lb_axis1+1:ub_axis1,:,:,input%id) &
             + work_xz(lb_axis1:ub_axis1-1,:,:,input%id) ) / 2.0D0 
  end function bar_x_xz

  function bar_x_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    output%id = new_id

    output%grid(1) = mod( input%grid(1) + 1, 2 )
    output%grid(2) = input%grid(2)
    output%grid(3) = input%grid(3)

    work_xyz(lb_axis1+output%grid(1) : ub_axis1-1+output%grid(1),:,:,new_id) & 
         = (   work_xyz(lb_axis1+1:ub_axis1,:,:,input%id) &
             + work_xyz(lb_axis1:ub_axis1-1,:,:,input%id) ) / 2.0D0 
  end function bar_x_xyz

  function bar_y_y(input) result(output)
    type(var_y), intent(in) :: input
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    output%id = new_id

    output%grid(1) = input%grid(1)
    output%grid(2) = mod( input%grid(2) + 1, 2 )
    output%grid(3) = input%grid(3)

    work_y(:,lb_axis2+output%grid(2) : ub_axis2-1+output%grid(2),:,new_id) & 
         = (   work_y(:,lb_axis2+1:ub_axis2,:,input%id) &
             + work_y(:,lb_axis2:ub_axis2-1,:,input%id) ) / 2.0D0 
  end function bar_y_y

  function bar_y_xy(input) result(output)
    type(var_xy), intent(in) :: input
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    output%id = new_id

    output%grid(1) = input%grid(1)
    output%grid(2) = mod( input%grid(2) + 1, 2 )
    output%grid(3) = input%grid(3)

    work_xy(:,lb_axis2+output%grid(2) : ub_axis2-1+output%grid(2),:,new_id) & 
         = (   work_xy(:,lb_axis2+1:ub_axis2,:,input%id) &
             + work_xy(:,lb_axis2:ub_axis2-1,:,input%id) ) / 2.0D0 
  end function bar_y_xy

  function bar_y_yz(input) result(output)
    type(var_yz), intent(in) :: input
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    output%id = new_id

    output%grid(1) = input%grid(1)
    output%grid(2) = mod( input%grid(2) + 1, 2 )
    output%grid(3) = input%grid(3)

    work_yz(:,lb_axis2+output%grid(2) : ub_axis2-1+output%grid(2),:,new_id) & 
         = (   work_yz(:,lb_axis2+1:ub_axis2,:,input%id) &
             + work_yz(:,lb_axis2:ub_axis2-1,:,input%id) ) / 2.0D0 
  end function bar_y_yz

  function bar_y_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    output%id = new_id

    output%grid(1) = input%grid(1)
    output%grid(2) = mod( input%grid(2) + 1, 2 )
    output%grid(3) = input%grid(3)

    work_xyz(:,lb_axis2+output%grid(2) : ub_axis2-1+output%grid(2),:,new_id) & 
         = (   work_xyz(:,lb_axis2+1:ub_axis2,:,input%id) &
             + work_xyz(:,lb_axis2:ub_axis2-1,:,input%id) ) / 2.0D0 
  end function bar_y_xyz

  function bar_z_z(input) result(output)
    type(var_z), intent(in) :: input
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    output%id = new_id

    output%grid(1) = input%grid(1)
    output%grid(2) = input%grid(2)
    output%grid(3) = mod( input%grid(3) + 1, 2 )

    work_z(:,:,lb_axis3+output%grid(3) : ub_axis3-1+output%grid(3),new_id) & 
         = (   work_z(:,:,lb_axis3+1:ub_axis3,input%id) &
             + work_z(:,:,lb_axis3:ub_axis3-1,input%id) ) / 2.0D0
  end function bar_z_z

  function bar_z_xz(input) result(output)
    type(var_xz), intent(in) :: input
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    output%id = new_id

    output%grid(1) = input%grid(1)
    output%grid(2) = input%grid(2)
    output%grid(3) = mod( input%grid(3) + 1, 2 )

    work_xz(:,:,lb_axis3+output%grid(3) : ub_axis3-1+output%grid(3),new_id) & 
         = (   work_xz(:,:,lb_axis3+1:ub_axis3,input%id) &
             + work_xz(:,:,lb_axis3:ub_axis3-1,input%id) ) / 2.0D0
  end function bar_z_xz

  function bar_z_yz(input) result(output)
    type(var_yz), intent(in) :: input
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    output%id = new_id

    output%grid(1) = input%grid(1)
    output%grid(2) = input%grid(2)
    output%grid(3) = mod( input%grid(3) + 1, 2 )

    work_yz(:,:,lb_axis3+output%grid(3) : ub_axis3-1+output%grid(3),new_id) & 
         = (   work_yz(:,:,lb_axis3+1:ub_axis3,input%id) &
             + work_yz(:,:,lb_axis3:ub_axis3-1,input%id) ) / 2.0D0
  end function bar_z_yz

  function bar_z_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    output%id = new_id

    output%grid(1) = input%grid(1)
    output%grid(2) = input%grid(2)
    output%grid(3) = mod( input%grid(3) + 1, 2 )

    work_xyz(:,:,lb_axis3+output%grid(3) : ub_axis3-1+output%grid(3),new_id) & 
         = (   work_xyz(:,:,lb_axis3+1:ub_axis3,input%id) &
             + work_xyz(:,:,lb_axis3:ub_axis3-1,input%id) ) / 2.0D0
  end function bar_z_xyz

end module gms_math_bar
