!== dc_date_types#DC_DATETIME, dc_date_types#DC_DIFFTIME ѿʸѴ
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dcdatetimetochar.f90,v 1.3 2008-10-06 11:39:26 morikawa Exp $
! Tag Name::  $Name: gtool5-20090302 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006-. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! Υե󶡤³ dc_date ⥸塼ˤ󶡤ޤ
!

function DCDateTimeToChar(time) result(result)
  !
  ! dc_date_types#DC_DATETIME ѿʸѿѴ֤ޤ.
  ! 񼰤ϲΤ褦 JIS X 0301 δɽǤ.
  !
  !   YYYY-MM-DDThh:mm:ss.sTZD
  !
  ! YYYY ǯ, MM Ϸ, DD , hh ϻ, mm ʬ, ss.s ,
  ! TZD ϥॾɽޤ.
  !
  use dc_types, only: STRING, TOKEN, DP
  use dc_string, only: toChar, CPrintf, StoA
  use dc_date, only: Eval
  use dc_date_types, only: DC_DATETIME, &
    & MIN_SECONDS, HOUR_SECONDS, YEAR_MONTHS
  use dc_message, only: MessageNotify
  implicit none
  character(STRING):: result
  type(DC_DATETIME), intent(in):: time

  integer :: year, mon, day, hour, min, csec_len
  real(DP):: sec
  character(TOKEN) :: zone, csec
continue

  call Eval(time, &
    & year=year, mon=mon, day=day, hour=hour, min=min, sec=sec, zone=zone)

  csec = toChar(sec)
  if ( trim(csec) == '-0.' ) csec = '0.'
  do while ( index('123456789.', csec(len_trim(csec):len_trim(csec)) ) == 0 )
    if ( len_trim(csec) < 2 ) exit
    csec = csec(1:len_trim(csec)-1)
  end do
  if (int(sec) > -1 .and. int(sec) < 10)  csec = '0' // csec
  csec_len = len(trim(adjustl(csec)))
  if (csec(csec_len:csec_len) == '.') csec = csec(1:csec_len-1)

  result = CPrintf('%04d-%02d-%02dT%02d:%02d:%c%c', &
    & i=(/year, mon, day, hour, min/), &
    & c1=trim(csec), c2=trim(zone))

end function DCDateTimeToChar


function DCDiffTimeToChar(diff) result(result)
  !
  ! dc_date_types#DC_DIFFTIME ѿʸѿѴ֤ޤ.
  ! 񼰤ϰʲΤ褦ˤʤޤ.
  !
  !   +YYYY-MM-DDThh:mm:ss.s
  !   -YYYY-MM-DDThh:mm:ss.s
  !
  ! YYYY ǯ, MM Ϸ, DD , hh ϻ, mm ʬ, ss.s äɽޤ.
  ! , DD  2 Ķ礬ޤ.
  ! (dc_date_types#DC_DIFFTIME  X , X , ʤɤɽ뤿
  ! ΥǡʤΤ, ˷夲, ˷겼뤳Ȥ
  ! ޤ. ޤǯפξޤ. 1 ǯ 1 
  ! dc_date_types#DC_DATETIME ¦Ƿޤޤ).
  !
  ! ʤ, DCDiffTimeCreate ˤ, ñ̤ '1' Ȥ̵»֤
  ! , ʲΤ褦ʽ񼰤Ȥʤޤ. 
  ! 
  !   ss.s
  !
  use dc_types, only: STRING, TOKEN, DP
  use dc_string, only: toChar, CPrintf, StoA
  use dc_date, only: Eval
  use dc_date_types, only: DC_DIFFTIME
  use dc_scaledsec, only: assignment(=)
  implicit none
  character(STRING):: result
  type(DC_DIFFTIME), intent(in):: diff

  integer :: year, mon, day, hour, min, csec_len
  real(DP):: sec
  character(TOKEN) :: csec
  character(1) :: pm
continue

  if ( .not. diff % nondim_flag ) then
    call Eval(diff, year=year, mon=mon, day=day, hour=hour, min=min, sec=sec)

    if ( year < 0 .or. mon < 0 .or. day < 0 .or.  &
      &  hour < 0 .or. min < 0 .or. sec < 0         ) then
      year=abs(year) ; mon=abs(mon) ; day=abs(day)
      hour=abs(hour) ; min=abs(min) ; sec=abs(sec)
      pm = '-'
    else
      pm = '+'
    end if

    csec = toChar(sec)
    if ( trim(csec) == '-0.' ) csec = '0.'
    do while ( index('123456789.', csec(len_trim(csec):len_trim(csec)) ) == 0 )
      if ( len_trim(csec) < 2 ) exit
      csec = csec(1:len_trim(csec)-1)
    end do
    if (int(sec) > -1 .and. int(sec) < 10)  csec = '0' // csec
    csec_len = len(trim(adjustl(csec)))
    if (csec(csec_len:csec_len) == '.') csec = csec(1:csec_len-1)

    result = CPrintf('%c%04d-%02d-%02dT%02d:%02d:%c', &
      & i=(/year, mon, day, hour, min/), &
      & c1=pm, c2=trim(csec))
  else
    sec = diff % sec
    result = toChar( sec )
  end if

end function DCDiffTimeToChar

function DCDateTimeToCharCal(time, upcase) result(result)
  !
  ! dc_date_types#DC_DATETIME ѿʸˤ֤ޤ. 
  ! ߥݡȤƤϰʲ̤Ǥ. 
  ! 򼨤ѿ, ֤ʸǤ. 
  ! *upcase*  .true. Ϳˤ, ʸȤʤä֤ޤ. 
  !
  ! dc_date_types#CAL_CYCLIC    :: cyclic
  ! dc_date_types#CAL_NOLEAP    :: noleap
  ! dc_date_types#CAL_JULIAN    :: julian
  ! dc_date_types#CAL_GREGORIAN :: gregorian
  !
  !
  use dc_types, only: TOKEN
  use dc_present, only: present_and_true
  use dc_date_types, only: DC_DATETIME, &
    & CAL_CYCLIC, CAL_NOLEAP, CAL_JULIAN, CAL_GREGORIAN
  use dc_string, only: toUpper
  character(TOKEN) :: result
  type(DC_DATETIME), intent(in):: time
  logical, intent(in), optional:: upcase
continue
  select case( time % caltype )
  case(CAL_CYCLIC)
    result = 'cyclic'
  case(CAL_NOLEAP)
    result = 'noleap'
  case(CAL_JULIAN)
    result = 'julian'
  case(CAL_GREGORIAN)
    result = 'gregorian'
  case default
    result = 'none'
  end select

  if ( present_and_true(upcase) ) then
    call toUpper(result) ! (inout)
  end if

end function DCDateTimeToCharCal
