!--
! *** Caution!! ***
! 
! This file is generated from "gtool_historyauto_internal.rb2f90" by Ruby 1.8.5.
! Please do not edit this file directly.
!
! [JAPANESE]
!
!  !!! 
!
! Υե "gtool_historyauto_internal.rb2f90"  Ruby 1.8.5
! ˤäƼư줿եǤ.
! ΥեľԽޤ褦ꤤפޤ.
!
!
!++
!
!= gtool_historyauto ǻѤ, ѿ, ³
!= Internal constants, variables, procedures used in "gtool_historyauto"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: gtool_historyauto_internal.f90,v 1.2 2009-05-31 14:36:33 morikawa Exp $
! Tag Name::  $Name: gtool5-20090809 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved. 
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module gtool_historyauto_internal
  !
  != gtool_historyauto ǸƤФ, ѿ, ³
  != Constants, variable, procedures used in "gtool_historyauto" internally
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !

  ! gtool_history ⥸塼
  ! "gtool_history" module
  !
  use gtool_history, only: GT_HISTORY_AXIS, GT_HISTORY_VARINFO, GT_HISTORY

  ! NAMELIST λѤꤷҥȥǡϾѥ桼ƥƥ
  ! Utilities for history data output information management assuming use of NAMELIST
  !
  use gtool_history_nmlinfo, only: GTHST_NMLINFO

  ! NetCDF 饤֥ǵꤵμο
  ! Maximum number of dimensions prescribed by the NetCDF library
  !
  use netcdf_f77, only: NF_MAX_DIMS

  ! դӻμ갷
  ! Date and time handler
  !
  use dc_date_types, only: DC_DATETIME, DC_DIFFTIME
                              ! κɽǡ. 
                              ! Data type for difference about date and time
  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN, &   ! .   Keywords. 
    &                 STDERR     ! ɸ२顼.  Standard error output

  implicit none
  private
  public:: GT_HISTORY_AXIS_DATA, GT_HISTORY_MULTI
  public:: SLICE_INFO, AXES_WEIGHT, SPACE_AVR_INFO

  public:: HstVarsOutputCheck, HstFileCreate, AverageReduce

  ! 
  ! Number of dimensions
  !
  integer, save, public:: numdims

  ! ɸŤѿο
  ! Number of variables of axes weight
  !
  integer, save, public:: numwgts = 0

  ! ɸŤѿ
  ! Suffix of variables of axes weight
  !
  character(*), parameter, public:: wgtsuf = '_weight'

  ! ѿο
  ! Number of variables
  !
  integer, save, public:: numvars = 0

  ! 1 Ĥѿ¸ǽʼο
  ! Number of dimensions on which one variable can depend
  !
  integer, parameter, public:: MAX_DIMS_DEPENDED_BY_VAR = 7

  ! ϴֳ֤tǳäݤ, ;ȤƵƤϰ
  ! Allowable range of remainder of output interval divided by delta t
  !
  real(DP), parameter, public:: max_remainder_range = 1.0e-3_DP

  ! ϥեδܥ᥿ǡ
  ! Basic meta data for output file
  !
  character(STRING), save, public:: title_save
  character(STRING), save, public:: source_save
  character(STRING), save, public:: institution_save
  character(STRING), save, public:: conventions_save
  character(TOKEN),  save, public:: gt_version_save
  character(TOKEN),  save, public:: rank_save

  ! ǡ
  ! Time data
  !
!  integer, parameter, public:: save_tstepnum = 3
  integer, parameter, public:: save_tstepnum = 1
                              ! ¸֥ƥåפο. 
                              ! Number of saved time step
  type(DC_DIFFTIME), save, public:: saved_time(1:save_tstepnum)
  integer, save, public:: checked_tstepnum = 0
                              ! å줿֥ƥåפο. 
                              ! Number of checked time step
  integer, save, public:: checked_tstep_varnum = 0
                              ! å줿ѿο.  
                              ! Number of checked variables
  integer, save, public:: saved_tstep = 1
                              ! å줿֥ƥå. 
                              ! (HstVarsOutputCheck ǻѤ). 
                              ! 
                              ! Time step checked at previous time
                              ! (Used in "HstVarsOutputCheck"). 

  ! ñ (HistoryAutoCreate  dims ˤäƻꤵ줿)
  ! Unit of time (specified by "dims" of "HistoryAutoCreate")
  !
  character(TOKEN), save, public:: time_unit_bycreate = ''
  character(STRING), save, public:: time_unit_suffix = ''

  ! NAMELIST λѤꤷҥȥǡϾѥ桼ƥƥ 
  ! Utilities for history data output information management assuming use of NAMELIST
  !
  type(GTHST_NMLINFO), save, public:: gthstnml

  type GT_HISTORY_AXIS_DATA
    ! 
    ! ɸǡѤι¤
    ! Derived type for axes data
    !
    real(DP), pointer:: a_axis(:) =>null()
  end type GT_HISTORY_AXIS_DATA

  ! ɸ
  ! Information of axes
  !
  type(GT_HISTORY_AXIS), save, target, public:: gthst_axes(1:NF_MAX_DIMS)
  type(GT_HISTORY_AXIS_DATA), save, target, public:: data_axes(1:NF_MAX_DIMS)
  type(GT_HISTORY_AXIS_DATA), save, target, public:: data_axes_whole(1:NF_MAX_DIMS)
  type(GT_HISTORY_VARINFO), save, public:: gthst_weights(1:NF_MAX_DIMS)
  type(GT_HISTORY_AXIS_DATA), save, target, public:: data_weights(1:NF_MAX_DIMS)

  ! MPI Ϣξ
  ! Information about MPI
  !
  logical, save, public:: save_mpi_split  = .false.
  logical, save, public:: save_mpi_gather = .false.

  type GT_HISTORY_MULTI
    ! 
    ! GT_HISTORY ѿؤ¤
    ! Derived type for indication to "GT_HISTORY"
    !
    type(GT_HISTORY), pointer:: gthist =>null()
  end type GT_HISTORY_MULTI

  ! ѿ
  ! Information of variables
  !
  integer, parameter, public:: MAX_VARS = 256
                              ! ϲǽѿκ
                              ! Maximum value of output variables
  type(GT_HISTORY_VARINFO), save, public:: gthst_vars(1:MAX_VARS)
  character(TOKEN), save, public:: varname_vars(1:MAX_VARS) = ''
  type(GT_HISTORY_MULTI), save, public:: gthst_history_vars(1:MAX_VARS)
  logical, save, public:: output_valid_vars(1:MAX_VARS) = .false.
                              ! ѿϤͭݤ. 
                              ! Whether output of variables is valid or not. 
  logical, save, public:: create_timing_vars(1:MAX_VARS, 1:save_tstepnum) = .false.
                              ! ƻ֥ƥåפǤϥե뤫
                              ! Whether file is created or not at eath time step. 
  logical, save, public:: close_timing_vars(1:MAX_VARS, 1:save_tstepnum) = .false.
                              ! ƻ֥ƥåפǤϥե򥯥뤫
                              ! Whether file is closed or not at eath time step. 
  logical, save, public:: renew_timing_vars(1:MAX_VARS, 1:save_tstepnum) = .false.
                              ! ƻ֥ƥåפǤϥեƥץ󤹤뤫
                              ! Whether file is closed and opened or not at eath time step. 

  logical, save, public:: output_timing_vars(1:MAX_VARS, 1:save_tstepnum) = .false.
                              ! ƻ֥ƥåפǤϽϤԤݤ. 
                              ! Whether output is done or not at eath time step. 
  logical, save, public:: output_timing_avr_vars(1:MAX_VARS, 1:save_tstepnum) = .false.
                              ! ƻ֥ƥåפǤʿͽϤԤݤ. 
                              ! Whether output of averaged values is done or not at eath time step. 
  type(DC_DIFFTIME), save, public:: interval_time_vars(1:MAX_VARS)
                              ! ϻֳִ. 
                              ! Interval time of output. 
  type(DC_DIFFTIME), save, public:: prev_outtime_vars(1:MAX_VARS)
                              ! ˽Ϥ. 
                              ! Time of previous output
  logical, save, public:: tavr_vars(1:MAX_VARS) = .false.
                              ! ʿѥե饰. 
                              ! Flag for time average
  type(DC_DIFFTIME), save, public:: origin_time_vars(1:MAX_VARS)
                              ! ϳϻ. 
                              ! Start time of output
  type(DC_DIFFTIME), save, public:: terminus_time_vars(1:MAX_VARS)
                              ! ե򥯥. 
                              ! time of closure of file
  logical, save, public:: histaddvar_vars(1:MAX_VARS) = .false.
                              ! HistoryAddVariable Ѥߤɤ
                              ! Whether "HistoryAddVariable" is done or not.
  type(DC_DIFFTIME), save, public:: newfile_inttime_vars(1:MAX_VARS)
                              ! ե򿷵˺ľֳִ. 
                              ! Interval time of remake of file
  type(DC_DIFFTIME), save, public:: newfile_createtime_vars(1:MAX_VARS)
                              ! ե򿷵˺ľ. 
                              ! Time of remake of file
  type(DC_DIFFTIME), save, public:: zero_time
                              ! . Zero second

  type SLICE_INFO
    ! 
    ! ڤФѤι¤
    ! Derived type for information of slice of space
    !
    integer, pointer:: st(:) =>null()
                              ! γ. 
                              ! Start points of spaces. 
    integer, pointer:: ed(:) =>null()
                              ! νλ. 
                              ! End points of spaces. 
    integer, pointer:: sd(:) =>null()
                              ! ι. 
                              ! Strides of spaces
  end type SLICE_INFO

  ! ǡڤФ
  ! Information of slices of data
  !
  type(SLICE_INFO), save, target, public:: slice_vars(1:MAX_VARS)

  type AXES_WEIGHT
    ! 
    ! ɸŤ߾Ѥι¤
    ! Derived type for information of axes weight
    !
                        real(DP), pointer:: wgt1(:) =>null()
                    
    real(DP), pointer:: wgt2(:) =>null()
                    
    real(DP), pointer:: wgt3(:) =>null()
                    
    real(DP), pointer:: wgt4(:) =>null()
                    
    real(DP), pointer:: wgt5(:) =>null()
                    
    real(DP), pointer:: wgt6(:) =>null()
                    
    real(DP), pointer:: wgt7(:) =>null()
                    
  end type AXES_WEIGHT

  ! ɸŤ߾
  ! Information of axes weight
  !
  type(AXES_WEIGHT), save, target, public:: weight_vars(1:MAX_VARS)

  type SPACE_AVR_INFO
    ! 
    ! ʿѾѤι¤
    ! Derived type for information of average in space direction
    !
    logical, pointer:: avr(:) =>null()
                              ! ʿѲΥե饰. 
                              ! Flag of average. 
  end type SPACE_AVR_INFO

  ! ǡڤФ
  ! Information of slices of data
  !
  type(SPACE_AVR_INFO), save, target, public:: space_avr_vars(1:MAX_VARS)

  ! ϿѿƽϤ뤿Υե饰. 
  ! Flag for output all registered variables. 
  !
  logical, save, public:: all_output_save = .false.

  ! ѿϿϳꤵƤ뤫. 
  ! * HistoryAutoAllVarFix ƤФ .true. ˤʤ. 
  ! *  .true. ˤʤ, HistoryAutoAddVariable Ƥ֤ȤϤǤʤ. 
  ! 
  ! Whether register of variables is fixed. 
  ! * When "HistoryAutoAllVarFix" is called, this argument becomes .true.
  ! * Once this argument becomes .true., "HistoryAutoAddVariable" can not be called. 
  !
  logical, save, public:: flag_allvarfixed = .false.

  ! ե饰
  ! Initialization flag
  !
  logical, save, public:: initialized = .false.

  character(*), parameter, public:: sub_sname = "HistAuto"

  character(*), parameter, public:: version = &
    & '$Name: gtool5-20090809 $' // &
    & '$Id: gtool_historyauto_internal.f90,v 1.2 2009-05-31 14:36:33 morikawa Exp $'

  interface HstVarsOutputCheck
    module procedure HstVarsOutputCheck
  end interface

  interface HstFileCreate
    module procedure HstFileCreate
  end interface

  interface AverageReduce


    module procedure AverageReduceReal1


    module procedure AverageReduceReal2


    module procedure AverageReduceReal3


    module procedure AverageReduceReal4


    module procedure AverageReduceReal5


    module procedure AverageReduceReal6


    module procedure AverageReduceReal7


    module procedure AverageReduceDouble1


    module procedure AverageReduceDouble2


    module procedure AverageReduceDouble3


    module procedure AverageReduceDouble4


    module procedure AverageReduceDouble5


    module procedure AverageReduceDouble6


    module procedure AverageReduceDouble7


    module procedure AverageReduceInt1


    module procedure AverageReduceInt2


    module procedure AverageReduceInt3


    module procedure AverageReduceInt4


    module procedure AverageReduceInt5


    module procedure AverageReduceInt6


    module procedure AverageReduceInt7


  end interface

contains

  !-------------------------------------------------------------------
  !------------- ֥롼 ; Internal Subroutines -------------
  !-------------------------------------------------------------------

  subroutine HstVarsOutputCheck ( time, stime_index )
    !
    ! Ϳ줿 *time* ѿˤȤäƽϤΥߥ󥰤ɤ
    ! Ĵ output_timing_vars, output_timing_avr_vars, 
    ! create_timing_vars, close_timing_vars, renew_timing_vars, 
    ! ȿǤ, *time* б
    ! saved_time ź stime_index ֤ޤ. 
    ! 
    ! ޤ, եΥץ󥯥Υߥ󥰤Ǥ, 
    ! ⤳Υ֥롼ǹԤޤ. 
    !
    ! It is investigated whether "time" is output timing for 
    ! each variable, and the information is reflected to 
    ! "output_timing_vars", "output_timing_avr_vars",
    ! "create_timing_vars", "close_timing_vars", "renew_timing_vars".
    ! And index of array "saved_time" is returned to "stime_index". 
    ! 
    ! And if current time is timing of open/close of files, 
    ! they are done in this subroutine. 
    !
    use dc_trace, only: BeginSub, EndSub, DbgMessage
    use dc_error, only: StoreError, DC_NOERR
    use gtool_history, only: HistoryInitialized, HistoryClose
    use dc_date_types, only: DC_DIFFTIME
    use dc_date, only: operator(==), operator(>), operator(<), &
      & operator(>=), operator(<=), operator(-), DCDiffTimePutLine, &
      & EvalSec
    implicit none
    type(DC_DIFFTIME), intent(in):: time
                              ! ߻. Current time
    integer, intent(out):: stime_index

    integer:: tstep
    integer:: stat, i, startnum, endnum
    character(STRING):: cause_c
    character(*), parameter:: subname = "HstVarsOutputCheck"
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ""

    ! Ϳ줿郎åѤߤɤĴ٤
    ! Examine whether given time is already checked or not
    !
    TimeStepSearch: do
      do i = saved_tstep, checked_tstepnum
        if ( saved_time(i) == time ) then
          tstep = i
          exit TimeStepSearch
        end if
      end do
      do i = 1, saved_tstep - 1
        if ( saved_time(i) == time ) then
          tstep = i
          exit TimeStepSearch
        end if
      end do

      tstep = 0
      exit TimeStepSearch
    end do TimeStepSearch

    saved_tstep = tstep

    if ( saved_tstep /= 0 .and. checked_tstep_varnum == numvars ) then
      ! * output_timing_vars(:,saved_tstep) Ȥ.
      ! * saved_tstep  stime_index Ȥ֤. 

      stime_index = saved_tstep
      call DbgMessage( 'saved_tstep=<%d> is already checked.', &
        & i =(/ saved_tstep /) )
      goto 999
    end if

    ! å֥ƥåפ, ѿ ID 
    ! Configure checked time step, and variable ID
    !
    if ( saved_tstep /= 0 ) then
      startnum = checked_tstep_varnum + 1
      endnum   = numvars

      stime_index = saved_tstep
    else
      startnum = 1
      endnum   = numvars

      if ( save_tstepnum < 2 ) then
        checked_tstepnum = 1
        saved_time(checked_tstepnum) = time
        
        saved_tstep = checked_tstepnum
        stime_index = saved_tstep
        
      elseif ( .not. checked_tstepnum < save_tstepnum ) then
        create_timing_vars(:,1:checked_tstepnum-1) = create_timing_vars(:,2:checked_tstepnum)
        close_timing_vars(:,1:checked_tstepnum-1) = close_timing_vars(:,2:checked_tstepnum)
        renew_timing_vars(:,1:checked_tstepnum-1) = renew_timing_vars(:,2:checked_tstepnum)
        output_timing_vars(:,1:checked_tstepnum-1) = output_timing_vars(:,2:checked_tstepnum)
        output_timing_avr_vars(:,1:checked_tstepnum-1) = output_timing_avr_vars(:,2:checked_tstepnum)

        saved_time(1:checked_tstepnum-1) = saved_time(2:checked_tstepnum)
        saved_time(checked_tstepnum) = time
        
        saved_tstep = checked_tstepnum
        stime_index = saved_tstep

      else
        checked_tstepnum = checked_tstepnum + 1
        saved_time(checked_tstepnum) = time
        
        saved_tstep = checked_tstepnum
        stime_index = saved_tstep
      end if
    end if

    call DbgMessage( 'numvar=<%d:%d> in saved_tstep=<%d> will be checked from now.', &
      & i =(/ startnum, endnum, saved_tstep /) )


    ! * output_timing_vars(:,2:3)  output_timing_vars(:,1:2)  
    ! * saved_time(2:3)  saved_time(1:2)  
    ! * time  saved_time(3)  
    ! * saved_tstep = checked_tstepnum Ȥ. 
    ! * stime_index = saved_tstep Ȥ. 
    ! * ߥ󥰥å output_timing_vars(:,3)  

    create_timing_vars(startnum:endnum, checked_tstepnum:checked_tstepnum) = .false.
    close_timing_vars(startnum:endnum, checked_tstepnum:checked_tstepnum) = .false.
    renew_timing_vars(startnum:endnum, checked_tstepnum:checked_tstepnum) = .false.
    output_timing_vars(startnum:endnum, checked_tstepnum:checked_tstepnum) = .false.
    output_timing_avr_vars(startnum:endnum, checked_tstepnum:checked_tstepnum) = .false.

    do i = startnum, endnum

      if ( .not. output_valid_vars(i) ) cycle

      if ( origin_time_vars(i) > time ) cycle

      if (             origin_time_vars(i) <= time &
        &  .and.       (      terminus_time_vars(i) < zero_time &
        &                .or. terminus_time_vars(i) >= time      ) &
        &  .and. .not. histaddvar_vars(i)            ) then

        create_timing_vars(i,checked_tstepnum) = .true.

        if ( newfile_inttime_vars(i) > zero_time ) then
          newfile_createtime_vars(i) = time
        end if

        output_timing_vars(i,checked_tstepnum) = .true.
        output_timing_avr_vars(i,checked_tstepnum) = tavr_vars(i)
        cycle
      end if

      if ( terminus_time_vars(i) > zero_time .and. terminus_time_vars(i) < time ) then
        close_timing_vars(i,checked_tstepnum) = .true.
        output_timing_vars(i,checked_tstepnum) = .false.
        output_timing_avr_vars(i,checked_tstepnum) = .false.
        cycle
      end if

      ! * newfile_inttime_vars Ǥ, ԤäפʤȤޤԤʤ. 
      !   * ...
      !     * ˽Ϥ򵭲Ƥ. 
      !     * λȺλκ newfile_inttime_vars 
      !       礭ˤϸեĤ, ե. 

      if ( newfile_inttime_vars(i) > zero_time ) then
        if ( time - newfile_createtime_vars(i) >= newfile_inttime_vars(i) ) then
          renew_timing_vars(i,checked_tstepnum) = .true.

          output_timing_vars(i,checked_tstepnum) = .true.
          output_timing_avr_vars(i,checked_tstepnum) = tavr_vars(i)
          cycle
        end if
      end if

      if ( time - prev_outtime_vars(i) >= interval_time_vars(i) ) then
        output_timing_vars(i,checked_tstepnum) = .true.
        output_timing_avr_vars(i,checked_tstepnum) = tavr_vars(i)
        cycle
      end if

      output_timing_vars(i,checked_tstepnum) = .false.
      output_timing_avr_vars(i,checked_tstepnum) = tavr_vars(i)

    end do

    checked_tstep_varnum = numvars

999 continue
    call StoreError(stat, subname, cause_c = cause_c)
    call EndSub(subname)
  end subroutine HstVarsOutputCheck

  subroutine HstFileCreate( &
    & gthist,  & ! (inout)
    & varname, & ! (in)
    & time &     ! (in)
    & )
    !
    ! ե֥롼
    !
    ! Internal subroutine for creation of files
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_error, only: StoreError, DC_NOERR, HST_EBADVARNAME, &
      & HST_EBADSLICE, HST_EMPINOAXISDATA
    use dc_date_types, only: DC_DIFFTIME
    use dc_date, only: DCDiffTimeCreate, EvalbyUnit
    use dc_string, only: CPrintf, StrInclude, toChar, JoinChar
    use dc_message, only: MessageNotify
    use gtool_history_nmlinfo_generic, only: &
      & HstNmlInfoOutputValid, HstNmlInfoInquire, HstNmlInfoPutLine
    use gtool_history, only: GT_HISTORY, &
      & HistoryCreate, HistoryAddVariable, HistoryAddAttr, &
      & HistoryInitialized, HistoryPut, HistoryPutAxisMPI, &
      & HistoryAxisCreate, HistoryAxisInquire, HistoryAxisCopy, &
      & HistoryVarinfoInquire, HistoryVarinfoCreate, &
      & HistoryVarinfoCopy, HistoryVarinfoInitialized, &
      & HistoryVarinfoClear

    implicit none
    type(GT_HISTORY), intent(inout):: gthist
                              ! gtool_history ⥸塼ѹ¤. 
                              ! Derived type for "gtool_history" module
    character(*), intent(in):: varname
                              ! ѿ̾. 
                              ! Variable name
    type(DC_DIFFTIME), intent(in):: time
                              ! ߻. Current time

    character(TOKEN):: interval_unit
                              ! ǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    real:: origin_value
                              ! ǡνϳϻο. 
                              ! Numerical value for start time of history data output
    character(TOKEN):: origin_unit
                              ! ǡνϳϻñ. 
                              ! Unit for start time of history data output

    type(DC_DIFFTIME):: origin_difftime
    integer:: newfile_intvalue
                              ! եʬֳִ. 
                              ! Interval of time of separation of a file. 
    character(TOKEN):: newfile_intunit
                              ! եʬֳִ֤ñ. 
                              ! Unit of interval of time of separation of a file. 

    character(STRING):: file, file_base, file_suffix, file_newfile_time, file_rank
                              ! ϥե̾. 
                              ! Output file name. 
    integer:: stat, i, j, k, vnum, numdims_slice, dim_size, cnt
    character(STRING):: name, units, longname, cause_c, wgt_name
    character(TOKEN):: xtype
    type(GT_HISTORY_AXIS):: gthst_axes_time
    type(GT_HISTORY_AXIS), pointer:: gthst_axes_slices(:) =>null()
    type(GT_HISTORY_AXIS_DATA), pointer:: data_axes_slices(:) =>null()
    type(GT_HISTORY_AXIS_DATA), pointer:: data_weights_slices(:) =>null()
    real(DP):: wgt_sum, wgt_sum_s
    logical:: slice_valid
    integer:: slice_start(1:numdims-1)
                              ! γ. 
                              ! Start points of spaces. 
    integer:: slice_end(1:numdims-1)
                              ! νλ. 
                              ! End points of spaces. 
    integer:: slice_stride(1:numdims-1)
                              ! ι. 
                              ! Strides of spaces

    character(*), parameter:: subname = "HstFileCreate"
  continue
    call BeginSub(subname, 'varname=%c', c1 = trim(varname) )
    stat = DC_NOERR
    cause_c = ""

    ! varname ѿõ
    ! Search information of a variable from "varname"
    !
    vnum = 0
    do i = 1, numvars
      call HistoryVarinfoInquire( &
        & varinfo = gthst_vars(i), &  ! (in)
        & name = name )               ! (out)
      if ( trim(varname) == trim(name) ) vnum = i
    end do

    if ( vnum == 0 ) then
      stat = HST_EBADVARNAME
      cause_c = varname
      goto 999
    end if

    ! Ϥͭɤǧ
    ! Confirm whether the output is effective
    !
    if ( .not. HstNmlInfoOutputValid( gthstnml, varname ) ) then
      goto 999
    end if

    ! ϴֳ֤ñ̤˱ƻֺɸκľ
    ! Remake time axis information correspond to units of output interval
    !
    call HstNmlInfoInquire( &
      & gthstnml = gthstnml, &                 ! (in)
      & name = varname, &                      ! (in)
      & file = file, &                         ! (out)
      & interval_unit  = interval_unit )       ! (out)

    call HistoryAxisCopy( &
      & gthst_axes_time, &     ! (out)
      & gthst_axes(numdims), & ! (in)
      & units = trim(interval_unit) // ' ' // &
      &         trim(time_unit_suffix) ) ! (in)

    ! Υ饤б, ɸӺɸŤ߾κľ
    ! Remake axes and weights information correspond to spatial slices
    !
    call HstNmlInfoInquire( &
      & gthstnml = gthstnml, &         ! (in)
      & name = varname, &              ! (in)
      & slice_start = slice_start, &   ! (out)
      & slice_end = slice_end, &       ! (out)
      & slice_stride = slice_stride )  ! (out)

    ! ե뤬̤ξ, ޤե
    ! At first, the file is created if the file is not created yet
    ! 
    if ( .not. HistoryInitialized( gthist ) ) then

      if (       all( slice_start  == (/ ( 1, i = 1, numdims -1 ) /) ) &
        &  .and. all( slice_end    <  (/ ( 1, i = 1, numdims -1 ) /) ) &
        &  .and. all( slice_stride == (/ ( 1, i = 1, numdims -1 ) /) )  ) then

        allocate( gthst_axes_slices (1:numdims) )
        gthst_axes_slices(1:numdims-1)     = gthst_axes(1:numdims-1)
        gthst_axes_slices(numdims:numdims) = gthst_axes_time

        data_axes_slices               => data_axes
        data_weights_slices            => data_weights
        slice_valid = .false.

      else
        allocate( gthst_axes_slices    (1:numdims) )
        allocate( data_axes_slices     (1:numdims) )
        allocate( data_weights_slices  (1:numdims) )

        do i = 1, numdims-1

          ! 饤ͤͭå
          ! Check validity of slices
          !
          if ( slice_start(i) < 1 ) then
            stat = HST_EBADSLICE
            cause_c = CPrintf('slice_start=%d', &
              &         i = (/ slice_start(i) /) )
            goto 999
          end if

          if ( slice_stride(i) < 1 ) then
            stat = HST_EBADSLICE
            cause_c = CPrintf('slice_stride=%d', &
              &         i = (/ slice_stride(i) /) )
            goto 999
          end if

          ! ɬå
          ! Check necessity of remaking
          !
          if (       ( slice_start(i)  == 1 ) &
            &  .and. ( slice_end(i)    <  1 ) &
            &  .and. ( slice_stride(i) == 1 )  ) then

            call HistoryAxisCopy( &
              & axis_dest = gthst_axes_slices(i) , &  ! (out)
              & axis_src  = gthst_axes(i) )           ! (in)

            data_axes_slices (i) = data_axes (i)

            cycle
          end if

          ! ɸκ
          ! Remake information of axis
          !
          call HistoryAxisInquire( &
            & axis = gthst_axes(i), &  ! (in)
            & name = name, &           ! (out)
            & size = dim_size, &       ! (out)
            & longname = longname, &   ! (out)
            & units = units, &         ! (out)
            & xtype = xtype )          ! (out)

          ! Υ饤ͤ ; Correct end points of slices
          if ( slice_end(i) < 1 ) slice_end(i) = dim_size
          if ( slice_end(i) > dim_size ) then
            call MessageNotify( 'W', subname, &
              & 'slice options to (%c) are undesirable ' // &
              & '(@slice_end=%d). @slice_end is corrected forcibly to (%d) ', &
              & c1 = trim(name), &
              & i = (/ slice_end(i), dim_size /) )

            slice_end(i) = dim_size
          end if

          ! 饤ͤͭå ; Check validity of slices
          if ( slice_start(i) > slice_end(i) ) then
            stat = HST_EBADSLICE
            cause_c = CPrintf('slice_start=%d, slice_end=%d', &
              &         i = (/ slice_start(i), slice_end(i) /) )
            goto 999
          end if

          numdims_slice = int( ( slice_end(i) - slice_start(i) + 1 ) / slice_stride(i) )

          ! 饤ͤͭå ; Check validity of slices
          if ( numdims_slice < 1 ) then
            call MessageNotify( 'W', subname, &
              & 'slice options to (%c) are invalid. ' // &
              & '(@slice_start=%d @slice_end=%d @slice_stride=%d)', &
              & c1 = trim(name), &
              & i = (/ slice_start(i), slice_end(i), slice_stride(i) /) )
            stat = HST_EBADSLICE
            cause_c = CPrintf('slice_start=%d, slice_end=%d, slice_stride=%d', &
              &         i = (/ slice_start(i), slice_end(i), slice_stride(i) /) )
            goto 999
          end if

          call HistoryAxisCreate( &
            & axis = gthst_axes_slices(i), &  ! (out)
            & name = name, &                  ! (in)
            & size = numdims_slice, &         ! (in)
            & longname = longname, &          ! (in)
            & units = units, &                ! (in)
            & xtype = xtype )                 ! (in)


          ! ɸǡκ
          ! Regenerate data of axis
          !
          allocate( data_axes_slices(i) % a_axis( numdims_slice ) )
          cnt = 1
          do j = slice_start(i), slice_end(i), slice_stride(i)
            data_axes_slices(i) % a_axis( cnt ) = data_axes(i) % a_axis( j ) 
            cnt = cnt + 1
          end do

          ! ɸŤߥǡκ
          ! Remake information of axis data
          !
          do j = 1, numwgts
            call HistoryVarinfoInquire( &
              & varinfo = gthst_weights(j), & ! (in)
              & name = wgt_name )             ! (out) optional

            if ( trim(name) // wgtsuf == trim(wgt_name) ) then

              ! ɸŤߤη׻Ϸ빽ø...
              ! Calculation about axis weight is irresponsible...
              !
              wgt_sum = sum( data_weights(j) % a_axis )

              allocate( data_weights_slices(j) % a_axis( numdims_slice ) )
              cnt = 1
              do k = slice_start(i), slice_end(i), slice_stride(i)
                data_weights_slices(j) % a_axis( cnt ) = data_weights(j) % a_axis( k )
                cnt = cnt + 1
              end do

              wgt_sum_s = sum( data_weights_slices(j) % a_axis )
              data_weights_slices(j) % a_axis = data_weights_slices(j) % a_axis * ( wgt_sum / wgt_sum_s )

            end if

          end do

        end do

        ! ڤФƤʤɸ˴ؤɸŤߥǡ
        ! Make data of axis weight not sliced
        !
        do i = 1, numwgts
          if ( .not. associated( data_weights_slices(i) % a_axis ) ) then
            allocate( data_weights_slices(i) % a_axis( size(data_weights(i) % a_axis ) ) )
            data_weights_slices(i) % a_axis = data_weights (i) % a_axis
          end if
        end do

        ! ＡΥԡ
        ! Copy time dimension
        !
        gthst_axes_slices(numdims) = gthst_axes_time

        slice_valid = .true.
      end if

      ! HistoryCreate Τͤμ
      ! Get the settings for "HistoryCreate"
      !
      call HstNmlInfoInquire( &
        & gthstnml = gthstnml, &                 ! (in)
        & name = varname, &                      ! (in)
        & file = file, &                         ! (out)
        & origin_value   = origin_value, &       ! (out)
        & origin_unit    = origin_unit, &        ! (out)
        & interval_unit  = interval_unit, &      ! (out)
        & newfile_intvalue = newfile_intvalue, & ! (out)
        & newfile_intunit = newfile_intunit )    ! (out)

      ! ǡϻ
      ! Configure data output time
      !
      call DCDiffTimeCreate( &
        & origin_difftime, &           ! (out)
        & origin_value, origin_unit )  ! (in)

      if ( newfile_intvalue < 1 ) then
        origin_value = EvalbyUnit( origin_difftime, interval_unit )
      else
        origin_value = EvalbyUnit( time, interval_unit )
      end if

      ! ե̾
      ! Configure file name
      !
      if ( len_trim( file ) - index(file, '.nc', .true.) == 2 ) then
        file_base = file(1:len_trim( file ) - 3)
        file_suffix = '.nc'
      else
        file_base = file
        file_suffix = ''
      end if
      if ( trim(rank_save) == '' ) then
        file_rank = ''
      else
        file_rank = '_rank' // trim( adjustl(rank_save) )
      end if
      if ( newfile_intvalue > 0 ) then
        file_newfile_time = &
          & CPrintf( '_time%08d', &
          &   i = (/ int( EvalbyUnit( time, newfile_intunit ) ) /) )
      else
        file_newfile_time = ''
      end if

      file = trim(file_base) // trim(file_rank) // trim(file_newfile_time) // trim(file_suffix)

      ! HistoryCreate ˤե
      ! Files are created by "HistoryCreate"
      !
      call HistoryCreate( &
        & history = gthist, &                                     ! (inout)
        & file = file, title = title_save, &                      ! (in)
        & source = source_save, institution = institution_save, & ! (in)
        & axes = gthst_axes_slices(1:numdims), &                  ! (in)
        & origin = origin_value, &                                ! (in)
        & flag_mpi_split = save_mpi_split, &                      ! (in)
        & flag_mpi_gather = save_mpi_gather )                     ! (in)

      ! ɸǡ
      ! Output axes data
      !
      do i = 1, numdims - 1
        call HistoryAxisInquire( &
          & axis = gthst_axes_slices(i), &  ! (in)
          & name = name )                   ! (out)
        call HistoryPut( &
          & history = gthist, &                    ! (inout) optional
          & varname = name, &                      ! (in)
          & array = data_axes_slices(i) % a_axis ) ! (in)
      end do

      ! MPI ѤΰΤκɸǡ
      ! Output axes data in whole area for MPI
      !
      if ( save_mpi_gather ) then
        do i = 1, numdims - 1
          call HistoryAxisInquire( &
            & axis = gthst_axes_slices(i), &  ! (in)
            & name = name )                   ! (out)

          if ( .not. associated( data_axes_whole(i) % a_axis ) ) then
            call MessageNotify('W', subname, &
              & 'data of axis (%c) in whole area is lack. ' // &
              & 'Specify the data by "HistoryAutoPutAxisMPI" explicitly.', &
              & c1 = trim(name) )
            stat = HST_EMPINOAXISDATA
            cause_c = name
          end if

          call HistoryPutAxisMPI( &
            & history = gthist, &                   ! (inout) optional
            & varname = name, &                     ! (in)
            & array = data_axes_whole(i) % a_axis ) ! (in)
        end do
      end if

      ! ղ
      ! Deallocation
      !
      if ( slice_valid ) then
        deallocate( gthst_axes_slices )
        deallocate( data_axes_slices )
      else
        deallocate( gthst_axes_slices )
        nullify( data_axes_slices )
      end if

      ! ɸŤߥǡɲ
      ! Add axes weights data
      !
      do i = 1, numwgts
        call HistoryAddVariable( &
          & history = gthist, &           ! (inout)
          & varinfo = gthst_weights(i) )  ! (in)
        call HistoryVarinfoInquire( &
          & varinfo = gthst_weights(i), &  ! (in)
          & name = name )                  ! (out)
        call HistoryPut( &
          & history = gthist, &                       ! (inout) optional
          & varname = name, &                         ! (in)
          & array = data_weights_slices(i) % a_axis ) ! (in)
      end do

      if ( slice_valid ) then
        deallocate( data_weights_slices )
      else
        nullify( data_weights_slices )
      end if

    ! եޤ; Creation of file is finished
    end if


    ! ѿɲ
    ! Add information of variables
    !
    call HistoryAddVariable( &
      & varinfo = gthst_vars(vnum), &  ! (in)
      & history = gthist )             ! (inout) optional

999 continue
    call StoreError(stat, subname, cause_c = cause_c)
    call EndSub(subname)
  end subroutine HstFileCreate


  subroutine AverageReduceReal1( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    real, intent(in), target:: array(:)
    logical, intent(in):: space_average(1)
                        real(DP), intent(in):: weight1(:)
                    
    real, pointer:: array_avr(:) ! (out)

    real, pointer:: array_avr_work(:)

                        real, pointer:: array_avr_work1(:)
                    

    integer:: array_shape(1)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                          
        &  ) )
      array_avr_work1 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1) = array_avr_work1(1) + array_avr_work(i) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    

  end subroutine AverageReduceReal1


  subroutine AverageReduceReal2( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    real, intent(in), target:: array(:,:)
    logical, intent(in):: space_average(2)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    real, pointer:: array_avr(:,:) ! (out)

    real, pointer:: array_avr_work(:,:)

                        real, pointer:: array_avr_work1(:,:)
                    
    real, pointer:: array_avr_work2(:,:)
                    

    integer:: array_shape(2)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        &  ) )
      array_avr_work1 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:) = array_avr_work1(1,:) + array_avr_work(i,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        &  ) )
      array_avr_work2 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1) = array_avr_work2(:,1) + array_avr_work(:,i) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    

  end subroutine AverageReduceReal2


  subroutine AverageReduceReal3( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & weight3, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    real, intent(in), target:: array(:,:,:)
    logical, intent(in):: space_average(3)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    real(DP), intent(in):: weight3(:)
                    
    real, pointer:: array_avr(:,:,:) ! (out)

    real, pointer:: array_avr_work(:,:,:)

                        real, pointer:: array_avr_work1(:,:,:)
                    
    real, pointer:: array_avr_work2(:,:,:)
                    
    real, pointer:: array_avr_work3(:,:,:)
                    

    integer:: array_shape(3)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        &  ) )
      array_avr_work1 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:,:) = array_avr_work1(1,:,:) + array_avr_work(i,:,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        &  ) )
      array_avr_work2 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1,:) = array_avr_work2(:,1,:) + array_avr_work(:,i,:) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        

    if ( space_average(3) ) then
      dim_size = array_shape(3)
      array_shape(3) = 1
      allocate( array_avr_work3( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        &  ) )
      array_avr_work3 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work3(:,:,1) = array_avr_work3(:,:,1) + array_avr_work(:,:,i) * weight3(i)
        weight_sum = weight_sum + weight3(i)
      end do
      array_avr_work3 = array_avr_work3 / weight_sum
      array_avr_work  => array_avr_work3
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & , array_shape(3) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    
      if ( associated( array_avr_work3 ) ) deallocate( array_avr_work3 )
                    

  end subroutine AverageReduceReal3


  subroutine AverageReduceReal4( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & weight3, &  ! (in)
                    
    & weight4, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    real, intent(in), target:: array(:,:,:,:)
    logical, intent(in):: space_average(4)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    real(DP), intent(in):: weight3(:)
                    
    real(DP), intent(in):: weight4(:)
                    
    real, pointer:: array_avr(:,:,:,:) ! (out)

    real, pointer:: array_avr_work(:,:,:,:)

                        real, pointer:: array_avr_work1(:,:,:,:)
                    
    real, pointer:: array_avr_work2(:,:,:,:)
                    
    real, pointer:: array_avr_work3(:,:,:,:)
                    
    real, pointer:: array_avr_work4(:,:,:,:)
                    

    integer:: array_shape(4)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        &  ) )
      array_avr_work1 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:,:,:) = array_avr_work1(1,:,:,:) + array_avr_work(i,:,:,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        &  ) )
      array_avr_work2 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1,:,:) = array_avr_work2(:,1,:,:) + array_avr_work(:,i,:,:) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        

    if ( space_average(3) ) then
      dim_size = array_shape(3)
      array_shape(3) = 1
      allocate( array_avr_work3( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        &  ) )
      array_avr_work3 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work3(:,:,1,:) = array_avr_work3(:,:,1,:) + array_avr_work(:,:,i,:) * weight3(i)
        weight_sum = weight_sum + weight3(i)
      end do
      array_avr_work3 = array_avr_work3 / weight_sum
      array_avr_work  => array_avr_work3
    end if

                        

    if ( space_average(4) ) then
      dim_size = array_shape(4)
      array_shape(4) = 1
      allocate( array_avr_work4( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        &  ) )
      array_avr_work4 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work4(:,:,:,1) = array_avr_work4(:,:,:,1) + array_avr_work(:,:,:,i) * weight4(i)
        weight_sum = weight_sum + weight4(i)
      end do
      array_avr_work4 = array_avr_work4 / weight_sum
      array_avr_work  => array_avr_work4
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & , array_shape(3) &
                    
        & , array_shape(4) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    
      if ( associated( array_avr_work3 ) ) deallocate( array_avr_work3 )
                    
      if ( associated( array_avr_work4 ) ) deallocate( array_avr_work4 )
                    

  end subroutine AverageReduceReal4


  subroutine AverageReduceReal5( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & weight3, &  ! (in)
                    
    & weight4, &  ! (in)
                    
    & weight5, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    real, intent(in), target:: array(:,:,:,:,:)
    logical, intent(in):: space_average(5)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    real(DP), intent(in):: weight3(:)
                    
    real(DP), intent(in):: weight4(:)
                    
    real(DP), intent(in):: weight5(:)
                    
    real, pointer:: array_avr(:,:,:,:,:) ! (out)

    real, pointer:: array_avr_work(:,:,:,:,:)

                        real, pointer:: array_avr_work1(:,:,:,:,:)
                    
    real, pointer:: array_avr_work2(:,:,:,:,:)
                    
    real, pointer:: array_avr_work3(:,:,:,:,:)
                    
    real, pointer:: array_avr_work4(:,:,:,:,:)
                    
    real, pointer:: array_avr_work5(:,:,:,:,:)
                    

    integer:: array_shape(5)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        &  ) )
      array_avr_work1 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:,:,:,:) = array_avr_work1(1,:,:,:,:) + array_avr_work(i,:,:,:,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        &  ) )
      array_avr_work2 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1,:,:,:) = array_avr_work2(:,1,:,:,:) + array_avr_work(:,i,:,:,:) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        

    if ( space_average(3) ) then
      dim_size = array_shape(3)
      array_shape(3) = 1
      allocate( array_avr_work3( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        &  ) )
      array_avr_work3 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work3(:,:,1,:,:) = array_avr_work3(:,:,1,:,:) + array_avr_work(:,:,i,:,:) * weight3(i)
        weight_sum = weight_sum + weight3(i)
      end do
      array_avr_work3 = array_avr_work3 / weight_sum
      array_avr_work  => array_avr_work3
    end if

                        

    if ( space_average(4) ) then
      dim_size = array_shape(4)
      array_shape(4) = 1
      allocate( array_avr_work4( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        &  ) )
      array_avr_work4 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work4(:,:,:,1,:) = array_avr_work4(:,:,:,1,:) + array_avr_work(:,:,:,i,:) * weight4(i)
        weight_sum = weight_sum + weight4(i)
      end do
      array_avr_work4 = array_avr_work4 / weight_sum
      array_avr_work  => array_avr_work4
    end if

                        

    if ( space_average(5) ) then
      dim_size = array_shape(5)
      array_shape(5) = 1
      allocate( array_avr_work5( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        &  ) )
      array_avr_work5 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work5(:,:,:,:,1) = array_avr_work5(:,:,:,:,1) + array_avr_work(:,:,:,:,i) * weight5(i)
        weight_sum = weight_sum + weight5(i)
      end do
      array_avr_work5 = array_avr_work5 / weight_sum
      array_avr_work  => array_avr_work5
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & , array_shape(3) &
                    
        & , array_shape(4) &
                    
        & , array_shape(5) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    
      if ( associated( array_avr_work3 ) ) deallocate( array_avr_work3 )
                    
      if ( associated( array_avr_work4 ) ) deallocate( array_avr_work4 )
                    
      if ( associated( array_avr_work5 ) ) deallocate( array_avr_work5 )
                    

  end subroutine AverageReduceReal5


  subroutine AverageReduceReal6( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & weight3, &  ! (in)
                    
    & weight4, &  ! (in)
                    
    & weight5, &  ! (in)
                    
    & weight6, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    real, intent(in), target:: array(:,:,:,:,:,:)
    logical, intent(in):: space_average(6)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    real(DP), intent(in):: weight3(:)
                    
    real(DP), intent(in):: weight4(:)
                    
    real(DP), intent(in):: weight5(:)
                    
    real(DP), intent(in):: weight6(:)
                    
    real, pointer:: array_avr(:,:,:,:,:,:) ! (out)

    real, pointer:: array_avr_work(:,:,:,:,:,:)

                        real, pointer:: array_avr_work1(:,:,:,:,:,:)
                    
    real, pointer:: array_avr_work2(:,:,:,:,:,:)
                    
    real, pointer:: array_avr_work3(:,:,:,:,:,:)
                    
    real, pointer:: array_avr_work4(:,:,:,:,:,:)
                    
    real, pointer:: array_avr_work5(:,:,:,:,:,:)
                    
    real, pointer:: array_avr_work6(:,:,:,:,:,:)
                    

    integer:: array_shape(6)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work1 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:,:,:,:,:) = array_avr_work1(1,:,:,:,:,:) + array_avr_work(i,:,:,:,:,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work2 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1,:,:,:,:) = array_avr_work2(:,1,:,:,:,:) + array_avr_work(:,i,:,:,:,:) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        

    if ( space_average(3) ) then
      dim_size = array_shape(3)
      array_shape(3) = 1
      allocate( array_avr_work3( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work3 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work3(:,:,1,:,:,:) = array_avr_work3(:,:,1,:,:,:) + array_avr_work(:,:,i,:,:,:) * weight3(i)
        weight_sum = weight_sum + weight3(i)
      end do
      array_avr_work3 = array_avr_work3 / weight_sum
      array_avr_work  => array_avr_work3
    end if

                        

    if ( space_average(4) ) then
      dim_size = array_shape(4)
      array_shape(4) = 1
      allocate( array_avr_work4( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work4 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work4(:,:,:,1,:,:) = array_avr_work4(:,:,:,1,:,:) + array_avr_work(:,:,:,i,:,:) * weight4(i)
        weight_sum = weight_sum + weight4(i)
      end do
      array_avr_work4 = array_avr_work4 / weight_sum
      array_avr_work  => array_avr_work4
    end if

                        

    if ( space_average(5) ) then
      dim_size = array_shape(5)
      array_shape(5) = 1
      allocate( array_avr_work5( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work5 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work5(:,:,:,:,1,:) = array_avr_work5(:,:,:,:,1,:) + array_avr_work(:,:,:,:,i,:) * weight5(i)
        weight_sum = weight_sum + weight5(i)
      end do
      array_avr_work5 = array_avr_work5 / weight_sum
      array_avr_work  => array_avr_work5
    end if

                        

    if ( space_average(6) ) then
      dim_size = array_shape(6)
      array_shape(6) = 1
      allocate( array_avr_work6( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work6 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work6(:,:,:,:,:,1) = array_avr_work6(:,:,:,:,:,1) + array_avr_work(:,:,:,:,:,i) * weight6(i)
        weight_sum = weight_sum + weight6(i)
      end do
      array_avr_work6 = array_avr_work6 / weight_sum
      array_avr_work  => array_avr_work6
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & , array_shape(3) &
                    
        & , array_shape(4) &
                    
        & , array_shape(5) &
                    
        & , array_shape(6) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    
      if ( associated( array_avr_work3 ) ) deallocate( array_avr_work3 )
                    
      if ( associated( array_avr_work4 ) ) deallocate( array_avr_work4 )
                    
      if ( associated( array_avr_work5 ) ) deallocate( array_avr_work5 )
                    
      if ( associated( array_avr_work6 ) ) deallocate( array_avr_work6 )
                    

  end subroutine AverageReduceReal6


  subroutine AverageReduceReal7( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & weight3, &  ! (in)
                    
    & weight4, &  ! (in)
                    
    & weight5, &  ! (in)
                    
    & weight6, &  ! (in)
                    
    & weight7, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    real, intent(in), target:: array(:,:,:,:,:,:,:)
    logical, intent(in):: space_average(7)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    real(DP), intent(in):: weight3(:)
                    
    real(DP), intent(in):: weight4(:)
                    
    real(DP), intent(in):: weight5(:)
                    
    real(DP), intent(in):: weight6(:)
                    
    real(DP), intent(in):: weight7(:)
                    
    real, pointer:: array_avr(:,:,:,:,:,:,:) ! (out)

    real, pointer:: array_avr_work(:,:,:,:,:,:,:)

                        real, pointer:: array_avr_work1(:,:,:,:,:,:,:)
                    
    real, pointer:: array_avr_work2(:,:,:,:,:,:,:)
                    
    real, pointer:: array_avr_work3(:,:,:,:,:,:,:)
                    
    real, pointer:: array_avr_work4(:,:,:,:,:,:,:)
                    
    real, pointer:: array_avr_work5(:,:,:,:,:,:,:)
                    
    real, pointer:: array_avr_work6(:,:,:,:,:,:,:)
                    
    real, pointer:: array_avr_work7(:,:,:,:,:,:,:)
                    

    integer:: array_shape(7)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work1 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:,:,:,:,:,:) = array_avr_work1(1,:,:,:,:,:,:) + array_avr_work(i,:,:,:,:,:,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work2 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1,:,:,:,:,:) = array_avr_work2(:,1,:,:,:,:,:) + array_avr_work(:,i,:,:,:,:,:) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        

    if ( space_average(3) ) then
      dim_size = array_shape(3)
      array_shape(3) = 1
      allocate( array_avr_work3( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work3 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work3(:,:,1,:,:,:,:) = array_avr_work3(:,:,1,:,:,:,:) + array_avr_work(:,:,i,:,:,:,:) * weight3(i)
        weight_sum = weight_sum + weight3(i)
      end do
      array_avr_work3 = array_avr_work3 / weight_sum
      array_avr_work  => array_avr_work3
    end if

                        

    if ( space_average(4) ) then
      dim_size = array_shape(4)
      array_shape(4) = 1
      allocate( array_avr_work4( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work4 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work4(:,:,:,1,:,:,:) = array_avr_work4(:,:,:,1,:,:,:) + array_avr_work(:,:,:,i,:,:,:) * weight4(i)
        weight_sum = weight_sum + weight4(i)
      end do
      array_avr_work4 = array_avr_work4 / weight_sum
      array_avr_work  => array_avr_work4
    end if

                        

    if ( space_average(5) ) then
      dim_size = array_shape(5)
      array_shape(5) = 1
      allocate( array_avr_work5( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work5 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work5(:,:,:,:,1,:,:) = array_avr_work5(:,:,:,:,1,:,:) + array_avr_work(:,:,:,:,i,:,:) * weight5(i)
        weight_sum = weight_sum + weight5(i)
      end do
      array_avr_work5 = array_avr_work5 / weight_sum
      array_avr_work  => array_avr_work5
    end if

                        

    if ( space_average(6) ) then
      dim_size = array_shape(6)
      array_shape(6) = 1
      allocate( array_avr_work6( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work6 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work6(:,:,:,:,:,1,:) = array_avr_work6(:,:,:,:,:,1,:) + array_avr_work(:,:,:,:,:,i,:) * weight6(i)
        weight_sum = weight_sum + weight6(i)
      end do
      array_avr_work6 = array_avr_work6 / weight_sum
      array_avr_work  => array_avr_work6
    end if

                        

    if ( space_average(7) ) then
      dim_size = array_shape(7)
      array_shape(7) = 1
      allocate( array_avr_work7( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work7 = 0.0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work7(:,:,:,:,:,:,1) = array_avr_work7(:,:,:,:,:,:,1) + array_avr_work(:,:,:,:,:,:,i) * weight7(i)
        weight_sum = weight_sum + weight7(i)
      end do
      array_avr_work7 = array_avr_work7 / weight_sum
      array_avr_work  => array_avr_work7
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & , array_shape(3) &
                    
        & , array_shape(4) &
                    
        & , array_shape(5) &
                    
        & , array_shape(6) &
                    
        & , array_shape(7) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    
      if ( associated( array_avr_work3 ) ) deallocate( array_avr_work3 )
                    
      if ( associated( array_avr_work4 ) ) deallocate( array_avr_work4 )
                    
      if ( associated( array_avr_work5 ) ) deallocate( array_avr_work5 )
                    
      if ( associated( array_avr_work6 ) ) deallocate( array_avr_work6 )
                    
      if ( associated( array_avr_work7 ) ) deallocate( array_avr_work7 )
                    

  end subroutine AverageReduceReal7


  subroutine AverageReduceDouble1( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    real(DP), intent(in), target:: array(:)
    logical, intent(in):: space_average(1)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), pointer:: array_avr(:) ! (out)

    real(DP), pointer:: array_avr_work(:)

                        real(DP), pointer:: array_avr_work1(:)
                    

    integer:: array_shape(1)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                          
        &  ) )
      array_avr_work1 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1) = array_avr_work1(1) + array_avr_work(i) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    

  end subroutine AverageReduceDouble1


  subroutine AverageReduceDouble2( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    real(DP), intent(in), target:: array(:,:)
    logical, intent(in):: space_average(2)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    real(DP), pointer:: array_avr(:,:) ! (out)

    real(DP), pointer:: array_avr_work(:,:)

                        real(DP), pointer:: array_avr_work1(:,:)
                    
    real(DP), pointer:: array_avr_work2(:,:)
                    

    integer:: array_shape(2)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        &  ) )
      array_avr_work1 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:) = array_avr_work1(1,:) + array_avr_work(i,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        &  ) )
      array_avr_work2 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1) = array_avr_work2(:,1) + array_avr_work(:,i) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    

  end subroutine AverageReduceDouble2


  subroutine AverageReduceDouble3( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & weight3, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    real(DP), intent(in), target:: array(:,:,:)
    logical, intent(in):: space_average(3)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    real(DP), intent(in):: weight3(:)
                    
    real(DP), pointer:: array_avr(:,:,:) ! (out)

    real(DP), pointer:: array_avr_work(:,:,:)

                        real(DP), pointer:: array_avr_work1(:,:,:)
                    
    real(DP), pointer:: array_avr_work2(:,:,:)
                    
    real(DP), pointer:: array_avr_work3(:,:,:)
                    

    integer:: array_shape(3)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        &  ) )
      array_avr_work1 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:,:) = array_avr_work1(1,:,:) + array_avr_work(i,:,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        &  ) )
      array_avr_work2 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1,:) = array_avr_work2(:,1,:) + array_avr_work(:,i,:) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        

    if ( space_average(3) ) then
      dim_size = array_shape(3)
      array_shape(3) = 1
      allocate( array_avr_work3( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        &  ) )
      array_avr_work3 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work3(:,:,1) = array_avr_work3(:,:,1) + array_avr_work(:,:,i) * weight3(i)
        weight_sum = weight_sum + weight3(i)
      end do
      array_avr_work3 = array_avr_work3 / weight_sum
      array_avr_work  => array_avr_work3
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & , array_shape(3) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    
      if ( associated( array_avr_work3 ) ) deallocate( array_avr_work3 )
                    

  end subroutine AverageReduceDouble3


  subroutine AverageReduceDouble4( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & weight3, &  ! (in)
                    
    & weight4, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    real(DP), intent(in), target:: array(:,:,:,:)
    logical, intent(in):: space_average(4)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    real(DP), intent(in):: weight3(:)
                    
    real(DP), intent(in):: weight4(:)
                    
    real(DP), pointer:: array_avr(:,:,:,:) ! (out)

    real(DP), pointer:: array_avr_work(:,:,:,:)

                        real(DP), pointer:: array_avr_work1(:,:,:,:)
                    
    real(DP), pointer:: array_avr_work2(:,:,:,:)
                    
    real(DP), pointer:: array_avr_work3(:,:,:,:)
                    
    real(DP), pointer:: array_avr_work4(:,:,:,:)
                    

    integer:: array_shape(4)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        &  ) )
      array_avr_work1 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:,:,:) = array_avr_work1(1,:,:,:) + array_avr_work(i,:,:,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        &  ) )
      array_avr_work2 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1,:,:) = array_avr_work2(:,1,:,:) + array_avr_work(:,i,:,:) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        

    if ( space_average(3) ) then
      dim_size = array_shape(3)
      array_shape(3) = 1
      allocate( array_avr_work3( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        &  ) )
      array_avr_work3 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work3(:,:,1,:) = array_avr_work3(:,:,1,:) + array_avr_work(:,:,i,:) * weight3(i)
        weight_sum = weight_sum + weight3(i)
      end do
      array_avr_work3 = array_avr_work3 / weight_sum
      array_avr_work  => array_avr_work3
    end if

                        

    if ( space_average(4) ) then
      dim_size = array_shape(4)
      array_shape(4) = 1
      allocate( array_avr_work4( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        &  ) )
      array_avr_work4 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work4(:,:,:,1) = array_avr_work4(:,:,:,1) + array_avr_work(:,:,:,i) * weight4(i)
        weight_sum = weight_sum + weight4(i)
      end do
      array_avr_work4 = array_avr_work4 / weight_sum
      array_avr_work  => array_avr_work4
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & , array_shape(3) &
                    
        & , array_shape(4) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    
      if ( associated( array_avr_work3 ) ) deallocate( array_avr_work3 )
                    
      if ( associated( array_avr_work4 ) ) deallocate( array_avr_work4 )
                    

  end subroutine AverageReduceDouble4


  subroutine AverageReduceDouble5( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & weight3, &  ! (in)
                    
    & weight4, &  ! (in)
                    
    & weight5, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    real(DP), intent(in), target:: array(:,:,:,:,:)
    logical, intent(in):: space_average(5)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    real(DP), intent(in):: weight3(:)
                    
    real(DP), intent(in):: weight4(:)
                    
    real(DP), intent(in):: weight5(:)
                    
    real(DP), pointer:: array_avr(:,:,:,:,:) ! (out)

    real(DP), pointer:: array_avr_work(:,:,:,:,:)

                        real(DP), pointer:: array_avr_work1(:,:,:,:,:)
                    
    real(DP), pointer:: array_avr_work2(:,:,:,:,:)
                    
    real(DP), pointer:: array_avr_work3(:,:,:,:,:)
                    
    real(DP), pointer:: array_avr_work4(:,:,:,:,:)
                    
    real(DP), pointer:: array_avr_work5(:,:,:,:,:)
                    

    integer:: array_shape(5)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        &  ) )
      array_avr_work1 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:,:,:,:) = array_avr_work1(1,:,:,:,:) + array_avr_work(i,:,:,:,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        &  ) )
      array_avr_work2 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1,:,:,:) = array_avr_work2(:,1,:,:,:) + array_avr_work(:,i,:,:,:) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        

    if ( space_average(3) ) then
      dim_size = array_shape(3)
      array_shape(3) = 1
      allocate( array_avr_work3( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        &  ) )
      array_avr_work3 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work3(:,:,1,:,:) = array_avr_work3(:,:,1,:,:) + array_avr_work(:,:,i,:,:) * weight3(i)
        weight_sum = weight_sum + weight3(i)
      end do
      array_avr_work3 = array_avr_work3 / weight_sum
      array_avr_work  => array_avr_work3
    end if

                        

    if ( space_average(4) ) then
      dim_size = array_shape(4)
      array_shape(4) = 1
      allocate( array_avr_work4( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        &  ) )
      array_avr_work4 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work4(:,:,:,1,:) = array_avr_work4(:,:,:,1,:) + array_avr_work(:,:,:,i,:) * weight4(i)
        weight_sum = weight_sum + weight4(i)
      end do
      array_avr_work4 = array_avr_work4 / weight_sum
      array_avr_work  => array_avr_work4
    end if

                        

    if ( space_average(5) ) then
      dim_size = array_shape(5)
      array_shape(5) = 1
      allocate( array_avr_work5( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        &  ) )
      array_avr_work5 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work5(:,:,:,:,1) = array_avr_work5(:,:,:,:,1) + array_avr_work(:,:,:,:,i) * weight5(i)
        weight_sum = weight_sum + weight5(i)
      end do
      array_avr_work5 = array_avr_work5 / weight_sum
      array_avr_work  => array_avr_work5
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & , array_shape(3) &
                    
        & , array_shape(4) &
                    
        & , array_shape(5) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    
      if ( associated( array_avr_work3 ) ) deallocate( array_avr_work3 )
                    
      if ( associated( array_avr_work4 ) ) deallocate( array_avr_work4 )
                    
      if ( associated( array_avr_work5 ) ) deallocate( array_avr_work5 )
                    

  end subroutine AverageReduceDouble5


  subroutine AverageReduceDouble6( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & weight3, &  ! (in)
                    
    & weight4, &  ! (in)
                    
    & weight5, &  ! (in)
                    
    & weight6, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    real(DP), intent(in), target:: array(:,:,:,:,:,:)
    logical, intent(in):: space_average(6)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    real(DP), intent(in):: weight3(:)
                    
    real(DP), intent(in):: weight4(:)
                    
    real(DP), intent(in):: weight5(:)
                    
    real(DP), intent(in):: weight6(:)
                    
    real(DP), pointer:: array_avr(:,:,:,:,:,:) ! (out)

    real(DP), pointer:: array_avr_work(:,:,:,:,:,:)

                        real(DP), pointer:: array_avr_work1(:,:,:,:,:,:)
                    
    real(DP), pointer:: array_avr_work2(:,:,:,:,:,:)
                    
    real(DP), pointer:: array_avr_work3(:,:,:,:,:,:)
                    
    real(DP), pointer:: array_avr_work4(:,:,:,:,:,:)
                    
    real(DP), pointer:: array_avr_work5(:,:,:,:,:,:)
                    
    real(DP), pointer:: array_avr_work6(:,:,:,:,:,:)
                    

    integer:: array_shape(6)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work1 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:,:,:,:,:) = array_avr_work1(1,:,:,:,:,:) + array_avr_work(i,:,:,:,:,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work2 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1,:,:,:,:) = array_avr_work2(:,1,:,:,:,:) + array_avr_work(:,i,:,:,:,:) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        

    if ( space_average(3) ) then
      dim_size = array_shape(3)
      array_shape(3) = 1
      allocate( array_avr_work3( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work3 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work3(:,:,1,:,:,:) = array_avr_work3(:,:,1,:,:,:) + array_avr_work(:,:,i,:,:,:) * weight3(i)
        weight_sum = weight_sum + weight3(i)
      end do
      array_avr_work3 = array_avr_work3 / weight_sum
      array_avr_work  => array_avr_work3
    end if

                        

    if ( space_average(4) ) then
      dim_size = array_shape(4)
      array_shape(4) = 1
      allocate( array_avr_work4( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work4 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work4(:,:,:,1,:,:) = array_avr_work4(:,:,:,1,:,:) + array_avr_work(:,:,:,i,:,:) * weight4(i)
        weight_sum = weight_sum + weight4(i)
      end do
      array_avr_work4 = array_avr_work4 / weight_sum
      array_avr_work  => array_avr_work4
    end if

                        

    if ( space_average(5) ) then
      dim_size = array_shape(5)
      array_shape(5) = 1
      allocate( array_avr_work5( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work5 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work5(:,:,:,:,1,:) = array_avr_work5(:,:,:,:,1,:) + array_avr_work(:,:,:,:,i,:) * weight5(i)
        weight_sum = weight_sum + weight5(i)
      end do
      array_avr_work5 = array_avr_work5 / weight_sum
      array_avr_work  => array_avr_work5
    end if

                        

    if ( space_average(6) ) then
      dim_size = array_shape(6)
      array_shape(6) = 1
      allocate( array_avr_work6( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work6 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work6(:,:,:,:,:,1) = array_avr_work6(:,:,:,:,:,1) + array_avr_work(:,:,:,:,:,i) * weight6(i)
        weight_sum = weight_sum + weight6(i)
      end do
      array_avr_work6 = array_avr_work6 / weight_sum
      array_avr_work  => array_avr_work6
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & , array_shape(3) &
                    
        & , array_shape(4) &
                    
        & , array_shape(5) &
                    
        & , array_shape(6) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    
      if ( associated( array_avr_work3 ) ) deallocate( array_avr_work3 )
                    
      if ( associated( array_avr_work4 ) ) deallocate( array_avr_work4 )
                    
      if ( associated( array_avr_work5 ) ) deallocate( array_avr_work5 )
                    
      if ( associated( array_avr_work6 ) ) deallocate( array_avr_work6 )
                    

  end subroutine AverageReduceDouble6


  subroutine AverageReduceDouble7( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & weight3, &  ! (in)
                    
    & weight4, &  ! (in)
                    
    & weight5, &  ! (in)
                    
    & weight6, &  ! (in)
                    
    & weight7, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    real(DP), intent(in), target:: array(:,:,:,:,:,:,:)
    logical, intent(in):: space_average(7)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    real(DP), intent(in):: weight3(:)
                    
    real(DP), intent(in):: weight4(:)
                    
    real(DP), intent(in):: weight5(:)
                    
    real(DP), intent(in):: weight6(:)
                    
    real(DP), intent(in):: weight7(:)
                    
    real(DP), pointer:: array_avr(:,:,:,:,:,:,:) ! (out)

    real(DP), pointer:: array_avr_work(:,:,:,:,:,:,:)

                        real(DP), pointer:: array_avr_work1(:,:,:,:,:,:,:)
                    
    real(DP), pointer:: array_avr_work2(:,:,:,:,:,:,:)
                    
    real(DP), pointer:: array_avr_work3(:,:,:,:,:,:,:)
                    
    real(DP), pointer:: array_avr_work4(:,:,:,:,:,:,:)
                    
    real(DP), pointer:: array_avr_work5(:,:,:,:,:,:,:)
                    
    real(DP), pointer:: array_avr_work6(:,:,:,:,:,:,:)
                    
    real(DP), pointer:: array_avr_work7(:,:,:,:,:,:,:)
                    

    integer:: array_shape(7)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work1 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:,:,:,:,:,:) = array_avr_work1(1,:,:,:,:,:,:) + array_avr_work(i,:,:,:,:,:,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work2 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1,:,:,:,:,:) = array_avr_work2(:,1,:,:,:,:,:) + array_avr_work(:,i,:,:,:,:,:) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        

    if ( space_average(3) ) then
      dim_size = array_shape(3)
      array_shape(3) = 1
      allocate( array_avr_work3( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work3 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work3(:,:,1,:,:,:,:) = array_avr_work3(:,:,1,:,:,:,:) + array_avr_work(:,:,i,:,:,:,:) * weight3(i)
        weight_sum = weight_sum + weight3(i)
      end do
      array_avr_work3 = array_avr_work3 / weight_sum
      array_avr_work  => array_avr_work3
    end if

                        

    if ( space_average(4) ) then
      dim_size = array_shape(4)
      array_shape(4) = 1
      allocate( array_avr_work4( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work4 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work4(:,:,:,1,:,:,:) = array_avr_work4(:,:,:,1,:,:,:) + array_avr_work(:,:,:,i,:,:,:) * weight4(i)
        weight_sum = weight_sum + weight4(i)
      end do
      array_avr_work4 = array_avr_work4 / weight_sum
      array_avr_work  => array_avr_work4
    end if

                        

    if ( space_average(5) ) then
      dim_size = array_shape(5)
      array_shape(5) = 1
      allocate( array_avr_work5( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work5 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work5(:,:,:,:,1,:,:) = array_avr_work5(:,:,:,:,1,:,:) + array_avr_work(:,:,:,:,i,:,:) * weight5(i)
        weight_sum = weight_sum + weight5(i)
      end do
      array_avr_work5 = array_avr_work5 / weight_sum
      array_avr_work  => array_avr_work5
    end if

                        

    if ( space_average(6) ) then
      dim_size = array_shape(6)
      array_shape(6) = 1
      allocate( array_avr_work6( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work6 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work6(:,:,:,:,:,1,:) = array_avr_work6(:,:,:,:,:,1,:) + array_avr_work(:,:,:,:,:,i,:) * weight6(i)
        weight_sum = weight_sum + weight6(i)
      end do
      array_avr_work6 = array_avr_work6 / weight_sum
      array_avr_work  => array_avr_work6
    end if

                        

    if ( space_average(7) ) then
      dim_size = array_shape(7)
      array_shape(7) = 1
      allocate( array_avr_work7( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work7 = 0.0_DP
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work7(:,:,:,:,:,:,1) = array_avr_work7(:,:,:,:,:,:,1) + array_avr_work(:,:,:,:,:,:,i) * weight7(i)
        weight_sum = weight_sum + weight7(i)
      end do
      array_avr_work7 = array_avr_work7 / weight_sum
      array_avr_work  => array_avr_work7
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & , array_shape(3) &
                    
        & , array_shape(4) &
                    
        & , array_shape(5) &
                    
        & , array_shape(6) &
                    
        & , array_shape(7) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    
      if ( associated( array_avr_work3 ) ) deallocate( array_avr_work3 )
                    
      if ( associated( array_avr_work4 ) ) deallocate( array_avr_work4 )
                    
      if ( associated( array_avr_work5 ) ) deallocate( array_avr_work5 )
                    
      if ( associated( array_avr_work6 ) ) deallocate( array_avr_work6 )
                    
      if ( associated( array_avr_work7 ) ) deallocate( array_avr_work7 )
                    

  end subroutine AverageReduceDouble7


  subroutine AverageReduceInt1( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    integer, intent(in), target:: array(:)
    logical, intent(in):: space_average(1)
                        real(DP), intent(in):: weight1(:)
                    
    integer, pointer:: array_avr(:) ! (out)

    integer, pointer:: array_avr_work(:)

                        integer, pointer:: array_avr_work1(:)
                    

    integer:: array_shape(1)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                          
        &  ) )
      array_avr_work1 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1) = array_avr_work1(1) + array_avr_work(i) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    

  end subroutine AverageReduceInt1


  subroutine AverageReduceInt2( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    integer, intent(in), target:: array(:,:)
    logical, intent(in):: space_average(2)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    integer, pointer:: array_avr(:,:) ! (out)

    integer, pointer:: array_avr_work(:,:)

                        integer, pointer:: array_avr_work1(:,:)
                    
    integer, pointer:: array_avr_work2(:,:)
                    

    integer:: array_shape(2)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        &  ) )
      array_avr_work1 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:) = array_avr_work1(1,:) + array_avr_work(i,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        &  ) )
      array_avr_work2 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1) = array_avr_work2(:,1) + array_avr_work(:,i) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    

  end subroutine AverageReduceInt2


  subroutine AverageReduceInt3( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & weight3, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    integer, intent(in), target:: array(:,:,:)
    logical, intent(in):: space_average(3)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    real(DP), intent(in):: weight3(:)
                    
    integer, pointer:: array_avr(:,:,:) ! (out)

    integer, pointer:: array_avr_work(:,:,:)

                        integer, pointer:: array_avr_work1(:,:,:)
                    
    integer, pointer:: array_avr_work2(:,:,:)
                    
    integer, pointer:: array_avr_work3(:,:,:)
                    

    integer:: array_shape(3)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        &  ) )
      array_avr_work1 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:,:) = array_avr_work1(1,:,:) + array_avr_work(i,:,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        &  ) )
      array_avr_work2 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1,:) = array_avr_work2(:,1,:) + array_avr_work(:,i,:) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        

    if ( space_average(3) ) then
      dim_size = array_shape(3)
      array_shape(3) = 1
      allocate( array_avr_work3( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        &  ) )
      array_avr_work3 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work3(:,:,1) = array_avr_work3(:,:,1) + array_avr_work(:,:,i) * weight3(i)
        weight_sum = weight_sum + weight3(i)
      end do
      array_avr_work3 = array_avr_work3 / weight_sum
      array_avr_work  => array_avr_work3
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & , array_shape(3) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    
      if ( associated( array_avr_work3 ) ) deallocate( array_avr_work3 )
                    

  end subroutine AverageReduceInt3


  subroutine AverageReduceInt4( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & weight3, &  ! (in)
                    
    & weight4, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    integer, intent(in), target:: array(:,:,:,:)
    logical, intent(in):: space_average(4)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    real(DP), intent(in):: weight3(:)
                    
    real(DP), intent(in):: weight4(:)
                    
    integer, pointer:: array_avr(:,:,:,:) ! (out)

    integer, pointer:: array_avr_work(:,:,:,:)

                        integer, pointer:: array_avr_work1(:,:,:,:)
                    
    integer, pointer:: array_avr_work2(:,:,:,:)
                    
    integer, pointer:: array_avr_work3(:,:,:,:)
                    
    integer, pointer:: array_avr_work4(:,:,:,:)
                    

    integer:: array_shape(4)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        &  ) )
      array_avr_work1 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:,:,:) = array_avr_work1(1,:,:,:) + array_avr_work(i,:,:,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        &  ) )
      array_avr_work2 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1,:,:) = array_avr_work2(:,1,:,:) + array_avr_work(:,i,:,:) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        

    if ( space_average(3) ) then
      dim_size = array_shape(3)
      array_shape(3) = 1
      allocate( array_avr_work3( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        &  ) )
      array_avr_work3 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work3(:,:,1,:) = array_avr_work3(:,:,1,:) + array_avr_work(:,:,i,:) * weight3(i)
        weight_sum = weight_sum + weight3(i)
      end do
      array_avr_work3 = array_avr_work3 / weight_sum
      array_avr_work  => array_avr_work3
    end if

                        

    if ( space_average(4) ) then
      dim_size = array_shape(4)
      array_shape(4) = 1
      allocate( array_avr_work4( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        &  ) )
      array_avr_work4 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work4(:,:,:,1) = array_avr_work4(:,:,:,1) + array_avr_work(:,:,:,i) * weight4(i)
        weight_sum = weight_sum + weight4(i)
      end do
      array_avr_work4 = array_avr_work4 / weight_sum
      array_avr_work  => array_avr_work4
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & , array_shape(3) &
                    
        & , array_shape(4) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    
      if ( associated( array_avr_work3 ) ) deallocate( array_avr_work3 )
                    
      if ( associated( array_avr_work4 ) ) deallocate( array_avr_work4 )
                    

  end subroutine AverageReduceInt4


  subroutine AverageReduceInt5( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & weight3, &  ! (in)
                    
    & weight4, &  ! (in)
                    
    & weight5, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    integer, intent(in), target:: array(:,:,:,:,:)
    logical, intent(in):: space_average(5)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    real(DP), intent(in):: weight3(:)
                    
    real(DP), intent(in):: weight4(:)
                    
    real(DP), intent(in):: weight5(:)
                    
    integer, pointer:: array_avr(:,:,:,:,:) ! (out)

    integer, pointer:: array_avr_work(:,:,:,:,:)

                        integer, pointer:: array_avr_work1(:,:,:,:,:)
                    
    integer, pointer:: array_avr_work2(:,:,:,:,:)
                    
    integer, pointer:: array_avr_work3(:,:,:,:,:)
                    
    integer, pointer:: array_avr_work4(:,:,:,:,:)
                    
    integer, pointer:: array_avr_work5(:,:,:,:,:)
                    

    integer:: array_shape(5)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        &  ) )
      array_avr_work1 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:,:,:,:) = array_avr_work1(1,:,:,:,:) + array_avr_work(i,:,:,:,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        &  ) )
      array_avr_work2 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1,:,:,:) = array_avr_work2(:,1,:,:,:) + array_avr_work(:,i,:,:,:) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        

    if ( space_average(3) ) then
      dim_size = array_shape(3)
      array_shape(3) = 1
      allocate( array_avr_work3( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        &  ) )
      array_avr_work3 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work3(:,:,1,:,:) = array_avr_work3(:,:,1,:,:) + array_avr_work(:,:,i,:,:) * weight3(i)
        weight_sum = weight_sum + weight3(i)
      end do
      array_avr_work3 = array_avr_work3 / weight_sum
      array_avr_work  => array_avr_work3
    end if

                        

    if ( space_average(4) ) then
      dim_size = array_shape(4)
      array_shape(4) = 1
      allocate( array_avr_work4( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        &  ) )
      array_avr_work4 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work4(:,:,:,1,:) = array_avr_work4(:,:,:,1,:) + array_avr_work(:,:,:,i,:) * weight4(i)
        weight_sum = weight_sum + weight4(i)
      end do
      array_avr_work4 = array_avr_work4 / weight_sum
      array_avr_work  => array_avr_work4
    end if

                        

    if ( space_average(5) ) then
      dim_size = array_shape(5)
      array_shape(5) = 1
      allocate( array_avr_work5( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        &  ) )
      array_avr_work5 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work5(:,:,:,:,1) = array_avr_work5(:,:,:,:,1) + array_avr_work(:,:,:,:,i) * weight5(i)
        weight_sum = weight_sum + weight5(i)
      end do
      array_avr_work5 = array_avr_work5 / weight_sum
      array_avr_work  => array_avr_work5
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & , array_shape(3) &
                    
        & , array_shape(4) &
                    
        & , array_shape(5) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    
      if ( associated( array_avr_work3 ) ) deallocate( array_avr_work3 )
                    
      if ( associated( array_avr_work4 ) ) deallocate( array_avr_work4 )
                    
      if ( associated( array_avr_work5 ) ) deallocate( array_avr_work5 )
                    

  end subroutine AverageReduceInt5


  subroutine AverageReduceInt6( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & weight3, &  ! (in)
                    
    & weight4, &  ! (in)
                    
    & weight5, &  ! (in)
                    
    & weight6, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    integer, intent(in), target:: array(:,:,:,:,:,:)
    logical, intent(in):: space_average(6)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    real(DP), intent(in):: weight3(:)
                    
    real(DP), intent(in):: weight4(:)
                    
    real(DP), intent(in):: weight5(:)
                    
    real(DP), intent(in):: weight6(:)
                    
    integer, pointer:: array_avr(:,:,:,:,:,:) ! (out)

    integer, pointer:: array_avr_work(:,:,:,:,:,:)

                        integer, pointer:: array_avr_work1(:,:,:,:,:,:)
                    
    integer, pointer:: array_avr_work2(:,:,:,:,:,:)
                    
    integer, pointer:: array_avr_work3(:,:,:,:,:,:)
                    
    integer, pointer:: array_avr_work4(:,:,:,:,:,:)
                    
    integer, pointer:: array_avr_work5(:,:,:,:,:,:)
                    
    integer, pointer:: array_avr_work6(:,:,:,:,:,:)
                    

    integer:: array_shape(6)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work1 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:,:,:,:,:) = array_avr_work1(1,:,:,:,:,:) + array_avr_work(i,:,:,:,:,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work2 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1,:,:,:,:) = array_avr_work2(:,1,:,:,:,:) + array_avr_work(:,i,:,:,:,:) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        

    if ( space_average(3) ) then
      dim_size = array_shape(3)
      array_shape(3) = 1
      allocate( array_avr_work3( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work3 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work3(:,:,1,:,:,:) = array_avr_work3(:,:,1,:,:,:) + array_avr_work(:,:,i,:,:,:) * weight3(i)
        weight_sum = weight_sum + weight3(i)
      end do
      array_avr_work3 = array_avr_work3 / weight_sum
      array_avr_work  => array_avr_work3
    end if

                        

    if ( space_average(4) ) then
      dim_size = array_shape(4)
      array_shape(4) = 1
      allocate( array_avr_work4( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work4 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work4(:,:,:,1,:,:) = array_avr_work4(:,:,:,1,:,:) + array_avr_work(:,:,:,i,:,:) * weight4(i)
        weight_sum = weight_sum + weight4(i)
      end do
      array_avr_work4 = array_avr_work4 / weight_sum
      array_avr_work  => array_avr_work4
    end if

                        

    if ( space_average(5) ) then
      dim_size = array_shape(5)
      array_shape(5) = 1
      allocate( array_avr_work5( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work5 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work5(:,:,:,:,1,:) = array_avr_work5(:,:,:,:,1,:) + array_avr_work(:,:,:,:,i,:) * weight5(i)
        weight_sum = weight_sum + weight5(i)
      end do
      array_avr_work5 = array_avr_work5 / weight_sum
      array_avr_work  => array_avr_work5
    end if

                        

    if ( space_average(6) ) then
      dim_size = array_shape(6)
      array_shape(6) = 1
      allocate( array_avr_work6( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        &  ) )
      array_avr_work6 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work6(:,:,:,:,:,1) = array_avr_work6(:,:,:,:,:,1) + array_avr_work(:,:,:,:,:,i) * weight6(i)
        weight_sum = weight_sum + weight6(i)
      end do
      array_avr_work6 = array_avr_work6 / weight_sum
      array_avr_work  => array_avr_work6
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & , array_shape(3) &
                    
        & , array_shape(4) &
                    
        & , array_shape(5) &
                    
        & , array_shape(6) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    
      if ( associated( array_avr_work3 ) ) deallocate( array_avr_work3 )
                    
      if ( associated( array_avr_work4 ) ) deallocate( array_avr_work4 )
                    
      if ( associated( array_avr_work5 ) ) deallocate( array_avr_work5 )
                    
      if ( associated( array_avr_work6 ) ) deallocate( array_avr_work6 )
                    

  end subroutine AverageReduceInt6


  subroutine AverageReduceInt7( &
    & array, space_average, &     ! (in)
                        & weight1, &  ! (in)
                    
    & weight2, &  ! (in)
                    
    & weight3, &  ! (in)
                    
    & weight4, &  ! (in)
                    
    & weight5, &  ! (in)
                    
    & weight6, &  ! (in)
                    
    & weight7, &  ! (in)
                    
    & array_avr &                 ! (out)
    )
    !
    ! space_average  .true. ˻ꤵ줿Ф, 
    ! array ʿѲ array_avr ֤ޤ. 
    ! ʿѲˤϽŤ weight1  weight7 Ѥޤ. 
    ! array_avr μΤΤϸޤ. , 
    ! ʿѲ줿Υ 1 ˤʤޤ. 
    !
    implicit none
    integer, intent(in), target:: array(:,:,:,:,:,:,:)
    logical, intent(in):: space_average(7)
                        real(DP), intent(in):: weight1(:)
                    
    real(DP), intent(in):: weight2(:)
                    
    real(DP), intent(in):: weight3(:)
                    
    real(DP), intent(in):: weight4(:)
                    
    real(DP), intent(in):: weight5(:)
                    
    real(DP), intent(in):: weight6(:)
                    
    real(DP), intent(in):: weight7(:)
                    
    integer, pointer:: array_avr(:,:,:,:,:,:,:) ! (out)

    integer, pointer:: array_avr_work(:,:,:,:,:,:,:)

                        integer, pointer:: array_avr_work1(:,:,:,:,:,:,:)
                    
    integer, pointer:: array_avr_work2(:,:,:,:,:,:,:)
                    
    integer, pointer:: array_avr_work3(:,:,:,:,:,:,:)
                    
    integer, pointer:: array_avr_work4(:,:,:,:,:,:,:)
                    
    integer, pointer:: array_avr_work5(:,:,:,:,:,:,:)
                    
    integer, pointer:: array_avr_work6(:,:,:,:,:,:,:)
                    
    integer, pointer:: array_avr_work7(:,:,:,:,:,:,:)
                    

    integer:: array_shape(7)
    integer:: i, dim_size
    real(DP):: weight_sum
  continue

    array_shape = shape( array )
    array_avr_work => array

                    
                      
                        
    if ( space_average(1) ) then
      dim_size = array_shape(1)
      array_shape(1) = 1
      allocate( array_avr_work1( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work1 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work1(1,:,:,:,:,:,:) = array_avr_work1(1,:,:,:,:,:,:) + array_avr_work(i,:,:,:,:,:,:) * weight1(i)
        weight_sum = weight_sum + weight1(i)
      end do
      array_avr_work1 = array_avr_work1 / weight_sum
      array_avr_work  => array_avr_work1
    end if

                        

    if ( space_average(2) ) then
      dim_size = array_shape(2)
      array_shape(2) = 1
      allocate( array_avr_work2( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work2 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work2(:,1,:,:,:,:,:) = array_avr_work2(:,1,:,:,:,:,:) + array_avr_work(:,i,:,:,:,:,:) * weight2(i)
        weight_sum = weight_sum + weight2(i)
      end do
      array_avr_work2 = array_avr_work2 / weight_sum
      array_avr_work  => array_avr_work2
    end if

                        

    if ( space_average(3) ) then
      dim_size = array_shape(3)
      array_shape(3) = 1
      allocate( array_avr_work3( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work3 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work3(:,:,1,:,:,:,:) = array_avr_work3(:,:,1,:,:,:,:) + array_avr_work(:,:,i,:,:,:,:) * weight3(i)
        weight_sum = weight_sum + weight3(i)
      end do
      array_avr_work3 = array_avr_work3 / weight_sum
      array_avr_work  => array_avr_work3
    end if

                        

    if ( space_average(4) ) then
      dim_size = array_shape(4)
      array_shape(4) = 1
      allocate( array_avr_work4( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work4 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work4(:,:,:,1,:,:,:) = array_avr_work4(:,:,:,1,:,:,:) + array_avr_work(:,:,:,i,:,:,:) * weight4(i)
        weight_sum = weight_sum + weight4(i)
      end do
      array_avr_work4 = array_avr_work4 / weight_sum
      array_avr_work  => array_avr_work4
    end if

                        

    if ( space_average(5) ) then
      dim_size = array_shape(5)
      array_shape(5) = 1
      allocate( array_avr_work5( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work5 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work5(:,:,:,:,1,:,:) = array_avr_work5(:,:,:,:,1,:,:) + array_avr_work(:,:,:,:,i,:,:) * weight5(i)
        weight_sum = weight_sum + weight5(i)
      end do
      array_avr_work5 = array_avr_work5 / weight_sum
      array_avr_work  => array_avr_work5
    end if

                        

    if ( space_average(6) ) then
      dim_size = array_shape(6)
      array_shape(6) = 1
      allocate( array_avr_work6( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work6 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work6(:,:,:,:,:,1,:) = array_avr_work6(:,:,:,:,:,1,:) + array_avr_work(:,:,:,:,:,i,:) * weight6(i)
        weight_sum = weight_sum + weight6(i)
      end do
      array_avr_work6 = array_avr_work6 / weight_sum
      array_avr_work  => array_avr_work6
    end if

                        

    if ( space_average(7) ) then
      dim_size = array_shape(7)
      array_shape(7) = 1
      allocate( array_avr_work7( array_shape(1) &
                                  & , array_shape(2) &
                          
        & , array_shape(3) &
                          
        & , array_shape(4) &
                          
        & , array_shape(5) &
                          
        & , array_shape(6) &
                          
        & , array_shape(7) &
                          
        &  ) )
      array_avr_work7 = 0
      weight_sum = 0.0_DP
      do i = 1, dim_size
        array_avr_work7(:,:,:,:,:,:,1) = array_avr_work7(:,:,:,:,:,:,1) + array_avr_work(:,:,:,:,:,:,i) * weight7(i)
        weight_sum = weight_sum + weight7(i)
      end do
      array_avr_work7 = array_avr_work7 / weight_sum
      array_avr_work  => array_avr_work7
    end if

                        
                      

                    


      allocate( array_avr( array_shape(1) &
                            & , array_shape(2) &
                    
        & , array_shape(3) &
                    
        & , array_shape(4) &
                    
        & , array_shape(5) &
                    
        & , array_shape(6) &
                    
        & , array_shape(7) &
                    
        & ) )

      array_avr = array_avr_work

      nullify( array_avr_work )

                          if ( associated( array_avr_work1 ) ) deallocate( array_avr_work1 )
                    
      if ( associated( array_avr_work2 ) ) deallocate( array_avr_work2 )
                    
      if ( associated( array_avr_work3 ) ) deallocate( array_avr_work3 )
                    
      if ( associated( array_avr_work4 ) ) deallocate( array_avr_work4 )
                    
      if ( associated( array_avr_work5 ) ) deallocate( array_avr_work5 )
                    
      if ( associated( array_avr_work6 ) ) deallocate( array_avr_work6 )
                    
      if ( associated( array_avr_work7 ) ) deallocate( array_avr_work7 )
                    

  end subroutine AverageReduceInt7


end module gtool_historyauto_internal

!--
! vi:set readonly sw=4 ts=8:
!
!Local Variables:
!mode: f90
!buffer-read-only: t
!End:
!
!++
