! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

subroutine GDNcVarPutAttrInt(var, name, value, err)
    use gtdata_netcdf_types, only: GD_NC_VARIABLE, GD_NC_VARIABLE_ENTRY
    use gtdata_netcdf_file_generic, only: GDNcFileDefineMode
    use gtdata_netcdf_internal, only: vtable_lookup
    use netcdf_f77, only: NF_PUT_ATT_INT, NF_NOERR, NF_DEL_ATT, &
        NF_ENOTINDEFINE, NF_INT, NF_GLOBAL
    use dc_url, only: GT_PLUS
    use dc_error
    implicit none
    type(GD_NC_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    type(GD_NC_VARIABLE_ENTRY):: ent
    integer, intent(in):: value(:)
    logical, intent(out), optional:: err
    integer:: stat
continue
    stat = vtable_lookup(var, ent)
    if (stat /= NF_NOERR) goto 999
    if (size(value) == 0) then
        if (name(1:1) == GT_PLUS) then
            stat = nf_del_att(ent%fileid, NF_GLOBAL, name=name(2:))
        else
            stat = nf_del_att(ent%fileid, ent%varid, name=name)
        endif
        goto 999
    endif
    stat = GDNcFileDefineMode(ent%fileid)
    if (stat /= NF_NOERR) goto 999
    if (name(1:1) == GT_PLUS) then
        stat = nf_put_att_int(ent%fileid, NF_GLOBAL, name=name(2:), &
            xtype=NF_INT, len=size(value), ivals=value)
    else
        stat = nf_put_att_int(ent%fileid, ent%varid, name=name, &
            xtype=NF_INT, len=size(value), ivals=value)
    endif
    999 continue
    call StoreError(stat, 'GDNcVarPutAttrInt', err)
end subroutine
