!= gtool_history_nmlinfo 󶡤³ΰѻ
!= Interface of procedures provided from gtool_history_nmlinfo
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: gtool_history_nmlinfo_generic.f90,v 1.4 2009-10-10 10:59:01 morikawa Exp $
! Tag Name::  $Name: gtool5-20100413 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module gtool_history_nmlinfo_generic
  !
  != gtool_history_nmlinfo 󶡤³ΰѻ
  != Interface of procedures provided from gtool_history_nmlinfo
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ⥸塼γפˤĤƤ, gtool_history_nmlinfo 
  ! 򻲾Ȥ. 
  !
  ! See "gtool_history_nmlinfo" for brief of this module. 
  !
  !== Procedures List
  !
  ! HstNmlInfoCreate            :: gtool_history_nmlinfo_types#GTHST_NMLINFO ѿν
  ! HstNmlInfoClose             :: gtool_history_nmlinfo_types#GTHST_NMLINFO ѿνλ
  ! HstNmlInfoPutLine           :: gtool_history_nmlinfo_types#GTHST_NMLINFO ѿ˳ǼƤΰ
  ! HstNmlInfoInitialized       :: gtool_history_nmlinfo_types#GTHST_NMLINFO ѿꤵƤ뤫ݤ
  ! HstNmlInfoDefineMode        :: ⡼ɤξ˿֤
  ! HstNmlInfoEndDefine         :: ѿ⡼ɤϥ⡼ɤѹ
  ! HstNmlInfoReDefine          :: ϥ⡼ɤѿ⡼ɤѹ
  ! HstNmlInfoAdd               :: ѿɲ
  ! HstNmlInfoDelete            :: ѿκ
  ! HstNmlInfoResetDefault      :: ǥեΤߤ᤹
  ! HstNmlInfoInquire           :: ѿ䤤碌
  ! HstNmlInfoAssocGtHist       :: ѿ˱ gtool_history_types#GT_HISTORY ѿ֤
  ! HstNmlInfoOutputStepDisable :: output_step  .false. ֤褦ꤹ
  ! HstNmlInfoOutputStep        :: Ϥ꤬ͭǤ˿֤
  ! HstNmlInfoOutputValid       :: ߤλ郎ϤΥߥ󥰤ξ˿֤
  ! HstNmlInfoNames             :: ϿƤѿ̾ꥹȤ֤ (ؿ) 
  ! HstNmlInfoGetNames          :: ϿƤѿ̾ꥹȤ֤ (֥롼) 
  ! HstNmlInfoAllVarIniCheck    :: ꤵƤʤѿ̾Υå
  ! HstNmlInfoSetValidName      :: ѿ̾ͭ
  ! HstNmlInfoAllNameValid      :: ̵ѿ̾Υå
  ! ------------      :: ------------
  ! HstNmlInfoCreate            :: Constructor of "gtool_history_nmlinfo_types#GTHST_NMLINFO"
  ! HstNmlInfoClose             :: Deconstructor of "gtool_history_nmlinfo_types#GTHST_NMLINFO"
  ! HstNmlInfoPutLine           :: Print information of "gtool_history_nmlinfo_types#GTHST_NMLINFO"
  ! HstNmlInfoInitialized       :: Check initialization of "gtool_history_nmlinfo_types#GTHST_NMLINFO"
  ! HstNmlInfoDefineMode        :: True is returned if current state is define mode
  ! HstNmlInfoEndDefine         :: Transit define mode about information of variables to output mode
  ! HstNmlInfoReDefine          :: Transit output mode to define mode about information of variables
  ! HstNmlInfoAdd               :: Add information of variables
  ! HstNmlInfoDelete            :: Delete information of variables
  ! HstNmlInfoResetDefault      :: Reset to default settings
  ! HstNmlInfoInquire           :: Inquire information of variables
  ! HstNmlInfoAssocGtHist       :: "gtool_history_types#GT_HISTORY" correspond to variable is returned
  ! HstNmlInfoOutputStepDisable :: Configure that "output_step" returns .false. already
  ! HstNmlInfoOutputStep        :: True is returned when a configuration of output is valid
  ! HstNmlInfoOutputValid       :: True is returned when current time is output timing
  ! HstNmlInfoNames             :: Return list of registerd variable identifiers (function)
  ! HstNmlInfoGetNames          :: Return list of registerd variable identifiers (subroutine)
  ! HstNmlInfoAllVarIniCheck    :: Check uninitialized variable names
  ! HstNmlInfoSetValidName      :: Set validation to variable names
  ! HstNmlInfoAllNameValid      :: Check invalid variable names
  !
  !== Usage
  !
  ! Υ⥸塼ϰʲΤ褦ʼѤƤ. 
  !
  ! Υ⥸塼Ѥץ Fortran ץ
  ! ץȤ
  ! http://www.gfd-dennou.org/library/dcpam/dcpam4/dcpam4_current/script/f90/dcmodel_f90sample_maker.rb
  ! Ǥޤ. Ruby ǵҤƤ, ¹Ԥ뤳Ȥ
  ! ץȤʤ Fortran ץबޤ. 
  ! βΤߤǤϼºݤˡ䤴פʬˤ, 
  ! ץ Fortran ץºݤ˸Ƥߤ뤳Ȥ򥪥ᤷޤ. 
  ! 
  ! 0. ⥸塼, gtool_history_nmlinfo_types#GTHST_NMLINFO ѿƤޤ. 
  !
  ! 1. HstNmlInfoCreate Ѥ, gtool_history_nmlinfo_types#GTHST_NMLINFO ѿνԤޤ. 
  !    κݤ˥ǥեȤνϴֳ *interval_value*, 
  !    *interval_unit*,  *precision*, ֤ʿѲ *time_average*, 
  !    ϥե̾Ƭ *fileprefix* ꤷޤ. 
  !
  ! 2. ץबǥեȤǽϤѿ, Add 
  !    ѤϿƤ. 
  !    *name* ˤѿ̾Ϳޤ. *name* ѿ̤뤿Υ
  !    Ѥ뤿, ۤʤѿФƱ *name* ꤷʤ
  !    . 
  !    *file* ˤϽϥե̾Ϳޤ. Ϳʤ, 
  !    Ŭʥե̾ꤵޤ. 
  !    ¾ξϾ嵭ƱͤǤ. 
  !
  ! 3. NAMELIST 줿ѿξ, 
  !    HstNmlInfoAdd ѤϿƤ. 
  !    HstNmlInfoAdd ǴϿѤߤ *name* Ͽ뤳Ȥ, 
  !    ꤬񤭤ޤ. 
  !
  ! 4. Ͽλ, HstNmlInfoEndDefine Ѥ, 
  !    ⡼ɤϥ⡼ɤذܹԤƤ. 
  !
  ! 5. gtool_history_generic#HistoryCreate, gtool_history_generic#HistoryAddVariable
  !    gtool_history_generic#HistoryPut ǽꤪӥǡϤԤݤˤ, 
  !    HstNmlInfoAssocGtHist Ф, ѿ̾ *name* 
  !    gtool_history_types#GT_HISTORY Υݥ *history* ϤƤ. 
  !    gtool_history_nmlinfo_types#GTHST_NMLINFO ѿϿƤ
  !    *name* ˴ؤ gtool_history_types#GT_HISTORY ѿ˷礵줿
  !    *history* ֤ޤ.  *history* 
  !    嵭 gtool_history Υ֥롼󷲤ΰ *history* Ϥ
  !    ꤪӥǡϤԤäƤ. 
  !    gtool_history_generic#HistoryCreate ɬפ
  !    ϴֳ֤٤ HstNmlInfoInquire Ѥ뤳ȤǤޤ. 
  !    Ѹ, NULLIFY ˤä *history* ֤ˤƤ. 
  !    (DEALLOCATE ѤȽϤ˴ؤ󤬼뤿, 
  !    ѤʤǤ). 
  !
  !    줾ѿ˴ؤ, ꤬ͭɤˤĤƤ, 
  !    HstNmlInfoOutputValid Τ뤳ȤǽǤ. 
  !
  !    ޤ, ʬ gtool_history_generic#HistoryPut Ѥ
  !    , ߻郎ϥߥ󥰤ɤˤĤƤ, 
  !    HstNmlInfoOutputStep Τ뤳ȤǽǤ. 
  !
  ! 6. եνϤλ, 嵭μƱͤ
  !    gtool_history_types#GT_HISTORY  *history* , 
  !    gtool_history_generic#HistoryClose ˤäƽλԤäƤ. 
  !
  ! 7. Ǹ, HstNmlInfoClose ˤä, gtool_history_nmlinfo_types#GTHST_NMLINFO ѿ
  !    λԤޤ.
  !
  !
  ! Use this module as follows. 
  !
  ! Sample Fortran programs generator (Ruby script) is available from 
  ! http://www.gfd-dennou.org/library/dcpam/dcpam4/dcpam4_current/script/f90/dcmodel_f90sample_maker.rb .
  ! Sample Fortran programs are created by executing this script. 
  ! Because neither actual usage nor the profit are understood 
  ! easily only from the following explanations, 
  ! It is recommended to see sample Fortran programs actually.
  ! 
  ! 0. Declare "gtool_history_nmlinfo_types#GTHST_NMLINFO" variable in the module. 
  !
  ! 1. Initialize "gtool_history_nmlinfo_types#GTHST_NMLINFO" variable by "HstNmlInfoCreate". 
  !    On this occasion, configure default 
  !    *interval_value*, *interval_unit*, 
  !    *precision*, *time_average*, *fileprefix* (prefix of output file). 
  !
  ! 2. Register by using "HstNmlInfoAdd" when there are variables that 
  !    the program outputs by default. 
  !    variable identifier is given to *name*. Do not specify same *name* 
  !    for different variables because *name* is used as a key to 
  !    identify the variable. The output file name is given to *file*. 
  !    A suitable file name is set when not giving it. 
  !    The extra information is similar to the above-mentioned. 
  !
  ! 3. Register information of output variables obtained from NAMELIST
  !    by using "HstNmlInfoAdd". When registered *name* is registered again, 
  !    the setting concerning the *name* has been overwritten. 
  !
  ! 4. Shift from the define mode to output mode by using "HstNmlInfoEndDefine"
  !    when registration is completed. 
  !
  ! 5. Pass "HstNmlInfoAssocGtHist" variable identifier *name* and 
  !    *history* of "gtool_history_types#GT_HISTORY" pointer when 
  !    setting output and data output is performed with 
  !    "gtool_history_generic#HistoryCreate", "gtool_history_generic#HistoryAddVariable" 
  !    "gtool_history_generic#HistoryPut" etc. 
  !    *history* is associated to "gtool_history_types#GT_HISTORY" correspond 
  !    to *name* stored in "gtool_history_nmlinfo_types#GTHST_NMLINFO" variable. 
  !    Pass the *history* to subroutines in "gtool_history" above-mentioned, 
  !    and configure output setting and output data. 
  !    Necessary output interval and precision for 
  !    "gtool_history_generic#HistoryCreate" can be obtained by using 
  !    "HstNmlInfoInquire". 
  !    Please put *history* into a null state by NULLIFY after use. 
  !    (Information of output is lost when DEALLOCATE is used, 
  !    so do not use it). 
  !
  !    It can know whether the output setting is effective 
  !    for each variable with "output_valid". 
  !
  !    Moreover, it can know time now to be whether output timing 
  !    when "gtool_history_generic#HistoryPut" is used 
  !    while integrating time with "output_step". 
  !
  ! 6. Acquire *history* of "gtool_history_types#GT_HISTORY" type as well as
  !    the above-mentioned procedure, and terminate that by 
  !    "gtool_history_generic#HistoryClose" when the output of the file ends. 
  !
  ! 7. Finally, the termination of the variable of "gtool_history_nmlinfo_types#GTHST_NMLINFO" 
  !    type is done by "Close". 
  !

  implicit none
  private
  public:: HstNmlInfoCreate, HstNmlInfoClose
  public:: HstNmlInfoPutLine, HstNmlInfoInitialized
  public:: HstNmlInfoDefineMode, HstNmlInfoEndDefine, HstNmlInfoReDefine
  public:: HstNmlInfoAdd, HstNmlInfoDelete
  public:: HstNmlInfoResetDefault
  public:: HstNmlInfoInquire
  public:: HstNmlInfoAssocGtHist
  public:: HstNmlInfoOutputStepDisable
  public:: HstNmlInfoOutputStep
  public:: HstNmlInfoOutputValid
  public:: HstNmlInfoNames, HstNmlInfoGetNames
  public:: HstNmlInfoAllVarIniCheck
  public:: HstNmlInfoSetValidName
  public:: HstNmlInfoAllNameValid

  !-----------------------------------------------------------------
  !  ³
  !  Public procedures
  !-----------------------------------------------------------------

  interface HstNmlInfoCreate
    subroutine HstNmlInfoCreate( gthstnml, &
      & interval_value, &
      & interval_unit, &
      & precision, &
      & time_average, average, &
      & fileprefix, &
      & origin_value, origin_unit, &
      & terminus_value, terminus_unit, &
      & slice_start, slice_end, slice_stride, &
      & space_average, &
      & newfile_intvalue, newfile_intunit, &
      & err )
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      use dc_types, only: DP
      type(GTHST_NMLINFO), intent(inout):: gthstnml
      real(DP), intent(in), optional:: interval_value
      character(*), intent(in), optional:: interval_unit
      character(*), intent(in), optional:: precision
      logical, intent(in), optional:: time_average
      logical, intent(in), optional:: average
      character(*), intent(in), optional:: fileprefix
      real(DP), intent(in), optional:: origin_value
      character(*), intent(in), optional:: origin_unit
      real(DP), intent(in), optional:: terminus_value
      character(*), intent(in), optional:: terminus_unit
      integer, intent(in), optional:: slice_start(:)
      integer, intent(in), optional:: slice_end(:)
      integer, intent(in), optional:: slice_stride(:)
      logical, intent(in), optional:: space_average(:)
      integer, intent(in), optional:: newfile_intvalue
      character(*), intent(in), optional:: newfile_intunit
      logical, intent(out), optional:: err
    end subroutine HstNmlInfoCreate
  end interface

  interface HstNmlInfoClose
    subroutine HstNmlInfoClose( gthstnml, err )
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      type(GTHST_NMLINFO), intent(inout):: gthstnml
      logical, intent(out), optional:: err
    end subroutine HstNmlInfoClose
  end interface

  interface HstNmlInfoPutLine
    subroutine HstNmlInfoPutLine( gthstnml, unit, indent, err )
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      type(GTHST_NMLINFO), intent(in):: gthstnml
      integer, intent(in), optional:: unit
      character(*), intent(in), optional:: indent
      logical, intent(out), optional:: err
    end subroutine HstNmlInfoPutLine
  end interface

  interface HstNmlInfoInitialized
    logical function HstNmlInfoInitialized( gthstnml ) result(result)
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      type(GTHST_NMLINFO), intent(in):: gthstnml
    end function HstNmlInfoInitialized
  end interface

  interface HstNmlInfoDefineMode
    logical function HstNmlInfoDefineMode( gthstnml ) result(result)
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      type(GTHST_NMLINFO), intent(in):: gthstnml
    end function HstNmlInfoDefineMode
  end interface

  interface HstNmlInfoEndDefine
    subroutine HstNmlInfoEndDefine( gthstnml, err )
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      type(GTHST_NMLINFO), intent(inout):: gthstnml
      logical, intent(out), optional:: err
    end subroutine HstNmlInfoEndDefine
  end interface

  interface HstNmlInfoReDefine
    subroutine HstNmlInfoReDefine( gthstnml, err )
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      type(GTHST_NMLINFO), intent(inout):: gthstnml
      logical, intent(out), optional:: err
    end subroutine HstNmlInfoReDefine
  end interface

  interface HstNmlInfoAdd
    recursive subroutine HstNmlInfoAdd( gthstnml, &
      & name, file, &
      & interval_value, interval_unit, &
      & precision, &
      & time_average, average, &
      & fileprefix, &
      & origin_value, origin_unit, &
      & terminus_value, terminus_unit, &
      & slice_start, slice_end, slice_stride, &
      & space_average, &
      & newfile_intvalue, newfile_intunit, &
      & err )
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      use dc_types, only: DP
      type(GTHST_NMLINFO), intent(inout):: gthstnml
      character(*), intent(in), optional:: name
      character(*), intent(in), optional:: file
      real(DP), intent(in), optional:: interval_value
      character(*), intent(in), optional:: interval_unit
      character(*), intent(in), optional:: precision
      logical, intent(in), optional:: time_average
      logical, intent(in), optional:: average
      character(*), intent(in), optional:: fileprefix
      real(DP), intent(in), optional:: origin_value
      character(*), intent(in), optional:: origin_unit
      real(DP), intent(in), optional:: terminus_value
      character(*), intent(in), optional:: terminus_unit
      integer, intent(in), optional:: slice_start(:)
      integer, intent(in), optional:: slice_end(:)
      integer, intent(in), optional:: slice_stride(:)
      logical, intent(in), optional:: space_average(:)
      integer, intent(in), optional:: newfile_intvalue
      character(*), intent(in), optional:: newfile_intunit
      logical, intent(out), optional:: err
    end subroutine HstNmlInfoAdd
  end interface

  interface HstNmlInfoDelete
    recursive subroutine HstNmlInfoDelete( gthstnml, name, err )
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      type(GTHST_NMLINFO), intent(inout):: gthstnml
      character(*), intent(in):: name
      logical, intent(out), optional:: err
    end subroutine HstNmlInfoDelete
  end interface

  interface HstNmlInfoResetDefault
    subroutine HstNmlInfoResetDefault( gthstnml, err )
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      type(GTHST_NMLINFO), intent(inout):: gthstnml
      logical, intent(out), optional:: err
    end subroutine HstNmlInfoResetDefault
  end interface

  interface HstNmlInfoInquire
    subroutine HstNmlInfoInquire( gthstnml, &
      & name, &
      & file, &
      & interval_value, &
      & interval_unit, &
      & precision, &
      & time_average, average, &
      & fileprefix, &
      & origin_value, origin_unit, &
      & terminus_value, terminus_unit, &
      & slice_start, slice_end, slice_stride, &
      & space_average, &
      & newfile_intvalue, newfile_intunit, &
      & err )
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      use dc_types, only: DP
      type(GTHST_NMLINFO), intent(in):: gthstnml
      character(*), intent(in), optional:: name
      character(*), intent(out), optional:: file
      real(DP), intent(out), optional:: interval_value
      character(*), intent(out), optional:: interval_unit
      character(*), intent(out), optional:: precision
      logical, intent(out), optional:: time_average
      logical, intent(out), optional:: average
      character(*), intent(out), optional:: fileprefix
      real(DP), intent(out), optional:: origin_value
      character(*), intent(out), optional:: origin_unit
      real(DP), intent(out), optional:: terminus_value
      character(*), intent(out), optional:: terminus_unit
      integer, intent(out), optional:: slice_start(:)
      integer, intent(out), optional:: slice_end(:)
      integer, intent(out), optional:: slice_stride(:)
      logical, intent(out), optional:: space_average(:)
      integer, intent(out), optional:: newfile_intvalue
      character(*), intent(out), optional:: newfile_intunit
      logical, intent(out), optional:: err
    end subroutine HstNmlInfoInquire
  end interface

  interface HstNmlInfoAssocGtHist
    subroutine HstNmlInfoAssocGtHist( gthstnml, &
      & name, history, err )
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      use gtool_history, only: GT_HISTORY
      type(GTHST_NMLINFO), intent(in):: gthstnml
      character(*), intent(in):: name
      type(GT_HISTORY), pointer:: history
      logical, intent(out), optional:: err
    end subroutine HstNmlInfoAssocGtHist
  end interface

  interface HstNmlInfoOutputStepDisable
    subroutine HstNmlInfoOutputStepDisable( gthstnml, &
      & name, err )
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      type(GTHST_NMLINFO), intent(in):: gthstnml
      character(*), intent(in):: name
      logical, intent(out), optional:: err
    end subroutine HstNmlInfoOutputStepDisable
  end interface

  interface HstNmlInfoOutputStep
    logical function HstNmlInfoOutputStep( gthstnml, &
      & name, time ) result(result)
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      use gtool_history, only: GT_HISTORY
      use dc_date_types, only: DC_DIFFTIME
      type(GTHST_NMLINFO), intent(in):: gthstnml
      character(*), intent(in):: name
      type(DC_DIFFTIME), intent(in):: time
    end function HstNmlInfoOutputStep
  end interface

  interface HstNmlInfoOutputValid
    logical function HstNmlInfoOutputValid( gthstnml, &
      & name ) result(result)
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      type(GTHST_NMLINFO), intent(in):: gthstnml
      character(*), intent(in):: name
    end function HstNmlInfoOutputValid
  end interface

  interface HstNmlInfoNames
    function HstNmlInfoNames( gthstnml ) result(result)
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      use dc_types, only: STRING
      character(STRING):: result
      type(GTHST_NMLINFO), intent(in):: gthstnml
    end function HstNmlInfoNames
  end interface

  interface HstNmlInfoGetNames
    subroutine HstNmlInfoGetNames( gthstnml, varnames_ary, err )
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      use dc_types, only: TOKEN
      type(GTHST_NMLINFO), intent(in):: gthstnml
      character(TOKEN), pointer:: varnames_ary(:)
      logical, intent(out), optional:: err
    end subroutine HstNmlInfoGetNames
  end interface

  interface HstNmlInfoAllVarIniCheck
    subroutine HstNmlInfoAllVarIniCheck( gthstnml, &
      & invalid, &
      & names, &
      & err )
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      type(GTHST_NMLINFO), intent(in):: gthstnml
      logical, intent(out):: invalid
      character(*), intent(out):: names
      logical, intent(out), optional:: err
    end subroutine HstNmlInfoAllVarIniCheck
  end interface

  interface HstNmlInfoSetValidName
    subroutine HstNmlInfoSetValidName( gthstnml, &
      & name, &
      & err )
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      type(GTHST_NMLINFO), intent(in):: gthstnml
      character(*), intent(in):: name
      logical, intent(out), optional:: err
    end subroutine HstNmlInfoSetValidName
  end interface

  interface HstNmlInfoAllNameValid
    subroutine HstNmlInfoAllNameValid( gthstnml, &
      & invalid, &
      & names, &
      & err )
      use gtool_history_nmlinfo_types, only: GTHST_NMLINFO
      type(GTHST_NMLINFO), intent(in):: gthstnml
      logical, intent(out):: invalid
      character(*), intent(out):: names
      logical, intent(out), optional:: err
    end subroutine HstNmlInfoAllNameValid
  end interface

end module gtool_history_nmlinfo_generic
