!= gtool_history_nmlinfo 󶡤빽¤ǡ
!= Derived data type of "gtool_history_nmlinfo"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: gtool_history_nmlinfo_types.f90,v 1.3 2009-06-01 15:17:18 morikawa Exp $
! Tag Name::  $Name: gtool5-20100413 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module gtool_history_nmlinfo_types
  !
  != gtool_history_nmlinfo 󶡤빽¤ǡ
  != Derived data type of "gtool_history_nmlinfo"
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ⥸塼γפˤĤƤ, gtool_history_nmlinfo 
  ! 򻲾Ȥ. 
  !
  ! See "gtool_history_nmlinfo" for brief of this module. 
  !
  !== Derived types List
  !
  ! GTHST_NMLINFO        :: NAMELIST Ϥ᤿¤ǡ. 
  !                         ѼԤؤ. 
  ! GTHST_NMLINFO_ENTRY  :: GTHST_NMLINFO ǤθġѿΤΥȥ. 
  !                          (ѼԤľܻȤʤ). 
  ! ------------         :: ------------
  ! GTHST_NMLINFO        :: Derived type that stores information input from NAMELIST. 
  !                         This derived type is provided for users. 
  ! GTHST_NMLINFO_ENTRY  :: Entry for individual variable in "GTHST_NMLINFO". 
  !                         This is used internally. 
  !                         (Users do not refer this derived type). 
  !

  use gtool_history, only: GT_HISTORY
  use dc_types, only: TOKEN, STRING
  implicit none
  public:: GTHST_NMLINFO, GTHST_NMLINFO_ENTRY

  type GTHST_NMLINFO
    !
    ! NAMELIST ҥȥǡνϾ
    ! Ǽ뤿ι¤ǡǤ. 
    ! ޤ, gtool_history_nmlinfo_generic#HstNmlInfoCreate 
    !  "GTHST_NMLINFO" ѿꤷƲ.
    ! ꤵ줿 "GTHST_NMLINFO" ѿѤݤˤ,
    ! gtool_history_nmlinfo_generic#HstNmlInfoClose 
    ! ˤäƽλԤäƤ.
    !
    ! This derived type is worked in order to store information about 
    ! data output from NAMELIST. 
    ! Initialize "GTHST_NMLINFO" variable by 
    ! "gtool_history_nmlinfo_generic#HstNmlInfoCreate" before usage.
    ! If you reuse "GTHST_NMLINFO" variable again for another application, 
    ! terminate by "gtool_history_nmlinfo_generic#HstNmlInfoClose".
    !
    logical:: initialized = .false.
                              ! ե饰. 
                              ! Initialization flag
    logical:: define_mode = .true.
                              ! ֤ɽե饰. 
                              ! Flag that represents define mode
    type(GTHST_NMLINFO_ENTRY), pointer:: gthstnml_list =>null()
                              ! ѿȤξꥹ. 
                              ! ǼˤĤƤ
                              ! GTHST_NMLINFO_ENTRY 򻲾ȤΤ. 
                              !
                              ! Information list about individual variable 
                              ! See "GTHST_NMLINFO_ENTRY" 
                              ! about stored information. 
  end type GTHST_NMLINFO

  type GTHST_NMLINFO_ENTRY
    !
    ! ѿȤξǼ뤿ι¤ΤǤ. 
    ! ι¤Τϥ⥸塼ǻѤ뤳ȤꤷƤ뤿, 
    ! ⥸塼볰ϻѤʤǤ. 
    !
    ! Information about individual output variable is stored in
    ! this derived type.
    ! It is expected that this derived type is used
    ! internally, so do not refer from the outside.
    !
    character(TOKEN):: name
                              ! ѿ̾. Variable identifier
    character(STRING):: file
                              ! ҥȥǡΥե̾. 
                              ! History data filenames
    real, pointer:: interval_value =>null()
                              ! ҥȥǡνϴֳ֤ο. 
                              ! ͤͿ, Ϥ޻ߤޤ. 
                              ! 
                              ! Numerical value for interval of history data output. 
                              ! Negative values suppresses output.
    character(TOKEN), pointer:: interval_unit =>null()
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(TOKEN), pointer:: precision =>null()
                              ! ҥȥǡ. 
                              ! Precision of history data
    logical, pointer:: time_average =>null()
                              ! ϥǡλʿѲե饰. 
                              ! Flag for time average of output data.
    character(STRING), pointer:: fileprefix =>null()
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefixes of history data filenames

    real, pointer:: origin_value =>null()
                              ! ϳϻ. 
                              ! Start time of output. 
    character(TOKEN), pointer:: origin_unit =>null()
                              ! ϳϻñ. 
                              ! Unit of start time of output. 
    real, pointer:: terminus_value =>null()
                              ! Ͻλ. 
                              ! End time of output. 
    character(TOKEN), pointer:: terminus_unit =>null()
                              ! Ͻλñ. 
                              ! Unit of end time of output. 
    integer, pointer:: slice_start(:) =>null()
                              ! γ. 
                              ! Start points of spaces. 
    integer, pointer:: slice_end(:) =>null()
                              ! νλ. 
                              ! End points of spaces. 
    integer, pointer:: slice_stride(:) =>null()
                              ! ι. 
                              ! Strides of spaces. 
    logical, pointer:: space_average(:) =>null()
                              ! ʿѲΥե饰. 
                              ! Flag of average. 
    integer, pointer:: newfile_intvalue =>null()
                              ! եʬֳִ. 
                              ! Interval of time of separation of a file. 
    character(TOKEN), pointer:: newfile_intunit =>null()
                              ! եʬֳִ֤ñ. 
                              ! Unit of interval of time of separation of a file. 

    logical:: output_step_disable = .false.
                              ! output_step ̵ե饰. 
                              ! "output_step" disable flag
    logical:: name_invalid = .true.
                              ! ̵ѿ̾Τ뤿Υե饰.
                              ! A flag for detection of invalid variable names
    type(GT_HISTORY), pointer:: history =>null()
                              ! gtool_history ⥸塼ѹ¤. 
                              ! Derived type for "gtool_history" module
    type(GTHST_NMLINFO_ENTRY), pointer:: next =>null()
                              ! ꥹȹ¤Τѿ. 
                              ! A variable for a list structure
  end type GTHST_NMLINFO_ENTRY

end module gtool_history_nmlinfo_types
