!= 
!= Setting of calendar
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dccalcreate.f90,v 1.4 2009-10-18 12:02:32 morikawa Exp $
! Tag Name::  $Name: gtool5-20101228-1 $
! Copyright:: Copyright (C) GFD Dennou Club, 2009-. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! Υե˵ܤ³ dc_calendar ⥸塼뤫󶡤ޤ. 
!
! Procedures described in this file are provided from "dc_calendar" module. 
!

subroutine DCCalCreate1( cal_type, cal, err )
  !
  ! Ԥޤ. 
  !
  ! Υ֥롼 "dc_calendar" ⥸塼Ѱդ
  ! ꤹΤǤ. 1 , 1 ÿʤɤ
  ! Ǥդ˻ꤹˤ, Ʊ̾Υ֥롼ѤƲ. 
  !
  ! *cal_type* ȤưʲΤΤͭǤ. ʳʸ
  ! Ϳˤϥ顼ȯޤ. ʸȾʸ϶̤ޤ. 
  !
  ! gregorian         :: 쥴ꥪ
  ! julian            :: ꥦ
  ! noleap            :: ǯ̵
  ! 360day            :: 1 30 
  ! cyclic            :: 
  !                      30.6    ޤǤ
  !                      ξʲڼΤȤ
  !
  ! άǽ *cal* ά줿ˤ, dc_calendar 
  ! ݻ "dc_calendar_types#DC_CAL" ѿ
  ! ꤵޤ. θμ³ *cal* άˤ
  ! 񤬻Ѥޤ. 
  ! *cal* άʤˤϤѿꤵޤ.
  ! Ѥ, ³ˤ "dc_calendar_types#DC_CAL" ѿ
  ! ͿƤ. 
  !
  ! Set calendar. 
  !
  ! This subroutine set previously-defined calendars by "dc_calendar" module. 
  ! If number of days of a month, number of seconds of a day, etc. 
  ! want to be specified arbitrarily, use a following homonymous subroutine. 
  ! 
  ! Following strings are valid as *cal_type*. 
  ! If any other strings is specified, an error is caused. 
  ! They are not case-sensitive. 
  !
  ! gregorian         :: Gregorian calendar. 
  ! julian            :: Julian calendar. 
  ! noleap            :: A calendar without leap year. 
  ! 360day            :: A calendar in which number of days of a month is 30. 
  ! cyclic            :: A calendar in which number of days of a year is
  !                      "30.6 x (number of months) - (total days until last month)"
  !                      (truncate fractional part). 
  !
  ! If an optional argument *cal* is omitted, 
  ! the calendar setting is stored to a "dc_calendar_types#DC_CAL" 
  ! variable that is saved in the "dc_calendar". 
  ! When *cal* is omitted in subsequent procedures, the internal calendar
  ! is used. 
  ! If *cal* is not omitted, the settings is stored to the *cal*. 
  ! In order to use the calendar setting, use the "dc_calendar_types#DC_CAL" 
  ! varieble to subsequent procedures. 
  !

  use dc_calendar_types, only: DC_CAL, &
    & CAL_CYCLIC, CAL_NOLEAP, CAL_JULIAN, CAL_GREGORIAN, CAL_360DAY
  use dc_calendar_internal, only: default_cal
  use dc_message, only: MessageNotify
  use dc_string, only: LChar
  use dc_trace, only: BeginSub, EndSub
  use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, DC_EBADCALTYPE
  use dc_types, only: STRING, DP
  implicit none
  character(*), intent(in):: cal_type
                              ! ꤹʸ. 
                              ! 
                              ! Strings that specify a previously-defined calendar. 
  type(DC_CAL), intent(out), optional, target:: cal
                              ! ᤿֥. 
                              ! 
                              ! An object that stores information of 
                              ! calendar. 
  logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 


  ! ѿ
  ! Work variables
  !
  type(DC_CAL), pointer:: calp =>null()
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter:: version = &
    & '$Name: gtool5-20101228-1 $' // &
    & '$Id: dccalcreate.f90,v 1.4 2009-10-18 12:02:32 morikawa Exp $'
  character(*), parameter:: subname = 'DCCalCreate1'
continue
  call BeginSub( subname, version )
  stat = DC_NOERR
  cause_c = ''

  ! ֥ȤΥݥ󥿳
  ! Associate pointer of an object
  !
  if ( present( cal ) ) then
    calp => cal
  else
    calp => default_cal
  end if

!!$  ! Υå
!!$  ! Check initialization
!!$  !
!!$  if ( calp % initialized ) then
!!$    stat = DC_EALREADYINIT
!!$    cause_c = 'DC_CAL'
!!$    goto 999
!!$  end if

  ! μ̤Υå
  ! Validate a kind of calendar
  !
  select case( LChar(trim(cal_type)) )
  case('cyclic')
    calp % cal_type = CAL_CYCLIC
  case('noleap')
    calp % cal_type = CAL_NOLEAP
  case('julian')
    calp % cal_type = CAL_JULIAN
  case('gregorian')
    calp % cal_type = CAL_GREGORIAN
  case('360day')
    calp % cal_type = CAL_360DAY
  case default
    stat = DC_EBADCALTYPE
    call MessageNotify('W', subname, &
      & 'cal_type=<%c> is invalid calender type.', &
      & c1 = trim(cal_type) )
    goto 999
  end select

  ! Ǥؤͤ
  ! Configure elements
  !
  allocate( calp % day_in_month(1:12) )
  calp % month_in_year = 12
  calp % hour_in_day   = 24
  calp % min_in_hour   = 60
  calp % sec_in_min    = 60.0_DP

  select case( calp % cal_type )
  case(CAL_CYCLIC)
    calp % day_in_month(1:12) = &
      & (/ 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 31, 30 /)
  case(CAL_NOLEAP)
    calp % day_in_month(1:12) = &
      & (/ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 /)
  case(CAL_JULIAN)
    calp % day_in_month(1:12) = &
      & (/ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 /)
  case(CAL_GREGORIAN)
    calp % day_in_month(1:12) = &
      & (/ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 /)
  case(CAL_360DAY)
    calp % day_in_month(1:12) = &
      & (/ 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30 /)
  case default
  end select

  ! λ, 㳰
  ! Termination and Exception handling
  !
  calp % initialized = .true.
999 continue
  nullify( calp )
  call StoreError( stat, subname, err, cause_c )
  call EndSub( subname )
end subroutine DCCalCreate1

subroutine DCCalCreate2( month_in_year, day_in_month, &
  &                      hour_in_day, min_in_hour, sec_in_min, &
  &                      cal, err )
  !
  ! Ԥޤ. 
  !
  ! 1 , 1 ÿʤɤ˻ꤷƲ. 
  ! 쥴ꥪꥦʤɤѤˤ
  ! 嵭Ʊ̾Υ֥롼ѤƲ. 
  !
  ! άǽ *cal* ά줿ˤ, dc_calendar 
  ! ݻ "dc_calendar_types#DC_CAL" ѿ
  ! ꤵޤ. θμ³ *cal* άˤ
  ! 񤬻Ѥޤ. 
  ! *cal* άʤˤϤѿꤵޤ.
  ! Ѥ, ³ˤ "dc_calendar_types#DC_CAL" ѿ
  ! ͿƤ. 
  !
  ! Set calendar. 
  !
  ! Specify number of days of a month, number of seconds of a day, etc. 
  ! to arguments. If Gregorian calendar, Julian calendar are needed, 
  ! see a foregoing homonymous subroutine. 
  ! 
  ! If an optional argument *cal* is omitted. 
  ! The calendar setting is stored to a "dc_calendar_types#DC_CAL" 
  ! variable that is saved in the "dc_calendar". 
  ! When *cal* is omitted in subsequent procedures, the internal calendar
  ! is used. 
  ! If *cal* is not omitted, the settings is stored to the *cal*. 
  ! In order to use the calendar setting, use the "dc_calendar_types#DC_CAL" 
  ! varieble to subsequent procedures. 
  !
  use dc_calendar_types, only: DC_CAL, CAL_USER_DEFINED
  use dc_calendar_internal, only: default_cal
  use dc_message, only: MessageNotify
  use dc_types, only: DP
  use dc_trace, only: BeginSub, EndSub
  use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, DC_EBADCALTYPE
  use dc_types, only: STRING
  implicit none
  integer, intent(in):: month_in_year
                              ! 1 ǯη. 
                              ! Months in a year. 
  integer, intent(in):: day_in_month(:)
                              ! 1 . 
                              ! Days in months. 
  integer, intent(in):: hour_in_day
                              ! 1 λֿ. 
                              ! Hours in a day. 
  integer, intent(in):: min_in_hour
                              ! 1 ֤ʬ. 
                              ! Minutes in a hour. 
  real(DP), intent(in):: sec_in_min
                              ! 1 ʬÿ. 
                              ! Seconds in a minute. 
  type(DC_CAL), intent(out), optional, target:: cal
                              ! ᤿֥. 
                              ! 
                              ! An object that stores information of 
                              ! calendar. 
  logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 


  ! ѿ
  ! Work variables
  !
  type(DC_CAL), pointer:: calp =>null()
  integer:: size_day_in_month
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter:: version = &
    & '$Name: gtool5-20101228-1 $' // &
    & '$Id: dccalcreate.f90,v 1.4 2009-10-18 12:02:32 morikawa Exp $'
  character(*), parameter:: subname = 'DCCalCreate2'
continue
  call BeginSub( subname, version )
  stat = DC_NOERR
  cause_c = ''

  ! ֥ȤΥݥ󥿳
  ! Associate pointer of an object
  !
  if ( present( cal ) ) then
    calp => cal
  else
    calp => default_cal
  end if

!!$  ! Υå
!!$  ! Check initialization
!!$  !
!!$  if ( calp % initialized ) then
!!$    stat = DC_EALREADYINIT
!!$    cause_c = 'DC_CAL'
!!$    goto 999
!!$  end if

  ! λ
  ! Evaluate number of months
  !
  size_day_in_month = size ( day_in_month ) 

  ! Υå
  ! Validate arguments
  !
  if ( .not. month_in_year == size_day_in_month ) then
    stat = DC_EBADCALTYPE
    call MessageNotify('W', subname, &
      & 'month_in_year=<%d> is not equal to size of day_in_month=<%d>', &
      & i = (/ month_in_year, size_day_in_month /) )
    goto 999
  end if

  if ( month_in_year < 1 ) then
    stat = DC_EBADCALTYPE
    call MessageNotify('W', subname, 'month_in_year=<%d> must be positive', &
      & i = (/ month_in_year /) )
    goto 999
  end if

  if ( hour_in_day < 1 ) then
    stat = DC_EBADCALTYPE
    call MessageNotify('W', subname, 'hour_in_day=<%d> must be positive', &
      & i = (/ hour_in_day /) )
    goto 999
  end if

  if ( min_in_hour < 1 ) then
    stat = DC_EBADCALTYPE
    call MessageNotify('W', subname, 'min_in_hour=<%d> must be positive', &
      & i = (/ min_in_hour /) )
    goto 999
  end if

  if ( .not. sec_in_min > 0.0_DP ) then
    stat = DC_EBADCALTYPE
    call MessageNotify('W', subname, 'sec_in_min=<%f> must be positive', &
      & d = (/ sec_in_min /) )
    goto 999
  end if

  ! Ǥؤͤ
  ! Configure elements
  !
  calp % cal_type      = CAL_USER_DEFINED
  calp % month_in_year = month_in_year
  allocate( calp % day_in_month(1:size_day_in_month) )
  calp % day_in_month  = day_in_month 
  calp % hour_in_day   = hour_in_day  
  calp % min_in_hour   = min_in_hour  
  calp % sec_in_min    = sec_in_min   

  ! λ, 㳰
  ! Termination and Exception handling
  !
  calp % initialized = .true.
999 continue
  nullify( calp )
  call StoreError( stat, subname, err, cause_c )
  call EndSub( subname )
end subroutine DCCalCreate2
