# gtool5 Fortran 90/95 Library
@ja
## gtool5 とは?

**gtool5 Fortran 90/95 ライブラリ** は地球惑星流体科学の研究・教育のため
のさまざまな数値モデルで用いることを想定して開発されているライブラリです.
[地球流体電脳倶楽部 gtool プロジェクト][gtool_project] の一環として開発・
管理されています.

gtool5 は, データ入出力をはじめ, 日付および時刻の操作やメッセージ出力,
CPU 時間の計測など, Fortran 90/95 で書かれた数値モデルのための様々な機能
を提供します. 特にデータ入出力については, 複数の人間が数値モデルから得ら
れた計算結果に対する理解・認識を共有することを容易とするために,
[gtool4 NetCDF 規約](@ref xref))に基づくデータの入出力を用いています.

gtool5 は [地球流体電脳倶楽部 dcmodel プロジェクト][dcmodel_project]
などで導入され, データの共有を容易にするとともに,
ソースコードの可読性向上にも役立っています.
論文としては [GMD 論文][GMD_paper] を参照下さい.

{TOC}

### 過去の版との関係

gtool5 は [gtool4][gtool4_url] および [gt4f90io][gt4f90io_url]
の後継となるライブラリです.

* [gt4f90io][gt4f90io_url] は [gtool4][gtool4_url] より可視化機能を分離し,
  データ I/O に特化させたライブラリです.
* gtool5 は [gt4f90io][gt4f90io_url] に
  入出力以外の汎用ユーティリティを加えたライブラリです.

## 使用上の注意とライセンス

ドキュメントの表示に利用している CSS, javascript 等を除き,
全ての配布物は2条項BSDライセンスです,
正式なライセンスについては [COPYRIGHT](@ref COPYRIGHT) を参照下さい.

### 科学者・研究者の方へのお願い

本ソフトウェアはフリーソフトウェアとしてリリースされていますが,
適切な引用を行なう科学的な作法までを免責していないことにご注意下さい.
本ソフトウェアを使用した研究を記述した論文を書く際には、
再現性の担保のためにも、適切な形式での引用をお願いします.

引用例は以下の通りです:

引用例 (和文)
> 森川 靖大, 高橋 芳幸, 佐々木 洋平, 西澤 誠也, 乙部 直人, 石渡 正樹, 小高正嗣, 竹広 真一, 堀之内 武, 林 祥介, 豊田 英司, gtool 開発グループ, 2010: gtool5 ライブラリ, http://www.gfd-dennou.org/library/gtool/gtool5, 地球流体電脳倶楽部.
引用例 (英文)
> Morikawa,Y., Takahashi,O.Y., Sasaki,Y., Nishizawa,S., Otobe,N., Ishiwatari,M., Odaka,M., Takehiro,S., Horinouchi,T., Hayashi,Y.-Y., Toyoda,E., Gtool Devlopment Group, 2010: Gtool5 library, http://www.gfd-dennou.org/library/gtool/gtool5, GFD Dennou Club.

査読付き論文しか引用できない場合には, 次の[論文][GMD_paper]を引用して下さい:
> Ishiwatari, M., Toyoda, E., Morikawa, Y., Takehiro, S., Sasaki, Y., Nishizawa, S., Odaka, M., Otobe, N., Takahashi, Y. O., Nakajima, K., Horinouchi, T., Shiotani, M., Hayashi, Y.-Y., Gtool development group, 2012: gtool5 - development of Fortran90 library for self-descriptive multi-dimensional data input/output interfaces, Geosci. Model Dev., 5, 449-455., 2012, doi:10.5194/gmd-5-449-2012.

[GMD_paper]: http://www.geosci-model-dev.net/5/449/2012/
[gtool_project]: https://www.gfd-dennou.org/library/gtool/index.htm
[dcmodel_project]: https://www.gfd-dennou.org/library/dcmodel/index.htm
[gtool4_url]: https://www.gfd-dennou.org/library/gtool4/gtool4-tools-library.htm)
[gt4f90io_url]: https://www.gfd-dennou.org/library/gtool/gt4f90io.htm

@endja
@en
## under construction
@enden


<!-- Local Variables: -->
<!-- mode: markdown -->
<!-- End: -->
