!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  lumatrix :  LU ʬˤϢΩβ
!
!  2002/01/20  ݹ
!      2002/06/10  ݹ  ٥ȥĹΤ lusol2 
!                            
  subroutine ludecomp21(alu,kp)

    ! ALU(NDIM,NDIM), KP(NDIM)
    ! NDIM x NDIM ι JDIM Ĥ٤ LU ʬ.
    ! ̣չ Ϲ˾񤭤.

    real(8), intent(inout) :: alu(:,: )                 ! ϡ̣չ
    integer, intent(out)   :: kp(size(alu,1))           ! ԥܥå

    if ( size(alu,1) > size(alu,2) ) then
       call msgdmp('E','ludecomp',&
            'The third dimension is less than the second')
    elseif( size(alu,1) < size(alu,2) ) then
       call msgdmp('W','ludecomp',&
            'The third dimension is grater than the second')
    endif

    !" Σ̣ʬʬԥܥå
    call LUMAKE( alu, kp, 1, size(alu,1) )

  end subroutine ludecomp21

  subroutine ludecomp32(alu,kp)

    ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM)
    ! NDIM x NDIM ι JDIM Ĥ٤ LU ʬ.
    ! ̣չ Ϲ˾񤭤.

    real(8), intent(inout) :: alu(:,:,:)                  ! ϡ̣չ
    integer, intent(out)   :: kp(size(alu,1),size(alu,2)) ! ԥܥå

    if ( size(alu,2) > size(alu,3) ) then
       call msgdmp('E','ludecomp',&
            'The third dimension is less than the second')
    elseif( size(alu,2) < size(alu,3) ) then
       call msgdmp('W','ludecomp',&
            'The third dimension is grater than the second')
    endif

    !" Σ̣ʬʬԥܥå
    call LUMAKE( alu, kp, size(alu,1), size(alu,2) )

  end subroutine ludecomp32

  function lusolve211(alu,kp,b)

    ! ALU(NDIM,NDIM), KP(NDIM), B(NDIM)
    ! NDIM x NDIM ϢΩ
    ! A X = B  IDIM Ĥ B ФƷ׻. 
    ! ϱդϥ٥ȥ˾񤭤

    real(8), intent(in)  :: alu(:,:)              ! ϡ̣չ
    integer, intent(in)  :: kp(:)                 ! ԥܥå
    real(8), intent(in)  :: b(:)                  ! ե٥ȥ

    real(8) :: lusolve211(size(b))                   ! 

    lusolve211 = b
    call LUSOL2( lusolve211, alu , kp, &             !" ̣ʬˤη׻
                 1, size(b) )

  end function lusolve211

  function lusolve212(alu,kp,b)

    ! ALU(NDIM,NDIM), KP(NDIM), B(JDIM,NDIM)
    ! NDIM x NDIM ϢΩ
    ! A X = B  IDIM Ĥ B ФƷ׻. 
    ! ϱդϥ٥ȥ˾񤭤

    real(8), intent(in)  :: alu(:,:)              ! ϡ̣չ
    integer, intent(in)  :: kp(:)                 ! ԥܥå
    real(8), intent(in)  :: b(:,:)                ! ե٥ȥ

    real(8) :: lusolve212(size(b,1),size(b,2))       ! 

    lusolve212 = b
    call LUSOL2( lusolve212, alu , kp, &             !" ̣ʬˤη׻
                 size(b,1), size(b,2) )

  end function lusolve212

  function lusolve322(alu,kp,b)

    ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM), B(JDIM,NDIM)
    ! NDIM x NDIM  JDIM ¤٤ϢΩ
    ! A X = B  B ФƷ׻. 
    ! ϱդϥ٥ȥ˾񤭤

    real(8), intent(in)  :: alu(:,:,:)                   ! ϡ̣չ
    integer, intent(in)  :: kp(:,:)                      ! ԥܥå
    real(8), intent(in)  :: b(:,:)                       ! ե٥ȥ

    real(8) :: lusolve322(size(b,1),size(b,2))             ! 

    lusolve322 = b
    call LUSOLV( lusolve322, alu , kp, &           !" ̣ʬˤη׻
                 1, size(b,1), size(b,2) )

  end function lusolve322

  function lusolve323(alu,kp,b)

    ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM), B(IDIM,JDIM,NDIM)
    ! NDIM x NDIM  JDIM ¤٤ϢΩ
    ! A X = B  IDIM Ĥ B ФƷ׻. 
    ! ϱդϥ٥ȥ˾񤭤

    real(8), intent(in)  :: alu(:,:,:)                   ! ϡ̣չ
    integer, intent(in)  :: kp(:,:)                      ! ԥܥå
    real(8), intent(in)  :: b(:,:,:)                     ! ե٥ȥ

    real(8) :: lusolve323(size(b,1),size(b,2),size(b,3)) ! 

    lusolve323 = b
    call LUSOLV( lusolve323, alu , kp, &           !" ̣ʬˤη׻
                 size(b,1), size(b,2), size(b,3) )

  end function lusolve323

module lumatrix
  private 
  public ludecomp, lusolve

  interface ludecomp
     subroutine ludecomp21(alu,kp)
       real(8), intent(inout) :: alu(:,: )                 ! ϡ̣չ
       integer, intent(out)   :: kp(size(alu,1))           ! ԥܥå
     end subroutine ludecomp21

     subroutine ludecomp32(alu,kp)
       real(8), intent(inout) :: alu(:,:,:)                  ! ϡ̣չ
       integer, intent(out)   :: kp(size(alu,1),size(alu,2)) ! ԥܥå
     end subroutine ludecomp32
  end interface

  interface lusolve
     function lusolve211(alu,kp,b)

      ! ALU(NDIM,NDIM), KP(NDIM), B(NDIM)
      ! NDIM x NDIM ϢΩ
      ! A X = B  IDIM Ĥ B ФƷ׻. 
      ! ϱդϥ٥ȥ˾񤭤

       real(8), intent(in)  :: alu(:,:)              ! ϡ̣չ
       integer, intent(in)  :: kp(:)                 ! ԥܥå
       real(8), intent(in)  :: b(:)                  ! ե٥ȥ
       real(8) :: lusolve211(size(b))                 ! 
     end function lusolve211

     function lusolve212(alu,kp,b)

       ! ALU(NDIM,NDIM), KP(NDIM), B(JDIM,NDIM)
       ! NDIM x NDIM ϢΩ
       ! A X = B  IDIM Ĥ B ФƷ׻. 
       ! ϱդϥ٥ȥ˾񤭤

       real(8), intent(in)  :: alu(:,:)              ! ϡ̣չ
       integer, intent(in)  :: kp(:)                 ! ԥܥå
       real(8), intent(in)  :: b(:,:)                ! ե٥ȥ

       real(8) :: lusolve212(size(b,1),size(b,2))       ! 

     end function lusolve212

     function lusolve322(alu,kp,b)

       ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM), B(JDIM,NDIM)
       ! NDIM x NDIM  JDIM ¤٤ϢΩ
       ! A X = B  B ФƷ׻. 
       ! ϱդϥ٥ȥ˾񤭤

       real(8), intent(in)  :: alu(:,:,:)                   ! ϡ̣չ
       integer, intent(in)  :: kp(:,:)                      ! ԥܥå
       real(8), intent(in)  :: b(:,:)                       ! ե٥ȥ

       real(8) :: lusolve322(size(b,1),size(b,2))             ! 
     end function lusolve322

     function lusolve323(alu,kp,b)

       ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM), B(IDIM,JDIM,NDIM)
       ! NDIM x NDIM  JDIM ¤٤ϢΩ
       ! A X = B  IDIM Ĥ B ФƷ׻. 
       ! ϱդϥ٥ȥ˾񤭤

       real(8), intent(in)  :: alu(:,:,:)                   ! ϡ̣չ
       integer, intent(in)  :: kp(:,:)                      ! ԥܥå
       real(8), intent(in)  :: b(:,:,:)                     ! ե٥ȥ

       real(8) :: lusolve323(size(b,1),size(b,2),size(b,3)) ! 

     end function lusolve323
  end interface

end module lumatrix
