#!/bin/sh
#
# Copyright (C) GFD Dennou Club, 2002.  All rights reserved.
#
fc="`which ${FC:?}`"
fflags="-I${MODINSTDIR:?} $SYSFFLAGS"
ldflags="$SYSLDFLAGS -L$LIBINSTDIR"
ldlibs="-l$LIBNAME $SYSLDLIBS"
out=${1:-dclf90config}

if [ $F90MODTYPE = intel.d ]; then
	ldlibs=`echo $ldlibs | sed s/-lm//`
fi

cat > $out <<END_OF_SCRIPT
#!/bin/sh

fc="$fc"
fflags="$fflags"
ldflags="$ldflags"
ldlibs="$ldlibs"

usage() {
	cat <<EOF
usage: gt4config [OPTIONS]
options: one of --dcllang --fc --fflags --ldflags --ldlibs
EOF
	exit 1
}

if test \$# -eq 0; then
	usage
fi

while test \$# -gt 0; do
    case \$1 in
	--fc)		echo \$fc ;;
	--fflags)	echo \$fflags ;;
	--ldflags)	echo \$ldflags ;;
	--ldlibs)	echo \$ldlibs ;;
	--dcllang)	echo f90 ;;
	*)		usage ;;
    esac
    shift
done

END_OF_SCRIPT
