!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!$BI=Bj(B  ae_module $B%F%9%H%W%m%0%i%`(B
!
!$BMzNr(B  2002/01/25  $BC]9-??0l(B
!      2002/04/10  $BC]9-??0l(B
!
program ae_test2d

  use ae_module
  implicit none
  integer, parameter :: im=8, km=3, nm=3
  real(8), parameter :: xlength=1.0
  real(8), parameter :: eps=1.0D-14
  real(8), parameter :: pi=3.1415926535897932385D0

  real(8), dimension(nm,0:im-1) :: ag_f
  real(8), dimension(nm,0:im-1) :: ag_ff
  real(8), dimension(nm,-km:km) :: ae_f
  real(8), dimension(nm,-km:km) :: ae_dfdx
  real(8), dimension(nm,-km:km) :: ae_df2dx2

  integer :: k, i, m, n

  call ae_initial(im,km,xlength)

  ag_f(1,:) = 1
  ag_f(2,:) = sin(2*pi*g_x)
  ag_f(3,:) = cos(4*pi*g_x)

  write(6,*) 'f(1,:) = 1'
  write(6,*) 'f(2,:) = sin(2*pi*g_x)'
  write(6,*) 'f(3,:) = cos(4*pi*g_x)'
  write(6,*) 

  ae_f    = ae_ag(ag_f)
  ag_ff   = ag_ae(ae_f)
  ae_dfdx   = ae_dx_ae(ae_f)
  ae_df2dx2 = ae_dx_ae(ae_dx_ae(ae_f))

  write(6,*) 'Fourier Transform'
  do n=1,nm
     write(6,*) 'n=',n
     write(6,*) ae_f(n,:)
  enddo
  write(6,*) 
  write(6,*) 'Inverse Transform - original (result should be 0)'
  do n=1,nm
     write(6,*) 'n=',n
     write(6,*) ag_f(n,:) - ag_ff(n,:)
  enddo

  write(6,*) 
  write(6,*) 'Differentiation'
  do n=1,nm
     write(6,*) 'n=',n
     write(6,*) ae_dfdx(n,:)
  enddo

end program ae_test2d

