program slab_Kepert
! Kepert (2010a;QJRMS) slab boundary layer model
! vgfname format : 1st column = radius, 2nd column = vg profile

  use Math_Const
  use Phys_Const
  use Basis
  use file_operate
  use derivation
  use typhoon_analy
  use max_min

  implicit none

!-- namelist variables
  integer, dimension(2) :: nnr, nnt
  double precision :: pmax, epsp, wsc, hmax, f_lat, rhob, fact
  character(3) :: stype
  character(1000) :: vgfname, oname

  integer :: i, j, k, it, nr, nt, itmp, jtmp
  double precision :: epstmp, coril
  double precision :: fu, fv, vs, cd
  double precision :: dubmax, dvbmax
  double precision, allocatable, dimension(:) :: r, f0, theta
  double precision, allocatable, dimension(:,:) :: vgf, rho0, pgf
  double precision, allocatable, dimension(:,:) :: ub, vb, wb
  double precision, allocatable, dimension(:,:) :: ubn, vbn, wbn
  double precision, allocatable, dimension(:,:) :: ube, vbe
  character(1000) :: forma
  character(100), allocatable, dimension(:,:) :: cval

  namelist /input /nnr, nnt, nt, vgfname, oname, pmax, epsp, wsc,  &
  &                hmax, f_lat, rhob, fact, stype
  read(5,nml=input)

  coril=2.0d0*omega_dp*dsin(pi_dp*f_lat/180.0d0)

  forma='(1P6E16.8)'

  nr=line_number_counter( trim(adjustl(vgfname)) )
  allocate(cval(2,nr))
  call read_file_text( trim(adjustl(vgfname)), 2, nr, cval )

  allocate(r(nr))
  allocate(f0(nr))
  allocate(theta(nt))
  allocate(vgf(nr,nt))
  allocate(pgf(nr,nt))
  allocate(rho0(nr,nt))
  allocate(ub(nr,nt))
  allocate(vb(nr,nt))
  allocate(wb(nr,nt))
  allocate(ubn(nr,nt))
  allocate(vbn(nr,nt))
  allocate(wbn(nr,nt))
  allocate(ube(nr,nt))
  allocate(vbe(nr,nt))

  rho0=rhob
  f0=coril
  ub=0.0d0
  vb=0.0d0
  wb=0.0d0
  pgf=0.0d0
  vgf=0.0d0
  r=0.0d0
  theta=(/((0.0d0+2.0*pi*real(i-1)/real(nt)),i=1,nt)/)

  do i=1,nr
     r(i)=dble( c2r_convert( trim(adjustl(cval(1,i))) ) )
     vgf(i,1:nt)=dble( c2r_convert( trim(adjustl(cval(2,i))) ) )
  end do

  vb=vgf

  do i=1,nt
     call grad_wind_pres( r(nnr(1):nnr(2)), f0(nnr(1):nnr(2)),   &
  &                       vgf(nnr(1):nnr(2),i), rho0(nnr(1):nnr(2),i),  &
  &                       r(nnr(2)), pmax, pgf(nnr(1):nnr(2),i) )
  end do

  epstmp=epsp

  do while (epstmp<=epsp)

     epsp=epstmp

     call scheme( stype(1:3), fact, hmax, coril, wsc, r, theta, ub, vb, wb,  &
  &               vgf, pgf, rho0, ubn, vbn, wbn )

     do j=1,nt
        do i=1,nr
           ube(i,j)=dabs(ub(i,j)-ubn(i,j))
           vbe(i,j)=dabs(vb(i,j)-vbn(i,j))
        end do
     end do

     call max_val_2d( ube(nnr(1)+1:nnr(2)-1,1:nt), itmp, jtmp, dubmax )
     call max_val_2d( vbe(nnr(1)+1:nnr(2)-1,1:nt), itmp, jtmp, dvbmax )
     epstmp=max(dubmax,dvbmax)

     ub=ubn
     vb=vbn
     wb=wbn

write(*,*) "epstmp, epsp", epstmp, epsp
  end do

  open(unit=10,file=trim(adjustl(oname)),status='unknown')

  write(10,'(a96)') "        'Radius'      'Radial-U'  'Tangential-V'    'Vertical-W'    'Temporal-F'    'Temporal-G'"
  write(10,'(a96)') "             'm'          'ms-1'          'ms-1'          'ms-1'    'Temporal-F'    'Temporal-G'"

  do i=nnr(1),nnr(2)
     write(10,trim(adjustl(forma))) real(r(i)), real(ub(i,1)),  &
  &                                 real(vb(i,1)), real(wb(i,1)),  &
  &                                 real(vgf(i,1)), real(pgf(i,1))
  end do

  close(unit=10)

contains

double precision function summfunc( a, bval, cval )
  implicit none
  double precision, intent(in) :: a
  double precision, intent(in) :: bval(:)
  double precision, intent(in) :: cval(size(bval))
  integer :: ib, nb
  double precision :: tmpf

  nb=size(bval)
  tmpf=a

  do ib=1,nb
     tmpf=tmpf+bval(ib)*cval(ib)
  end do

  summfunc=tmpf

  return

end function summfunc

subroutine scheme( sc_type, dt, hmax, coril, wsc, r, theta, ubo, vbo, wbo,  &
  &                vgf, pbgr, rhob, ubt, vbt, wbt )
  implicit none
  character(3), intent(in) :: sc_type  ! EU1, RK3, RK4
  double precision, intent(in) :: dt  ! factor
  double precision, intent(in) :: hmax  ! hmax
  double precision, intent(in) :: coril ! f0
  double precision, intent(in) :: wsc   ! wsc
  double precision, intent(in), dimension(:) :: r  ! radius
  double precision, intent(in), dimension(:) :: theta  ! angle
  double precision, intent(in), dimension(:,:) :: ubo  ! current ub
  double precision, intent(in), dimension(:,:) :: vbo  ! current vb
  double precision, intent(in), dimension(:,:) :: wbo  ! current wb
  double precision, intent(in), dimension(:,:) :: vgf  ! grad wind
  double precision, intent(in), dimension(:,:) :: pbgr ! pressure
  double precision, intent(in), dimension(:,:) :: rhob ! density
  double precision, intent(inout), dimension(:,:) :: ubt  ! new ub
  double precision, intent(inout), dimension(:,:) :: vbt  ! new vb
  double precision, intent(inout), dimension(:,:) :: wbt  ! new wb
  integer :: ir, jt, nr, nt
  double precision, dimension(size(r),size(theta)) :: dubdr, dvbdr, dubdt, dvbdt, dpgfdt
  double precision, dimension(size(r),size(theta)) :: ubtmp, vbtmp, wbtmp
  double precision, dimension(size(r),size(theta),4) :: forceu, forcev
  double precision, dimension(4,4) :: fck

  nr=size(r)
  nt=size(theta)

  select case (sc_type(1:3))
  case ('EU1')  ! first order Euler scheme

     fck=1.0

     do jt=1,nt
        call grad_1d( r(1:nr), ubo(1:nr,jt), dubdr(1:nr,jt) )
        call grad_1d( r(1:nr), vbo(1:nr,jt), dvbdr(1:nr,jt) )
     end do

     if(nt>1)then
        do ir=1,nr
           call grad_1d( theta(1:nt), ubo(ir,1:nt), dubdt(ir,1:nt) )
           call grad_1d( theta(1:nt), vbo(ir,1:nt), dvbdt(ir,1:nt) )
           call grad_1d( theta(1:nt), pbgr(ir,1:nt), dpgfdt(ir,1:nt) )
        end do
     else
        dubdt=0.0d0
        dvbdt=0.0d0
        dpgfdt=0.0d0
     end if

!!$omp parallel default(shared)
!!$omp do schedule(runtime) private(ir,jt,cd,vs)

     do jt=1,nt
        do ir=2,nr-1
           vs=dsqrt(ubo(ir,jt)**2+vbo(ir,jt)**2)
           cd=min(0.7d0+0.065d0*vs,2.0d0)*1.0d-3
           if(r(1)/=0.0d0)then
              forceu(ir,jt,1)=-ubo(ir,jt)*dubdr(ir,jt)  &
  &                           -vbo(ir,jt)*dubdt(ir,jt)/r(ir)  &
  &                           +ubo(ir,jt)*(min(wb(ir,jt),0.0d0)+wsc)/hmax  &
  &                           +(coril+vbo(ir,jt)/r(ir))*vbo(ir,jt)  &
  &                           -(coril+vgf(ir,jt)/r(ir))*vgf(ir,jt)  &
  &                           -cd*vs*ubo(ir,jt)/hmax
              forcev(ir,jt,1)=-ubo(ir,jt)*dvbdr(ir,jt)  &
  &                           -vbo(ir,jt)*dvbdt(ir,jt)/r(ir)  &
  &                           +(vbo(ir,jt)-vgf(ir,jt))*(min(wb(ir,jt),0.0d0)+wsc)/hmax  &
  &                           -(coril+vbo(ir,jt)/r(ir))*ubo(ir,jt)  &
  &                           -dpgfdt(ir,jt)/(r(ir)*rhob(ir,jt))  &
  &                           -cd*vs*vbo(ir,jt)/hmax
              wbt(ir,jt)=-hmax*(dubdr(ir,jt)+ubo(ir,jt)/r(ir))
           else
              forceu(ir,jt,1)=-ubo(ir,jt)*dubdr(ir,jt)  &
  &                     +ubo(ir,jt)*(min(wb(ir,jt),0.0d0)+wsc)/hmax  &
  &                     +(coril)*vbo(ir,jt)  &
  &                     -(coril)*vgf(ir,jt)  &
  &                     -cd*vs*ubo(ir,jt)/hmax
              forcev(ir,jt,1)=-ubo(ir,jt)*dvbdr(ir,jt)  &
  &                     +(vbo(ir,jt)-vgf(ir,jt))*(min(wb(ir,jt),0.0d0)+wsc)/hmax  &
  &                     -(coril)*ubo(ir,jt)  &
  &                     -cd*vs*vbo(ir,jt)/hmax
              wbt(ir,jt)=-hmax*dubdr(ir,jt)
           end if
           ubt(ir,jt)=ubo(ir,jt)+forceu(ir,jt,1)*dt
           vbt(ir,jt)=vbo(ir,jt)+forcev(ir,jt,1)*dt
        end do
     end do

!!$omp end do
!!$omp end parallel

!-- boudary condition

     do jt=1,nt
        ubt(nr,jt)=(r(nr-1)/r(nr))*ubt(nr-1,jt)
        vbt(nr,jt)=(r(nr-1)/r(nr))*vbt(nr-1,jt)
        wbt(nr,jt)=0.0d0
     end do

  case ('RK3')

     ubtmp=ubo
     vbtmp=vbo
     wbtmp=wbo

     fck=0.0d0
     fck(1,1)=0.5d0
     fck(1:2,2)=(/ 0.0d0, 0.5d0 /)
     fck(1:3,3)=(/ 0.0d0, 0.0d0, 1.0d0 /)
     fck(1:4,4)=(1.0d0/6.0d0)*(/ 1.0d0, 2.0d0, 2.0d0, 1.0d0 /)

     do k=1,4

        do jt=1,nt
           call grad_1d( r(1:nr), ubtmp(1:nr,jt), dubdr(1:nr,jt) )
           call grad_1d( r(1:nr), vbtmp(1:nr,jt), dvbdr(1:nr,jt) )
        end do

        if(nt>1)then
           do ir=1,nr
              call grad_1d( theta(1:nt), ubtmp(ir,1:nt), dubdt(ir,1:nt) )
              call grad_1d( theta(1:nt), vbtmp(ir,1:nt), dvbdt(ir,1:nt) )
              call grad_1d( theta(1:nt), pbgr(ir,1:nt), dpgfdt(ir,1:nt) )
           end do
        else
           dubdt=0.0d0
           dvbdt=0.0d0
           dpgfdt=0.0d0
        end if

!!$omp parallel default(shared)
!!$omp do schedule(runtime) private(ir,jt,cd,vs)

        do jt=1,nt
           do ir=2,nr-1
              vs=dsqrt(ubtmp(ir,jt)**2+vbtmp(ir,jt)**2)
              cd=min(0.7d0+0.065d0*vs,2.0d0)*1.0d-3
              if(r(1)/=0.0d0)then
                 forceu(ir,jt,k)=-ubtmp(ir,jt)*dubdr(ir,jt)  &
  &                              -vbtmp(ir,jt)*dubdt(ir,jt)/r(ir)  &
  &                              +ubtmp(ir,jt)*(min(wb(ir,jt),0.0d0)+wsc)/hmax  &
  &                              +(coril+vbtmp(ir,jt)/r(ir))*vbtmp(ir,jt)  &
  &                              -(coril+vgf(ir,jt)/r(ir))*vgf(ir,jt)  &
  &                              -cd*vs*ubtmp(ir,jt)/hmax
                 forcev(ir,jt,k)=-ubtmp(ir,jt)*dvbdr(ir,jt)  &
  &                              -vbtmp(ir,jt)*dvbdt(ir,jt)/r(ir)  &
  &                              +(vbtmp(ir,jt)-vgf(ir,jt))*(min(wb(ir,jt),0.0d0)+wsc)/hmax  &
  &                              -(coril+vbtmp(ir,jt)/r(ir))*ubtmp(ir,jt)  &
  &                              -dpgfdt(ir,jt)/(r(ir)*rhob(ir,jt))  &
  &                              -cd*vs*vbtmp(ir,jt)/hmax
                 wbtmp(ir,jt)=-hmax*(dubdr(ir,jt)+ubtmp(ir,jt)/r(ir))
              else
                 forceu(ir,jt,k)=-ubtmp(ir,jt)*dubdr(ir,jt)  &
  &                        +ubtmp(ir,jt)*(min(wb(ir,jt),0.0d0)+wsc)/hmax  &
  &                        +(coril)*vbtmp(ir,jt)  &
  &                        -(coril)*vgf(ir,jt)  &
  &                        -cd*vs*ubtmp(ir,jt)/hmax
                 forcev(ir,jt,k)=-ubtmp(ir,jt)*dvbdr(ir,jt)  &
  &                        +(vbtmp(ir,jt)-vgf(ir,jt))*(min(wb(ir,jt),0.0d0)+wsc)/hmax  &
  &                        -(coril)*ubtmp(ir,jt)  &
  &                        -cd*vs*vbtmp(ir,jt)/hmax
                 wbtmp(ir,jt)=-hmax*dubdr(ir,jt)
              end if
              ubtmp(ir,jt)=summfunc( ubtmp(ir,jt), fck(1:k,k), forceu(ir,jt,1:k) )
              vbtmp(ir,jt)=summfunc( vbtmp(ir,jt), fck(1:k,k), forcev(ir,jt,1:k) )
           end do
        end do

!!$omp end do
!!$omp end parallel

!-- boudary condition

        do jt=1,nt
           ubtmp(nr,jt)=(r(nr-1)/r(nr))*ubtmp(nr-1,jt)
           vbtmp(nr,jt)=(r(nr-1)/r(nr))*vbtmp(nr-1,jt)
           wbtmp(nr,jt)=0.0d0
        end do

     end do

     do jt=1,nt
        do ir=2,nr-1
           ubt(ir,jt)=summfunc( ubo(ir,jt), fck(1:4,4), forceu(ir,jt,1:4) )
           vbt(ir,jt)=summfunc( vbo(ir,jt), fck(1:4,4), forcev(ir,jt,1:4) )
        end do
     end do

     do jt=1,nt
        call grad_1d( r(1:nr), ubt(1:nr,jt), dubdr(1:nr,jt) )
     end do

     do jt=1,nt
        do ir=2,nr-1
           wbt(ir,jt)=-hmax*(dubdr(ir,jt)+ubt(ir,jt)/r(ir))
        end do
     end do

!-- boudary condition

     do jt=1,nt
        ubt(nr,jt)=(r(nr-1)/r(nr))*ubt(nr-1,jt)
        vbt(nr,jt)=(r(nr-1)/r(nr))*vbt(nr-1,jt)
        wbt(nr,jt)=0.0d0
     end do

  case ('RK4')

     ubtmp=ubo
     vbtmp=vbo
     wbtmp=wbo

     fck=0.0d0
     fck(1,1)=1.0d0/3.0d0
     fck(1:2,2)=(/ -1.0d0/3.0d0, 1.0d0 /)
     fck(1:3,3)=(/ 1.0d0, -1.0d0, 1.0d0 /)
     fck(1:4,4)=0.125d0*(/ 1.0d0, 3.0d0, 3.0d0, 1.0d0 /)

     do k=1,4

        do jt=1,nt
           call grad_1d( r(1:nr), ubtmp(1:nr,jt), dubdr(1:nr,jt) )
           call grad_1d( r(1:nr), vbtmp(1:nr,jt), dvbdr(1:nr,jt) )
        end do

        if(nt>1)then
           do ir=1,nr
              call grad_1d( theta(1:nt), ubtmp(ir,1:nt), dubdt(ir,1:nt) )
              call grad_1d( theta(1:nt), vbtmp(ir,1:nt), dvbdt(ir,1:nt) )
              call grad_1d( theta(1:nt), pbgr(ir,1:nt), dpgfdt(ir,1:nt) )
           end do
        else
           dubdt=0.0d0
           dvbdt=0.0d0
           dpgfdt=0.0d0
        end if

!!$omp parallel default(shared)
!!$omp do schedule(runtime) private(ir,jt,cd,vs)

        do jt=1,nt
           do ir=2,nr-1
              vs=dsqrt(ubtmp(ir,jt)**2+vbtmp(ir,jt)**2)
              cd=min(0.7d0+0.065d0*vs,2.0d0)*1.0d-3
              if(r(1)/=0.0d0)then
                 forceu(ir,jt,k)=-ubtmp(ir,jt)*dubdr(ir,jt)  &
  &                              -vbtmp(ir,jt)*dubdt(ir,jt)/r(ir)  &
  &                              +ubtmp(ir,jt)*(min(wb(ir,jt),0.0d0)+wsc)/hmax  &
  &                              +(coril+vbtmp(ir,jt)/r(ir))*vbtmp(ir,jt)  &
  &                              -(coril+vgf(ir,jt)/r(ir))*vgf(ir,jt)  &
  &                              -cd*vs*ubtmp(ir,jt)/hmax
                 forcev(ir,jt,k)=-ubtmp(ir,jt)*dvbdr(ir,jt)  &
  &                              -vbtmp(ir,jt)*dvbdt(ir,jt)/r(ir)  &
  &                              +(vbtmp(ir,jt)-vgf(ir,jt))*(min(wb(ir,jt),0.0d0)+wsc)/hmax  &
  &                              -(coril+vbtmp(ir,jt)/r(ir))*ubtmp(ir,jt)  &
  &                              -dpgfdt(ir,jt)/(r(ir)*rhob(ir,jt))  &
  &                              -cd*vs*vbtmp(ir,jt)/hmax
                 wbtmp(ir,jt)=-hmax*(dubdr(ir,jt)+ubtmp(ir,jt)/r(ir))
              else
                 forceu(ir,jt,k)=-ubtmp(ir,jt)*dubdr(ir,jt)  &
  &                        +ubtmp(ir,jt)*(min(wb(ir,jt),0.0d0)+wsc)/hmax  &
  &                        +(coril)*vbtmp(ir,jt)  &
  &                        -(coril)*vgf(ir,jt)  &
  &                        -cd*vs*ubtmp(ir,jt)/hmax
                 forcev(ir,jt,k)=-ubtmp(ir,jt)*dvbdr(ir,jt)  &
  &                        +(vbtmp(ir,jt)-vgf(ir,jt))*(min(wb(ir,jt),0.0d0)+wsc)/hmax  &
  &                        -(coril)*ubtmp(ir,jt)  &
  &                        -cd*vs*vbtmp(ir,jt)/hmax
                 wbtmp(ir,jt)=-hmax*dubdr(ir,jt)
              end if
              ubtmp(ir,jt)=summfunc( ubtmp(ir,jt), fck(1:k,k), forceu(ir,jt,1:k) )
              vbtmp(ir,jt)=summfunc( vbtmp(ir,jt), fck(1:k,k), forcev(ir,jt,1:k) )
           end do
        end do

!!$omp end do
!!$omp end parallel

!-- boudary condition

        do jt=1,nt
           ubtmp(nr,jt)=(r(nr-1)/r(nr))*ubtmp(nr-1,jt)
           vbtmp(nr,jt)=(r(nr-1)/r(nr))*vbtmp(nr-1,jt)
           wbtmp(nr,jt)=0.0d0
        end do

     end do

     do jt=1,nt
        do ir=2,nr-1
           ubt(ir,jt)=summfunc( ubo(ir,jt), fck(1:4,4), forceu(ir,jt,1:4) )
           vbt(ir,jt)=summfunc( vbo(ir,jt), fck(1:4,4), forcev(ir,jt,1:4) )
        end do
     end do

     do jt=1,nt
        call grad_1d( r(1:nr), ubt(1:nr,jt), dubdr(1:nr,jt) )
     end do

     do jt=1,nt
        do ir=2,nr-1
           wbt(ir,jt)=-hmax*(dubdr(ir,jt)+ubt(ir,jt)/r(ir))
        end do
     end do

!-- boudary condition

     do jt=1,nt
        ubt(nr,jt)=(r(nr-1)/r(nr))*ubt(nr-1,jt)
        vbt(nr,jt)=(r(nr-1)/r(nr))*vbt(nr-1,jt)
        wbt(nr,jt)=0.0d0
     end do

  end select

end subroutine scheme

end program
