program PPVI
! PV インバージョンを用いた台風ボーガスの初期値への埋め込みプログラム
! 座標系はすべて球面緯度経度, 圧力座標で統一.
! 気象庁配信の GPV データを念頭に置いている.

  use file_operate
  use Statistics
  use Basis
  use Thermo_Advanced_Routine

  use def_val
  use read_namelist
  use alloc_val
  use sub_calc

  implicit none

  !-- namelist variables
  character(100) :: orde, ordv
  character(10), allocatable, dimension(:) :: unite, unitv
  character(1000) :: lename, lvname

  !-- internal variables
  integer :: nle, nlv
  real, allocatable, dimension(:,:,:,:,:) :: pve, pvv
  real, allocatable, dimension(:,:,:,:) :: vale, valv
  character(1000), allocatable, dimension(:) :: fname
  character(1000), allocatable, dimension(:,:) :: ceval, cvval


  !-- reading namelist
  call read_name()

  nle=line_number_counter( triM(lename) )
  allocate(ceval(1,nle))
  call read_file_text( trim(lename), 1, nle, ceval )

  nlv=line_number_counter( triM(lvname) )
  allocate(cvval(1,nlv))
  call read_file_text( trim(lvname), 1, nlv, cvval )

  do i=1,nl
     !-- reading initial data
     fname(i)=trim(ceval(1,i))
     call read_file_3d( trim(fname(i)), nxe, nye, nze, 1, vale(:,:,:,1) )
     do l=1,nve-1
        call read_file_3d( trim(fname(i)), nxe, nye, nze, l*nze+1, vale(:,:,:,l) )
     end do
  
     call read_file_3d( trim(cvval(1,i)), nxv, nyv, nzv, 1, valv(:,:,:,1) )
     do l=1,nvv-1
        call read_file_3d( trim(cvval(1,i)), nxv, nyv, nzv, l*nzv+1, valv(:,:,:,l) )
     end do
  

     !-- converting each variables to PV
     if(moist(1:5)=='moist')then
        do i=1,nle
           call M_Ertel_PV()
        end do
        do i=1,nvl
           call M_Ertel_PV()
        end do
     else if(moist(1:3)=='dry')then
        do i=1,nle
           call Ertel_PV()
        end do
        do i=1,nlv
           call Ertel_PV()
        end do
     end if
  end do

     !-- making PV anomaly
!$omp parallel default(shared)
!$omp do private(k,j,i)

  do k=1,nze
     do j=1,nye
        do i=1,nxe
           call Move_ave( )
        end do
     end do
  end do

!$omp end do

!$omp barirer

!$omp do private(k,j,i)

  do k=1,nzv
     do j=1,nyv
        do i=1,nxv
           call Move_ave( )
        end do
     end do
  end do

!$omp end do
!$omp end parallel

  do i=1,nl
     !-- merging initial vortex and initial environment PVs

     !-- inverting PPV
     !-- 1. making initial values
     call PV2WPTQ()
     !-- 2. solving each values by QG framework (= producing initial SOR values)
     call QGPVINV()
     !-- 3. PPV inversion
     if(moist(1:5)=='moist')then
        call M_FULLPPVINV()
     else if(moist(1:3)=='dry')then
        call FULLPPVINV()
     end if

     !-- output modified initial data
     call write_file_3d( trim(fname(i))//'.out', nxe, nye, nze, 1, )
     do l=1,nv-1
        call write_file_3d( trim(fname(i))//'.out', nxe, nye, nze, l*nze+1, )
     end do
  end do

  write(*,*) "Stop. normally."

end program PPVI
