program make_init
  use gtool_history
  use max_min
  use Statistics
  use Math_Const
  use Phys_Const
  use file_operate
  use Basis
  use val_define
  use read_namelist
  use val_alloc
  use val_init
  use val_coord
  use Thermo_Function
  use typhoon_analy
  use sub_calc

  implicit none

!-- do loop 用変数の定義
  integer :: i, j, k, nl

!-- 作業用配列
  integer :: iz
  integer, dimension(4) :: iord
  real :: coer, coez, coev
  real, parameter :: r0=412.5e3
  real, dimension(:), allocatable :: ht, pr, tm, rho, qv
  real, dimension(:), allocatable :: tmpp, tmpt, tmpq, tmpr
  real, dimension(:), allocatable :: tmppz, tmprz
  real, dimension(:,:), allocatable :: rhoi, tmpc, p2_i, rho2i, v_ret, dv
  character(50), dimension(:,:), allocatable :: cval

  write(*,*) "starting program."

!-- namelist の読み込み

  call read_name()

!-- allocating array

  call val_allocate()

!-- 初期データの座標系はこちらで定義しなければならない.

  r_i=(/((rimin+dri*(i-1)),i=1,nri)/)
  z_i=(/((zimin+dzi*(i-1)),i=1,nzi)/)

!-- その他変数の配列割付
  allocate(tmpp(nzi))
  allocate(tmpt(nzi))
  allocate(tmpq(nzi))
  allocate(tmpr(nzi))
  allocate(rhoi(nri,nzi))
  allocate(p2_i(nri,nzi))
  allocate(rho2i(nri,nzi))
  allocate(v_ret(nri,nzi))
  allocate(dv(nri,nzi))
  allocate(tmpc(nri,nzi))
  allocate(tmppz(nri))
  allocate(tmprz(nri))

!-- 初期にゼロ値が入る変数のみ, 初期化してその後何もしない.
  u_i=0.0
  w_i=0.0
  ql_i=0.0
  tmpc=coril

!-- サウンディングデータから各熱力学変数の読み込み.

  nl=line_number_counter( trim(sname) )-2
  allocate(cval(4,nl))
  call read_file_text( trim(sname), 4, nl, cval, skip=2)

  allocate(ht(nl))
  allocate(pr(nl))
  allocate(tm(nl))
  allocate(qv(nl))
  allocate(rho(nl))

  do i=1,4
     select case (rord(i:i))
     case ('z')
        iord(1)=i
     case ('p')
        iord(2)=i
     case ('t')
        iord(3)=i
     case ('q')
        iord(4)=i
     end select
  end do

  do i=1,nl
     ht(i)=c2r_convert( trim(adjustl(cval(iord(1),i))) )
     pr(i)=c2r_convert( trim(adjustl(cval(iord(2),i))) )
     tm(i)=c2r_convert( trim(adjustl(cval(iord(3),i))) )
     qv(i)=c2r_convert( trim(adjustl(cval(iord(4),i))) )
     if(pr(i)/=undef.and.tm(i)/=undef)then
        ht(i)=ht(i)*sfact(1)
        pr(i)=pr(i)*sfact(2)
        tm(i)=tm(i)+sfact(3)
        rho(i)=TP_2_rho( tm(i), pr(i) )
     else
        rho(i)=undef
        write(*,*) "WARNING : detected undefined value."
        write(*,*) "undef height is ", ht(i)
     end if
     if(qv(i)/=undef)then
        qv(i)=qv(i)*sfact(4)
     else
        qv(i)=0.0
     end if
  end do

!write(*,*) "zi check", z_i
!-- サウンデイングデータを初期データで定義された鉛直高度に内挿する.
  call auto_interpolation_1d( ht, z_i, pr, tmpp, undef=undef, undefr=undef )
  call auto_interpolation_1d( ht, z_i, tm, tmpt, undef=undef, undefr=undef )
  call auto_interpolation_1d( ht, z_i, qv, tmpq, undef=undef, undefr=undef )
  call auto_interpolation_1d( ht, z_i, rho, tmpr, undef=undef, undefr=undef )

!-- 海面データがないので, 下層 2 層分から外挿を行う.
  call interpo_search_1d( z_i, ht(1), iz, undeff=0 )

  if((iz>0).and.(z_i(1)<ht(1)))then
     write(*,*) "*** WARNING (init) ***"
     write(*,*) "initial bottom is extrapolated."
     do i=1,iz
        tmpp(i)=hypsometric_form( pr(1), ht(1), tm(1), z_i(i) )
        tmpt(i)=tm(1)+6.5e-3*(ht(1)-z_i(i))
        tmpr(i)=TP_2_rho( tmpt(i), tmpp(i) )
        write(*,*) "sho check", tmpr(i), tmpt(i), tmpp(i)
!write(*,*) "ehcck", tmpt(1), tmpp(1), rho(1)
        tmpq(i)=TP_2_qvs( tmpt(i), tmpp(i) )
     end do
  end if

!-- 接線風速の計算.

  do k=1,nzi
     do j=1,nri
        if(z_i(k)<=zlim)then
           coer=r_i(j)/rvmax
           coez=(zlim-z_i(k))/zlim
           coev=((vvmax*coer)**2)  &
  &            *((2.0/(coer+1.0))**3-(2.0/(r0/rvmax+1.0))**3)  &
  &            +0.25*coril*coril*r_i(j)*r_i(j)
           if(coev>=0.0)then
              v_i(j,k)=coez*(sqrt(coev)-0.5*coril*r_i(j))
!           v_i(j,k)=coez*2.0*vvmax*coer/(1.0+coer**3)
           else
              v_i(j,k)=0.0
           end if
           if(v_i(j,k)<0.0)then
              v_i(j,k)=0.0
           end if
        else
           v_i(j,k)=0.0
        end if
     end do
  end do

!-- 静力学バランスするように調節.
  call hydro_grad_eqb_it( r_i, z_i, tmpc, v_i, tmpp, tmpr, p_i, rhoi, dl=2 )
  v_ret=v_i
  do k=1,nzi  ! もとの風速分布と比較
     do j=2,nri-1
        if(p_i(j+1,k)>=p_i(j-1,k))then
           v_ret(j,k)=0.5*(-tmpc(j,1)*r_i(j)  &
  &                     +sqrt((tmpc(j,1)*r_i(j))**2+4.0*r_i(j)*(p_i(j+1,k)-p_i(j-1,k))/((r_i(j+1)-r_i(j-1))*rhoi(j,k))))
        else
           if(tmpc(j,1)*r_i(j)<v_i(j,k))then  ! 旋衡風的 (遠心力大きい)
              v_ret(j,k)=0.5*(tmpc(j,1)*r_i(j)  &
  &                       +sqrt((tmpc(j,1)*r_i(j))**2+4.0*r_i(j)*abs(p_i(j+1,k)-p_i(j-1,k))/((r_i(j+1)-r_i(j-1))*rhoi(j,k))))
           else  ! 地衡風的 (コリオリ力大きい)
              v_ret(j,k)=0.5*(tmpc(j,1)*r_i(j)  &
  &                       -sqrt((tmpc(j,1)*r_i(j))**2+4.0*r_i(j)*abs(p_i(j+1,k)-p_i(j-1,k))/((r_i(j+1)-r_i(j-1))*rhoi(j,k))))
           end if
        end if
     end do
  end do
  dv=v_i-v_ret
  !!tmppz=tmpp(nzi)
  !!tmprz=tmpr(nzi)
  !!call hydro_grad_eqb( r_i, z_i, tmpc, v_i, tmpp, tmpr, tmppz, tmprz, p2_i, rho2i, dl=2 )

  do k=1,nzi
     do j=1,nri
        t_i(j,k)=theta_dry( rhoP_2_T( rhoi(j,k), p_i(j,k) ), p_i(j,k) )
!        t_i(j,k)=t_i(j,k)+10.0*exp(-1.0e-10*((r_i(j)-r_i(nri/2))**2)-1.0e-6*((z_i(k)-z_i(nzi/4))**2))
!if(k<3)then
!        write(*,*) t_i(j,k), rhoP_2_T( rhoi(j,k), p_i(j,k) ), p_i(j,k), rhoi(j,k)
!end if
        qv_i(j,k)=tmpq(k)
     end do
  end do

!-- 出力ファイルの初期化
  call HistoryCreate( file=trim(finame), title='RE87 result data', &
  & source='test', institution='test', dims=(/'r', 'z'/),  &
  & dimsizes=(/nri, nzi/),  & 
  & longnames=(/'R-coordinate','Z-coordinate'/),  &
  & units=(/'m', 'm'/) )
  
  call HistoryPut( 'r', r_i(1:nri) )
  call HistoryPut( 'z', z_i(1:nzi) )
  
  call HistoryAddVariable( varname='u', dims=(/'r','z'/), &
    & longname='R wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='v', dims=(/'r','z'/), &
    & longname='T wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='w', dims=(/'r','z'/), &
    & longname='Z wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='p', dims=(/'r','z'/), &
    & longname='Pressure', units='1', xtype='float')

  call HistoryAddVariable( varname='rho', dims=(/'r','z'/), &
    & longname='Density', units='1', xtype='float')

  call HistoryAddVariable( varname='t', dims=(/'r','z'/), &
    & longname='Potential Temperature', units='K', xtype='float')

  call HistoryAddVariable( varname='qv', dims=(/'r','z'/), &
    & longname='Vapor Mixing Ratio', units='kg kg-1', xtype='float')

  call HistoryAddVariable( varname='ql', dims=(/'r','z'/), &
    & longname='Condensation Mixing Ratio', units='kg kg-1', xtype='float')

  call HistoryAddVariable( varname='vret', dims=(/'r','z'/), &
    & longname='Retrieved T wind', units='1', xtype='float')

  call HistoryAddVariable( varname='dv', dims=(/'r','z'/), &
    & longname='Difference between v and vret', units='1', xtype='float')

!-- 初期値ファイルへの入力

  call HistoryPut( 'u', u_i(1:nri,1:nzi) )
  call HistoryPut( 'v', v_i(1:nri,1:nzi) )
  call HistoryPut( 'w', w_i(1:nri,1:nzi) )
  call HistoryPut( 'p', p_i(1:nri,1:nzi) )
  call HistoryPut( 'rho', rhoi(1:nri,1:nzi) )
  call HistoryPut( 't', t_i(1:nri,1:nzi) )
  call HistoryPut( 'qv', qv_i(1:nri,1:nzi) )
  call HistoryPut( 'ql', ql_i(1:nri,1:nzi) )
  call HistoryPut( 'vret', v_ret(1:nri,1:nzi) )
  call HistoryPut( 'dv', dv(1:nri,1:nzi) )

!-- ストップ

  write(*,*) "program normally stops."

end program
