!= ̤
!
!= Set cloud amount
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: set_cloud.F90,v 1.1 2010-01-11 01:28:12 yot Exp $
! Tag Name::  $Name: dcpam5-20100224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module set_cloud
  !
  != ̤
  !
  != Set cloud amount
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ʬۤ.
  !
  ! In this module, the amount of cloud or cloud optical depth are set.
  ! This module is under development and is still a preliminary version. 
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: ͥեåη׻
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
  !
  !== NAMELIST
  !
  ! NAMELIST#set_cloud_nml
  !

  ! ⥸塼 ; USE statements

  !
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ.
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ.
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ.
                             ! Number of vertical level

  implicit none

  private

  real(DP), save        :: FactorCondToCloudSW
                           ! A constant to be used to convert liquid water production 
                           ! rate in a layer to cloud optical depth in short wave 
                           ! radiation.
  real(DP), save        :: FactorCondToCloudLW
                           ! A constant to be used to convert liquid water production 
                           ! rate in a layer to cloud optical depth in long wave 
                           ! radiation.
  logical , save        :: FlagCloud
                           ! A flag for cloud set.
                           ! If FlagCloud is true, the effect of cloud is considered.
                           ! It should be noticed that in principle 
                           ! FlagCloud = .false. is equivalent to 
                           ! FactorCondToCloudSW = FactorCondToCloudLW = 0.
                           ! So, this variable is verbose.

  real(DP), allocatable :: xy_PRCPSave       (:,:)
  real(DP), allocatable :: xyz_DelPRCPCumSave(:,:,:)
  real(DP), allocatable :: xyz_DelPRCPLSCSave(:,:,:)
  real(DP), allocatable :: xyz_DTempDtCumSave(:,:,:)
  real(DP), allocatable :: xyz_DPDtSave      (:,:,:)

  logical , save        :: prcpcum_registered = .false.
  logical , save        :: prcplsc_registered = .false.
  logical , save        :: dpdt_registered    = .false.


  character(*), parameter:: saturate_scheme = &
#ifdef LIB_SATURATE_NHA1992
    & 'Nakajima et al. (1992)'
#elif LIB_SATURATE_T1930
    & 'Tetens (1930)'
#else
    & 'Tetens (1930)'
#endif


  ! ѿ
  ! Public variables
  !
  logical, save, public:: set_cloud_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  public :: SetCloudSW
  public :: SetCloudLW
  public :: SetCloudRegistPRCPCum
  public :: SetCloudRegistPRCPLSC
  public :: SetCloudRegistDPDt

  character(*), parameter:: module_name = 'set_cloud'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20100224 $' // &
    & '$Id: set_cloud.F90,v 1.1 2010-01-11 01:28:12 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine SetCloudSW(                                     &
    & xyz_Press, xyr_Press, xyz_Temp, xyz_QVap, xyz_Height,  &
    & xyz_CloudDelOptDep                                     &
    & )

    ! USE statements
    !

    !
    ! Physical constants settings
    !
    use constants, only: Grav,  & ! $ g $ [m s-2].
                                  !
                                  ! Gravitational acceleration
      &                  PI       ! $ \pi $ .
                                  ! Circular constant

    use radiation_two_stream_app, only: RadiationTwoStreamApp

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ.
                              ! Time of step $ t $.
      & EndTime, &            ! ׻λ.
                              ! End time of calculation
      & TimesetClockStart, TimesetClockStop

    real(DP), intent(in ) :: xyz_Press         ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in ) :: xyr_Press         ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP), intent(in ) :: xyz_Temp          ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in ) :: xyz_QVap          ( 0:imax-1, 1:jmax, 1:kmax )
                              ! $ q $ .   . Mass mixing ratio of constituents (1)
    real(DP), intent(in ) :: xyz_Height        ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(out) :: xyz_CloudDelOptDep( 0:imax-1, 1:jmax, 1:kmax )



    real(DP)            :: xyz_DelLWP     ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP)            :: xyr_CloudOptDep( 0:imax-1, 1:jmax, 0:kmax )

    integer  :: i
    integer  :: j
    integer  :: k
    integer  :: l


    ! 
    ! Initialization
    !
    if ( .not. set_cloud_inited ) call SetCloudInit



    ! Cloud optical depth
    !
    if ( .not. FlagCloud ) then

      xyz_DelLWP         = 0.0d0
      xyz_CloudDelOptDep = 0.0d0

    else

!!$    call RadiationDcpamSWEV1CalcLWP( &
!!$      & xyz_Press, xyr_Press, xyz_Temp, xyz_QVap, xyz_Height, &
!!$      & xyz_DelLWP   &
!!$      & )
!!$
!!$      ! This calculation is based Equation (1) of Slingo (1989) and values of 
!!$      ! ai = 2.7d-2 m2 g-1, bi = 1.3 micron m2 g-1, and r_{eff} = 10 micron.
!!$      !
!!$      xyz_CloudDelOptDep = xyz_DelLWP * ( 2.7d-2 * 1.0d3 + 1.3d0 * 1.0d3 / 10.0d0 )


!!$      write( 6, * ) 'Cloud optical depth is calculated by precipitation rate.'
      do k = 1, kmax
        do j = 1, jmax
          do i = 0, imax-1
            if ( ( xyz_DelPRCPCumSave(i,j,k) + xyz_DelPRCPLSCSave(i,j,k) ) > 0.0d0 ) then
              xyz_DelLWP(i,j,k) = &
                &   ( xyz_DelPRCPCumSave(i,j,k) + xyz_DelPRCPLSCSave(i,j,k) ) &
                & * FactorCondToCloudSW
            else
              xyz_DelLWP(i,j,k) = 0.0d0
            end if
          end do
        end do
      end do


      xyz_CloudDelOptDep = xyz_DelLWP


    end if


    ! ҥȥǡ
    ! History data output
    !
    xyr_CloudOptDep(:,:,kmax) = 0.0d0
    do k = kmax-1, 0, -1
      xyr_CloudOptDep(:,:,k) = xyr_CloudOptDep(:,:,k+1) + xyz_CloudDelOptDep(:,:,k+1)
    end do
    call HistoryAutoPut( TimeN, 'CODSW'   , xyr_CloudOptDep(:,:,0) )
    call HistoryAutoPut( TimeN, 'DelCODSW', xyz_CloudDelOptDep     )


  end subroutine SetCloudSW

  !--------------------------------------------------------------------------------------

  subroutine SetCloudLW(    &
    & xyz_CloudDelOptDep    &
    & )

    ! USE statements
    !

    !
    ! Physical constants settings
    !
    use constants, only: Grav,  & ! $ g $ [m s-2].
                                  !
                                  ! Gravitational acceleration
      &                  PI       ! $ \pi $ .
                                  ! Circular constant

    use radiation_two_stream_app, only: RadiationTwoStreamApp

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ.
                              ! Time of step $ t $.
      & EndTime, &            ! ׻λ.
                              ! End time of calculation
      & TimesetClockStart, TimesetClockStop

    real(DP), intent(out) :: xyz_CloudDelOptDep( 0:imax-1, 1:jmax, 1:kmax )


    real(DP)            :: xyz_DelLWP     ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP)            :: xyr_CloudOptDep( 0:imax-1, 1:jmax, 0:kmax )

    integer  :: i
    integer  :: j
    integer  :: k
    integer  :: l


    ! 
    ! Initialization
    !
    if ( .not. set_cloud_inited ) call SetCloudInit



    ! Cloud optical depth
    !
    if ( .not. FlagCloud ) then

      xyz_DelLWP         = 0.0d0
      xyz_CloudDelOptDep = 0.0d0

    else

!!$      write( 6, * ) 'Cloud optical depth is calculated by precipitation rate.'
      do k = 1, kmax
        do j = 1, jmax
          do i = 0, imax-1
            if ( ( xyz_DelPRCPCumSave(i,j,k) + xyz_DelPRCPLSCSave(i,j,k) ) > 0.0d0 ) then
              xyz_DelLWP(i,j,k) = &
                &   ( xyz_DelPRCPCumSave(i,j,k) + xyz_DelPRCPLSCSave(i,j,k) ) &
                & * FactorCondToCloudLW
            else
              xyz_DelLWP(i,j,k) = 0.0d0
            end if
          end do
        end do
      end do


      xyz_CloudDelOptDep = xyz_DelLWP

    end if


    ! ҥȥǡ
    ! History data output
    !
    xyr_CloudOptDep(:,:,kmax) = 0.0d0
    do k = kmax-1, 0, -1
      xyr_CloudOptDep(:,:,k) = xyr_CloudOptDep(:,:,k+1) + xyz_CloudDelOptDep(:,:,k+1)
    end do
    call HistoryAutoPut( TimeN, 'CODLW'   , xyr_CloudOptDep(:,:,0) )
    call HistoryAutoPut( TimeN, 'DelCODLW', xyz_CloudDelOptDep     )


  end subroutine SetCloudLW

  !--------------------------------------------------------------------------------------

  subroutine SetCloudRegistPRCPCum( &
!!$    & xy_Rain, xyz_DelRain, xyz_DTempDt        &
    & xyz_DelRain &
    & )

!!$    real(DP), intent(in) :: xy_Rain    ( 0:imax-1, 1:jmax )
    real(DP), intent(in) :: xyz_DelRain( 0:imax-1, 1:jmax, 1:kmax )
!!$    real(DP), intent(in) :: xyz_DTempDt( 0:imax-1, 1:jmax, 1:kmax )


    ! 
    ! Initialization
    !
    if ( .not. set_cloud_inited ) call SetCloudInit


!!$    xy_PRCPSave         = xy_Rain
    xyz_DelPRCPCumSave  = xyz_DelRain
!!$    xyz_DTempDtCumSave  = xyz_DTempDt


    prcpcum_registered = .true.

  end subroutine SetCloudRegistPRCPCum

  !--------------------------------------------------------------------------------------

  subroutine SetCloudRegistPRCPLSC( &
!!$    & xy_Rain, xyz_DelRain, xyz_DTempDt        &
    & xyz_DelRain & ! (in)
    & )

!!$    real(DP), intent(in) :: xy_Rain    ( 0:imax-1, 1:jmax )
    real(DP), intent(in) :: xyz_DelRain( 0:imax-1, 1:jmax, 1:kmax )
!!$    real(DP), intent(in) :: xyz_DTempDt( 0:imax-1, 1:jmax, 1:kmax )


    ! 
    ! Initialization
    !
    if ( .not. set_cloud_inited ) call SetCloudInit


!!$    xy_PRCPSave         = xy_Rain
    xyz_DelPRCPLSCSave  = xyz_DelRain
!!$    xyz_DTempDtCumSave  = xyz_DTempDt


    prcplsc_registered = .true.

  end subroutine SetCloudRegistPRCPLSC

  !--------------------------------------------------------------------------------------

  subroutine SetCloudRegistDPDt( &
    & xyz_DPDt                              &
    & )

    real(DP), intent(in) :: xyz_DPDt( 0:imax-1, 1:jmax, 1:kmax )


    ! 
    ! Initialization
    !
    if ( .not. set_cloud_inited ) call SetCloudInit


    xyz_DPDtSave  = xyz_DPDt


    dpdt_registered = .true.

  end subroutine SetCloudRegistDPDt

  !--------------------------------------------------------------------------------------

  subroutine SetCloudCalcLWP(                    &
    & xyz_Press, xyr_Press, xyz_Temp, xyz_QVap, xyz_Height, &
    & xyz_DelLWP   &
    & )

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRUniv, &
                              ! $ R^{*} $ [J K-1 mol-1].
                              ! ׵.  Universal gas constant
      & Grav, &
                              ! $ g $ [m s-2].
                              ! ϲ®.
                              ! Gravitational acceleration
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1].
                              ! 絤ε.
                              ! Gas constant of air
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1].
                              ! 絤갵Ǯ.
                              ! Specific heat of air at constant pressure
      & GasRWet, &
                              ! $ R_v $ [J kg-1 K-1].
                              ! ŷʬε.
                              ! Gas constant of condensible elements
      & LatentHeat, &
                              ! $ L $ [J kg-1] .
                              ! ŷǮ.
                              ! Latent heat of condensation
      & EpsV
                              ! $ \epsilon_v $ .
                              ! ʬ.
                              ! Molecular weight of water vapor

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ.
                              ! Time of step $ t $.
      & EndTime, &            ! ׻λ.
                              ! End time of calculation
      & TimesetClockStart, TimesetClockStop


    real(DP), intent(in ) :: xyz_Press ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in ) :: xyr_Press ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP), intent(in ) :: xyz_Temp  ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in ) :: xyz_QVap  ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in ) :: xyz_Height( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(out) :: xyz_DelLWP( 0:imax-1, 1:jmax, 1:kmax )


    integer  :: xy_NumCloudLayer      ( 0:imax-1, 1:jmax )
    real(DP) :: xy_CloudCoverTot      ( 0:imax-1, 1:jmax )
    real(DP) :: xy_CloudCoverEachLayer( 0:imax-1, 1:jmax )
    real(DP) :: xyz_CloudCover        ( 0:imax-1, 1:jmax, 1:kmax )

    real(DP):: xyz_QVapSat            ( 0:imax-1, 1:jmax, 1:kmax )
                              ! ˰漾.
                              ! Saturation specific humidity.

    real(DP):: xyz_RH                 ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP):: xyz_RHCor              ( 0:imax-1, 1:jmax, 1:kmax )

    real(DP), parameter :: CloudLiqWatDen0 = 0.18d-3
    real(DP)            :: xy_ColWatVapor           ( 0:imax-1, 1:jmax )
    real(DP)            :: xy_CloudLiqWatScaleHeight( 0:imax-1, 1:jmax )
    real(DP)            :: xyz_CloudLiqWatDen       ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP)            :: xyz_DelCloudLiqWat       ( 0:imax-1, 1:jmax, 1:kmax )

    integer  :: i
    integer  :: j
    integer  :: k


    ! ˰漾׻Τʸؿ
    ! Declaration of statement function for
    !   calculation of saturation specific humidity
    !
#ifdef LIB_SATURATE_NHA1992
#include "../saturate/saturate_nha1992_sf.f90"
    EpsVSF     = EpsV
    GasRUnivSF = GasRUniv
#elif LIB_SATURATE_T1930
#include "../saturate/saturate_t1930_sf.f90"
    EpsVSF    = EpsV
    LatHeatSF = LatentHeat
    GasRWetSF = GasRWet
#else
#include "../saturate/saturate_t1930_sf.f90"
    EpsVSF    = EpsV
    LatHeatSF = LatentHeat
    GasRWetSF = GasRWet
#endif


    ! 
    ! Initialization
    !
    if ( .not. set_cloud_inited ) call SetCloudInit


    ! ˰漾׻
    ! Calculate saturation specific humidity
    !

    ! Nakajima et al. (1992) Ѥ˰漾η׻
    ! Calculate saturation specific humidity with Nakajima et al. (1992)
    !
    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          ! CalcQVapSatSF ʸؿ. (¹ʸľ)
          ! "CalcQVapSatSF" is statement function and
          !   is declared just before executable statement.
          !
          xyz_QVapSat(i,j,k) = &
            & CalcQVapSatSF( xyz_Temp(i,j,k), xyz_Press(i,j,k) )
        end do
      end do
    end do

    xyz_RH = xyz_QVap / xyz_QVapSat


    xy_NumCloudLayer = 0
    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          if ( xyz_DTempDtCumSave(i,j,k) > 0.0d0 ) then
            xy_NumCloudLayer = xy_NumCloudLayer + 1
          end if
        end do
      end do
    end do

    xy_CloudCoverTot = 0.0d0
    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_PRCPSave(i,j) >= 0.0d0 ) then
          xy_CloudCoverTot(i,j) = 0.20d0 &
            & + 0.125d0 * log( 1.0d0 + xy_PRCPSave(i,j) * 86400.0d0 / 1.0d3 * 1.0d3 )
        end if
      end do
    end do
    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_CloudCoverTot(i,j) > 0.8d0 ) then
          xy_CloudCoverTot(i,j) = 0.8d0
        end if
      end do
    end do
    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_NumCloudLayer(i,j) == 0 ) then
          xy_CloudCoverEachLayer(i,j) = 0.0d0
        else
          xy_CloudCoverEachLayer(i,j) = &
            & 1.0d0 - ( 1.0d0 - xy_CloudCoverTot(i,j) )**(1.0d0/xy_NumCloudLayer(i,j))
        end if
      end do
    end do

    do k = 1, kmax
      xyz_RHCor(:,:,k) =                               &
        &   ( xyz_RH(:,:,k) - xy_CloudCoverEachLayer ) &
        & / ( 1.0d0 - xy_CloudCoverEachLayer )
    end do


    xyz_CloudCover = 0.0d0

!    ! Frontal and tropical low-cloud
!    !
!    do k = 1, kmax
!      do j = 1, jmax
!        do i = 0, imax-1
!          if ( xyz_Press(i,j,k) > 750.0d2 .and. xyz_DPDtSave(i,j,k) < 0.0d0 ) then
!            xyz_CloudCover(i,j,k) = ( ( xyz_RHCor(i,j,k) - 0.9d0 ) / 0.1d0 )**2
!          end if
!        end do
!      end do
!    end do


    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          if ( ( xyz_RHCor(i,j,k) > 0.6d0 ) .and. &
            &  ( xyz_DTempDtCumSave(i,j,k) > 0.0d0 ) ) then
            xyz_CloudCover(i,j,k) = xy_CloudCoverEachLayer(i,j)
          else
            xyz_CloudCover(i,j,k) = 0.0d0
          end if
        end do
      end do
    end do




    xy_ColWatVapor = 0.0d0
    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          xy_ColWatVapor = xy_ColWatVapor &
            & + xyz_QVap(:,:,k) * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
        end do
      end do
    end do

    xy_CloudLiqWatScaleHeight = &
      &   700.0d0 * log( 1.0d0 + 1.0d0 * xy_ColWatVapor ) &
      & + 1.0d0

    do k = 1, kmax
      xyz_CloudLiqWatDen(:,:,k) = &
        & CloudLiqWatDen0 * exp( - xyz_Height(:,:,k) / xy_CloudLiqWatScaleHeight )
    end do


    do k = 1, kmax
      xyz_DelCloudLiqWat(:,:,k) = xyz_CloudLiqWatDen(:,:,k)              &
        & * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) )                    &
        & / ( xyz_Press(:,:,k) / ( GasRDry * xyz_Temp(:,:,k) ) * Grav )
    end do

    xyz_DelLWP = xyz_CloudCover * xyz_DelCloudLiqWat


    call HistoryAutoPut( TimeN, 'CloudCover', xyz_CloudCover )


  end subroutine SetCloudCalcLWP

  !--------------------------------------------------------------------------------------

  subroutine SetCloudInit

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify


    ! ʸ ; Declaration statements
    !

    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /set_cloud_nml/ &
      & FactorCondToCloudSW, &
      & FactorCondToCloudLW, &
      & FlagCloud
          !
          ! ǥեͤˤĤƤϽ³ "set_cloud#setCloudInit"
          ! Υɤ򻲾ȤΤ.
          !
          ! Refer to source codes in the initialization procedure
          ! "set_cloud#SetCloudInit" for the default values.
          !


    ! ǥեͤ
    ! Default values settings
    !

    FactorCondToCloudSW = 1.0d5
    FactorCondToCloudLW = 1.0d5
    FlagCloud           = .true.


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                     & ! (in)
        & nml = set_cloud_nml, & ! (out)
        & iostat = iostat_nml )             ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    allocate( xy_PRCPSave       ( 0:imax-1, 1:jmax ) )
    allocate( xyz_DelPRCPCumSave( 0:imax-1, 1:jmax, 1:kmax ) )
    allocate( xyz_DelPRCPLSCSave( 0:imax-1, 1:jmax, 1:kmax ) )
    allocate( xyz_DTempDtCumSave( 0:imax-1, 1:jmax, 1:kmax ) )
    allocate( xyz_DPDtSave      ( 0:imax-1, 1:jmax, 1:kmax ) )


    xy_PRCPSave        = 0.0d0
    xyz_DelPRCPCumSave = 0.0d0
    xyz_DelPRCPLSCSave = 0.0d0
    xyz_DTempDtCumSave = 0.0d0
    xyz_DPDtSave       = 0.0d0


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'CODSW', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'cloud optical depth', '1' )

    call HistoryAutoAddVariable( 'DelCODSW', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'cloud optical depth', '1' )

    call HistoryAutoAddVariable( 'CODLW', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'cloud optical depth', '1' )

    call HistoryAutoAddVariable( 'DelCODLW', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'cloud optical depth', '1' )

    call HistoryAutoAddVariable( 'CloudCover', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'cloud cover', '1' )



    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'FactorCondToCloudSW = %f', d = (/ FactorCondToCloudSW /) )
    call MessageNotify( 'M', module_name, 'FactorCondToCloudLW = %f', d = (/ FactorCondToCloudLW /) )
    call MessageNotify( 'M', module_name, 'FlagCloud           = %b', l = (/ FlagCloud /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    set_cloud_inited = .true.

  end subroutine SetCloudInit

  !--------------------------------------------------------------------------------------

end module set_cloud
